/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceLookAndFeelEx {
    public static final String COMBOBOX_AUTO_RESIZE = "substancelaf.comboxautoresize";
    public static final String HIGHLIGHT = "substancelaf.highlight";
    public static final String HIGHLIGHT_CELL = "substancelaf.highlightCells";
    public static final String VIEW_UNREAD = "substancelaf.unread";
    public static final String TAB_STRIP_COLOR = "substancelaf.tabstripcolor";
    public static final SubstanceFillPainter SIMPLE_FILL_PAINTER = new SimpleFillPainter();
    public static final SubstanceBorderPainter SIMPLE_BORDER_PAINTER = new SimpleBorderPainter();
    private static final Color LINE_COLOR = new Color(225, 225, 225);
    private static final Color MID_COLOR = new Color(230, 230, 230);
    private static final Color LIGHT_COLOR = new Color(236, 236, 236);

    public static boolean getBooleanClientProperty(Component component, Object object) {
        if (component instanceof JComponent) {
            return Boolean.TRUE.equals(((JComponent)component).getClientProperty(object));
        }
        return false;
    }

    private static class SimpleFillPainter
    implements SubstanceFillPainter {
        private SimpleFillPainter() {
        }

        @Override
        public String getDisplayName() {
            return "SimpleFillPainter";
        }

        @Override
        public void paintContourBackground(Graphics graphics, Component component, int n, int n2, Shape shape, boolean bl, SubstanceColorScheme substanceColorScheme, boolean bl2) {
            Color color;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color color2 = LINE_COLOR;
            Color color3 = color = LIGHT_COLOR;
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2 / 2 + 1, new float[]{0.0f, 0.3f, 1.0f}, new Color[]{color2, color, color3}, MultipleGradientPaint.CycleMethod.REFLECT);
            graphics2D.setPaint(linearGradientPaint);
            graphics2D.fill(shape);
            graphics2D.dispose();
        }
    }

    private static class SimpleBorderPainter
    implements SubstanceBorderPainter {
        private SimpleBorderPainter() {
        }

        @Override
        public String getDisplayName() {
            return "SimpleBorderPainter";
        }

        @Override
        public void paintBorder(Graphics graphics, Component component, int n, int n2, Shape shape, Shape shape2, SubstanceColorScheme substanceColorScheme) {
            if (shape == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Color color = LINE_COLOR;
            Color color2 = MID_COLOR;
            Color color3 = LIGHT_COLOR;
            if (color != null && color2 != null && color3 != null) {
                float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component));
                boolean bl = component instanceof SubstanceInternalArrowButton;
                int n3 = bl ? 0 : 1;
                int n4 = bl ? 2 : 0;
                graphics2D.setStroke(new BasicStroke(f, n4, n3));
                LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{color, color2, color3}, MultipleGradientPaint.CycleMethod.REPEAT);
                graphics2D.setPaint(linearGradientPaint);
                graphics2D.draw(shape);
            }
            graphics2D.dispose();
        }

        @Override
        public boolean isPaintingInnerContour() {
            return false;
        }
    }
}

