/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ColorSchemeTransform;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.painter.highlight.SubstanceHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.api.trait.SubstanceTrait;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SkinUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public abstract class SubstanceSkin
implements SubstanceTrait {
    protected Map<DecorationAreaType, SubstanceColorSchemeBundle> colorSchemeBundleMap = new HashMap<DecorationAreaType, SubstanceColorSchemeBundle>();
    protected Map<DecorationAreaType, SubstanceColorScheme> backgroundColorSchemeMap = new HashMap<DecorationAreaType, SubstanceColorScheme>();
    protected Map<DecorationAreaType, List<SubstanceOverlayPainter>> overlayPaintersMap = new HashMap<DecorationAreaType, List<SubstanceOverlayPainter>>();
    protected SubstanceWatermark watermark;
    protected SubstanceButtonShaper buttonShaper;
    protected SubstanceFillPainter fillPainter;
    protected SubstanceBorderPainter borderPainter;
    protected SubstanceBorderPainter highlightBorderPainter;
    protected SubstanceHighlightPainter highlightPainter;
    protected SubstanceDecorationPainter decorationPainter;
    protected Set<DecorationAreaType> decoratedAreaSet = new HashSet<DecorationAreaType>();
    protected double selectedTabFadeStart;
    protected double selectedTabFadeEnd;
    protected SubstanceColorScheme watermarkScheme;
    Set<ComponentState> statesWithAlpha;

    protected SubstanceSkin() {
        this.decoratedAreaSet.add(DecorationAreaType.PRIMARY_TITLE_PANE);
        this.decoratedAreaSet.add(DecorationAreaType.SECONDARY_TITLE_PANE);
        this.selectedTabFadeStart = 0.1;
        this.selectedTabFadeEnd = 0.3;
        this.statesWithAlpha = new HashSet<ComponentState>();
    }

    public final SubstanceWatermark getWatermark() {
        return this.watermark;
    }

    public final SubstanceBorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public final SubstanceBorderPainter getHighlightBorderPainter() {
        return this.highlightBorderPainter;
    }

    public final SubstanceButtonShaper getButtonShaper() {
        return this.buttonShaper;
    }

    public final SubstanceFillPainter getFillPainter() {
        return this.fillPainter;
    }

    public final SubstanceHighlightPainter getHighlightPainter() {
        return this.highlightPainter;
    }

    public final SubstanceDecorationPainter getDecorationPainter() {
        return this.decorationPainter;
    }

    public void addCustomEntriesToTable(UIDefaults uIDefaults) {
        if (uIDefaults == null) {
            return;
        }
        SkinUtilities.addCustomEntriesToTable(uIDefaults, this);
    }

    public final SubstanceColorScheme getColorScheme(Component component, ComponentState componentState) {
        Object object;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(object = SubstanceLookAndFeel.getDecorationType(component))) {
            SubstanceColorScheme substanceColorScheme = this.colorSchemeBundleMap.get(object).getColorScheme(componentState);
            if (substanceColorScheme == null) {
                throw new IllegalStateException("Color scheme shouldn't be null here. Please report this issue");
            }
            return substanceColorScheme;
        }
        object = this.colorSchemeBundleMap.get(DecorationAreaType.NONE).getColorScheme(componentState);
        if (object == null) {
            throw new IllegalStateException("Color scheme shouldn't be null here. Please report this issue");
        }
        return object;
    }

    public final float getHighlightAlpha(Component component, ComponentState componentState) {
        Float f;
        Object object;
        if (component instanceof JComponent && Boolean.FALSE.equals(((JComponent)(object = (JComponent)component)).getClientProperty("substancelaf.highlight"))) {
            return 0.0f;
        }
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(object = SubstanceLookAndFeel.getDecorationType(component)) && (double)(f = Float.valueOf(this.colorSchemeBundleMap.get(object).getHighlightAlpha(component, componentState))).floatValue() >= 0.0) {
            return f.floatValue();
        }
        object = Float.valueOf(this.colorSchemeBundleMap.get(DecorationAreaType.NONE).getHighlightAlpha(component, componentState));
        if ((double)((Float)object).floatValue() >= 0.0) {
            return ((Float)object).floatValue();
        }
        boolean bl = componentState.isFacetActive(ComponentStateFacet.ROLLOVER);
        boolean bl2 = componentState.isFacetActive(ComponentStateFacet.SELECTION);
        boolean bl3 = componentState.isFacetActive(ComponentStateFacet.ARM);
        if (bl && bl2) {
            return 0.9f;
        }
        if (bl && bl3) {
            return 0.8f;
        }
        if (bl2) {
            return 0.7f;
        }
        if (bl3) {
            return 0.6f;
        }
        if (bl) {
            return 0.4f;
        }
        return 0.0f;
    }

    public final float getAlpha(Component component, ComponentState componentState) {
        Float f;
        Object object;
        if (!this.statesWithAlpha.contains(componentState)) {
            return 1.0f;
        }
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(object = SubstanceLookAndFeel.getDecorationType(component)) && (double)(f = Float.valueOf(this.colorSchemeBundleMap.get(object).getAlpha(component, componentState))).floatValue() >= 0.0) {
            return f.floatValue();
        }
        object = Float.valueOf(this.colorSchemeBundleMap.get(DecorationAreaType.NONE).getAlpha(component, componentState));
        if ((double)((Float)object).floatValue() >= 0.0) {
            return ((Float)object).floatValue();
        }
        return 1.0f;
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle substanceColorSchemeBundle, SubstanceColorScheme substanceColorScheme, DecorationAreaType ... decorationAreaTypeArray) {
        if (substanceColorSchemeBundle == null) {
            return;
        }
        if (substanceColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (DecorationAreaType decorationAreaType : decorationAreaTypeArray) {
            this.decoratedAreaSet.add(decorationAreaType);
            this.colorSchemeBundleMap.put(decorationAreaType, substanceColorSchemeBundle);
            this.backgroundColorSchemeMap.put(decorationAreaType, substanceColorScheme);
        }
        this.statesWithAlpha.addAll(substanceColorSchemeBundle.getStatesWithAlpha());
    }

    public void registerDecorationAreaSchemeBundle(SubstanceColorSchemeBundle substanceColorSchemeBundle, DecorationAreaType ... decorationAreaTypeArray) {
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle, substanceColorSchemeBundle.getEnabledColorScheme(), decorationAreaTypeArray);
    }

    public void registerAsDecorationArea(SubstanceColorScheme substanceColorScheme, DecorationAreaType ... decorationAreaTypeArray) {
        if (substanceColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null background color scheme");
        }
        for (DecorationAreaType decorationAreaType : decorationAreaTypeArray) {
            this.decoratedAreaSet.add(decorationAreaType);
            this.backgroundColorSchemeMap.put(decorationAreaType, substanceColorScheme);
        }
    }

    public boolean isRegisteredAsDecorationArea(DecorationAreaType decorationAreaType) {
        return this.decoratedAreaSet.contains(decorationAreaType);
    }

    public SubstanceColorScheme getWatermarkColorScheme() {
        if (this.watermarkScheme != null) {
            return this.watermarkScheme;
        }
        return this.colorSchemeBundleMap.get(DecorationAreaType.NONE).getEnabledColorScheme();
    }

    public final SubstanceColorScheme getActiveColorScheme(DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getActiveColorScheme();
        }
        return this.colorSchemeBundleMap.get(DecorationAreaType.NONE).getActiveColorScheme();
    }

    public final SubstanceColorScheme getEnabledColorScheme(DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getEnabledColorScheme();
        }
        return this.colorSchemeBundleMap.get(DecorationAreaType.NONE).getEnabledColorScheme();
    }

    public final SubstanceColorScheme getDisabledColorScheme(DecorationAreaType decorationAreaType) {
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getDisabledColorScheme();
        }
        return this.colorSchemeBundleMap.get(DecorationAreaType.NONE).getDisabledColorScheme();
    }

    public final double getSelectedTabFadeStart() {
        return this.selectedTabFadeStart;
    }

    public final double getSelectedTabFadeEnd() {
        return this.selectedTabFadeEnd;
    }

    public void setSelectedTabFadeEnd(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Value for selected tab fade end should be in 0.0-1.0 range");
        }
        this.selectedTabFadeEnd = d;
    }

    public void setSelectedTabFadeStart(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Value for selected tab fade start should be in 0.0-1.0 range");
        }
        this.selectedTabFadeStart = d;
    }

    public void addOverlayPainter(SubstanceOverlayPainter substanceOverlayPainter, DecorationAreaType ... decorationAreaTypeArray) {
        for (DecorationAreaType decorationAreaType : decorationAreaTypeArray) {
            if (!this.overlayPaintersMap.containsKey(decorationAreaType)) {
                this.overlayPaintersMap.put(decorationAreaType, new ArrayList());
            }
            this.overlayPaintersMap.get(decorationAreaType).add(substanceOverlayPainter);
        }
    }

    public void removeOverlayPainter(SubstanceOverlayPainter substanceOverlayPainter, DecorationAreaType ... decorationAreaTypeArray) {
        for (DecorationAreaType decorationAreaType : decorationAreaTypeArray) {
            if (!this.overlayPaintersMap.containsKey(decorationAreaType)) {
                return;
            }
            this.overlayPaintersMap.get(decorationAreaType).remove(substanceOverlayPainter);
            if (this.overlayPaintersMap.get(decorationAreaType).size() != 0) continue;
            this.overlayPaintersMap.remove(decorationAreaType);
        }
    }

    public List<SubstanceOverlayPainter> getOverlayPainters(DecorationAreaType decorationAreaType) {
        if (!this.overlayPaintersMap.containsKey(decorationAreaType)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.overlayPaintersMap.get(decorationAreaType));
    }

    public final SubstanceColorScheme getColorScheme(DecorationAreaType decorationAreaType, ColorSchemeAssociationKind colorSchemeAssociationKind, ComponentState componentState) {
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType)) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(colorSchemeAssociationKind, componentState);
        }
        return this.colorSchemeBundleMap.get(DecorationAreaType.NONE).getColorScheme(colorSchemeAssociationKind, componentState);
    }

    public final SubstanceColorScheme getColorScheme(Component component, ColorSchemeAssociationKind colorSchemeAssociationKind, ComponentState componentState) {
        DecorationAreaType decorationAreaType;
        if (this.colorSchemeBundleMap.size() > 1 && this.colorSchemeBundleMap.containsKey(decorationAreaType = SubstanceLookAndFeel.getDecorationType(component))) {
            return this.colorSchemeBundleMap.get(decorationAreaType).getColorScheme(colorSchemeAssociationKind, componentState);
        }
        return this.colorSchemeBundleMap.get(DecorationAreaType.NONE).getColorScheme(colorSchemeAssociationKind, componentState);
    }

    public SubstanceSkin transform(ColorSchemeTransform colorSchemeTransform, final String string) {
        SubstanceSkin substanceSkin = new SubstanceSkin(){

            @Override
            public String getDisplayName() {
                return string;
            }
        };
        substanceSkin.borderPainter = this.borderPainter;
        substanceSkin.buttonShaper = this.buttonShaper;
        substanceSkin.decorationPainter = this.decorationPainter;
        substanceSkin.fillPainter = this.fillPainter;
        substanceSkin.highlightPainter = this.highlightPainter;
        substanceSkin.highlightBorderPainter = this.highlightBorderPainter;
        substanceSkin.watermark = this.watermark;
        if (this.watermarkScheme != null) {
            substanceSkin.watermarkScheme = colorSchemeTransform.transform(this.watermarkScheme);
        }
        substanceSkin.selectedTabFadeEnd = this.selectedTabFadeEnd;
        substanceSkin.selectedTabFadeStart = this.selectedTabFadeStart;
        if (this.colorSchemeBundleMap != null) {
            substanceSkin.colorSchemeBundleMap = new HashMap<DecorationAreaType, SubstanceColorSchemeBundle>();
            for (Map.Entry<DecorationAreaType, SubstanceColorSchemeBundle> entry : this.colorSchemeBundleMap.entrySet()) {
                substanceSkin.colorSchemeBundleMap.put(entry.getKey(), entry.getValue().transform(colorSchemeTransform));
            }
        }
        if (this.decoratedAreaSet != null) {
            substanceSkin.decoratedAreaSet = new HashSet<DecorationAreaType>(this.decoratedAreaSet);
        }
        if (this.backgroundColorSchemeMap != null) {
            substanceSkin.backgroundColorSchemeMap = new HashMap<DecorationAreaType, SubstanceColorScheme>();
            for (Map.Entry<DecorationAreaType, Object> entry : this.backgroundColorSchemeMap.entrySet()) {
                substanceSkin.backgroundColorSchemeMap.put(entry.getKey(), colorSchemeTransform.transform((SubstanceColorScheme)entry.getValue()));
            }
        }
        substanceSkin.overlayPaintersMap = new HashMap<DecorationAreaType, List<SubstanceOverlayPainter>>(this.overlayPaintersMap);
        return substanceSkin;
    }

    public final SubstanceColorScheme getBackgroundColorScheme(DecorationAreaType decorationAreaType) {
        SubstanceColorScheme substanceColorScheme;
        if (this.backgroundColorSchemeMap.containsKey(decorationAreaType)) {
            return this.backgroundColorSchemeMap.get(decorationAreaType);
        }
        if (this.colorSchemeBundleMap.containsKey(decorationAreaType) && (substanceColorScheme = this.colorSchemeBundleMap.get(decorationAreaType).getEnabledColorScheme()) != null) {
            return substanceColorScheme;
        }
        return this.backgroundColorSchemeMap.get(DecorationAreaType.NONE);
    }

    public boolean isValid() {
        if (!this.colorSchemeBundleMap.containsKey(DecorationAreaType.NONE)) {
            return false;
        }
        if (this.getButtonShaper() == null) {
            return false;
        }
        if (this.getFillPainter() == null) {
            return false;
        }
        if (this.getBorderPainter() == null) {
            return false;
        }
        if (this.getHighlightPainter() == null) {
            return false;
        }
        return this.getDecorationPainter() != null;
    }

    public static ColorSchemes getColorSchemes(URL uRL) {
        return SubstanceColorSchemeUtilities.getColorSchemes(uRL);
    }

    public static ColorSchemes getColorSchemes(String string) {
        ClassLoader classLoader = SubstanceCoreUtilities.getClassLoaderForResources();
        return SubstanceColorSchemeUtilities.getColorSchemes(classLoader.getResource(string));
    }

    public static class ColorSchemes {
        private List<SubstanceColorScheme> schemes = new ArrayList<SubstanceColorScheme>();

        public ColorSchemes() {
        }

        public ColorSchemes(List<SubstanceColorScheme> list) {
            this();
            this.schemes.addAll(list);
        }

        public int size() {
            return this.schemes.size();
        }

        public SubstanceColorScheme get(int n) {
            return this.schemes.get(n);
        }

        public SubstanceColorScheme get(String string) {
            for (SubstanceColorScheme substanceColorScheme : this.schemes) {
                if (!substanceColorScheme.getDisplayName().equals(string)) continue;
                return substanceColorScheme;
            }
            return null;
        }

        private int indexOf(String string) {
            for (int i = 0; i < this.schemes.size(); ++i) {
                SubstanceColorScheme substanceColorScheme = this.schemes.get(i);
                if (!substanceColorScheme.getDisplayName().equals(string)) continue;
                return i;
            }
            return -1;
        }

        public void replace(String string, SubstanceColorScheme substanceColorScheme) {
            int n = this.indexOf(string);
            if (n >= 0) {
                this.schemes.remove(n);
                this.schemes.add(n, substanceColorScheme);
            }
        }

        public void delete(String string) {
            int n = this.indexOf(string);
            if (n >= 0) {
                this.schemes.remove(n);
            }
        }

        public void add(SubstanceColorScheme substanceColorScheme) {
            this.schemes.add(substanceColorScheme);
        }

        public void switchWithPrevious(String string) {
            int n = this.indexOf(string);
            if (n >= 0) {
                SubstanceColorScheme substanceColorScheme = this.schemes.remove(n);
                this.schemes.add(n - 1, substanceColorScheme);
            }
        }

        public void switchWithNext(String string) {
            int n = this.indexOf(string);
            if (n >= 0) {
                SubstanceColorScheme substanceColorScheme = this.schemes.remove(n);
                this.schemes.add(n + 1, substanceColorScheme);
            }
        }
    }
}

