/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.SchemeDerivedColorsResolver;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.DerivedColorsResolverDark;
import org.pushingpixels.substance.api.colorscheme.DerivedColorsResolverLight;
import org.pushingpixels.substance.internal.colorscheme.HueShiftColorScheme;
import org.pushingpixels.substance.internal.colorscheme.InvertedColorScheme;
import org.pushingpixels.substance.internal.colorscheme.NegatedColorScheme;
import org.pushingpixels.substance.internal.colorscheme.SaturatedColorScheme;
import org.pushingpixels.substance.internal.colorscheme.ShadeColorScheme;
import org.pushingpixels.substance.internal.colorscheme.ShiftColorScheme;
import org.pushingpixels.substance.internal.colorscheme.TintColorScheme;
import org.pushingpixels.substance.internal.colorscheme.ToneColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public abstract class BaseColorScheme
implements SubstanceColorScheme {
    protected boolean isDark;
    protected String displayName;
    protected SchemeDerivedColorsResolver derivedColorsResolver;

    protected BaseColorScheme(String string, boolean bl) {
        this(string, bl, bl ? DerivedColorsResolverDark.INSTANCE : DerivedColorsResolverLight.INSTANCE);
    }

    protected BaseColorScheme(String string, SchemeDerivedColorsResolver schemeDerivedColorsResolver) {
        this(string, schemeDerivedColorsResolver.isDark(), schemeDerivedColorsResolver);
    }

    private BaseColorScheme(String string, boolean bl, SchemeDerivedColorsResolver schemeDerivedColorsResolver) {
        if (schemeDerivedColorsResolver == null) {
            throw new NullPointerException("derivedColorsResolver cannot be null");
        }
        this.displayName = string;
        this.isDark = bl;
        this.derivedColorsResolver = schemeDerivedColorsResolver;
    }

    protected static SchemeDerivedColorsResolver getResolver(SubstanceColorScheme substanceColorScheme) {
        if (substanceColorScheme instanceof BaseColorScheme) {
            return ((BaseColorScheme)substanceColorScheme).derivedColorsResolver;
        }
        return substanceColorScheme.isDark() ? DerivedColorsResolverDark.INSTANCE : DerivedColorsResolverLight.INSTANCE;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final boolean isDark() {
        return this.isDark;
    }

    @Override
    public final SubstanceColorScheme shift(Color color, double d, Color color2, double d2) {
        return new ShiftColorScheme(this, color, d, color2, d2, true);
    }

    @Override
    public final SubstanceColorScheme shiftBackground(Color color, double d) {
        return this.shift(color, d, null, 0.0);
    }

    @Override
    public SubstanceColorScheme tint(double d) {
        return new TintColorScheme(this, d);
    }

    @Override
    public SubstanceColorScheme tone(double d) {
        return new ToneColorScheme(this, d);
    }

    @Override
    public SubstanceColorScheme shade(double d) {
        return new ShadeColorScheme(this, d);
    }

    @Override
    public SubstanceColorScheme saturate(double d) {
        return new SaturatedColorScheme(this, d);
    }

    @Override
    public SubstanceColorScheme invert() {
        return new InvertedColorScheme(this);
    }

    @Override
    public SubstanceColorScheme negate() {
        return new NegatedColorScheme(this);
    }

    @Override
    public SubstanceColorScheme hueShift(double d) {
        return new HueShiftColorScheme(this, d);
    }

    @Override
    public final Color getBackgroundFillColor() {
        return this.derivedColorsResolver.getBackgroundFillColor(this);
    }

    @Override
    public final Color getFocusRingColor() {
        return this.derivedColorsResolver.getFocusRingColor(this);
    }

    @Override
    public final Color getLineColor() {
        return this.derivedColorsResolver.getLineColor(this);
    }

    @Override
    public final Color getSelectionForegroundColor() {
        return this.derivedColorsResolver.getSelectionForegroundColor(this);
    }

    @Override
    public final Color getSelectionBackgroundColor() {
        return this.derivedColorsResolver.getSelectionBackgroundColor(this);
    }

    @Override
    public final Color getWatermarkDarkColor() {
        return this.derivedColorsResolver.getWatermarkDarkColor(this);
    }

    @Override
    public final Color getWatermarkLightColor() {
        return this.derivedColorsResolver.getWatermarkLightColor(this);
    }

    @Override
    public final Color getWatermarkStampColor() {
        return this.derivedColorsResolver.getWatermarkStampColor(this);
    }

    @Override
    public final Color getTextBackgroundFillColor() {
        return this.derivedColorsResolver.getTextBackgroundFillColor(this);
    }

    @Override
    public final SubstanceColorScheme named(String string) {
        this.displayName = string;
        return this;
    }

    public String toString() {
        return this.getDisplayName() + " {\n    kind=" + (this.isDark() ? "Dark" : "Light") + "\n    colorUltraLight=" + SubstanceColorUtilities.encode(this.getUltraLightColor()) + "\n    colorExtraLight=" + SubstanceColorUtilities.encode(this.getExtraLightColor()) + "\n    colorLight=" + SubstanceColorUtilities.encode(this.getLightColor()) + "\n    colorMid=" + SubstanceColorUtilities.encode(this.getMidColor()) + "\n    colorDark=" + SubstanceColorUtilities.encode(this.getDarkColor()) + "\n    colorUltraDark=" + SubstanceColorUtilities.encode(this.getUltraDarkColor()) + "\n    colorForeground=" + SubstanceColorUtilities.encode(this.getForegroundColor()) + "\n}";
    }
}

