/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.SchemeDerivedColorsResolver;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.DerivedColorsResolverLight;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

class DerivedColorsResolverDark
implements SchemeDerivedColorsResolver {
    static final DerivedColorsResolverDark INSTANCE = new DerivedColorsResolverDark();

    DerivedColorsResolverDark() {
    }

    @Override
    public boolean isDark() {
        return true;
    }

    @Override
    public SchemeDerivedColorsResolver invert() {
        return DerivedColorsResolverLight.INSTANCE;
    }

    @Override
    public Color getWatermarkStampColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getAlphaColor(substanceColorScheme.getUltraLightColor(), 30);
    }

    @Override
    public Color getWatermarkDarkColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getLightColor();
    }

    @Override
    public Color getWatermarkLightColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getUltraLightColor();
    }

    @Override
    public Color getLineColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getMidColor();
    }

    @Override
    public Color getSelectionForegroundColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getUltraDarkColor().darker();
    }

    @Override
    public Color getSelectionBackgroundColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getUltraLightColor().brighter();
    }

    @Override
    public Color getBackgroundFillColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getDarkColor().brighter();
    }

    @Override
    public Color getFocusRingColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getUltraDarkColor();
    }

    @Override
    public Color getTextBackgroundFillColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getMidColor(), substanceColorScheme.getLightColor(), 0.4);
    }
}

