/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.SchemeDerivedColorsResolver;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.DerivedColorsResolverDark;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class DerivedColorsResolverLight
implements SchemeDerivedColorsResolver {
    static final DerivedColorsResolverLight INSTANCE = new DerivedColorsResolverLight();

    @Override
    public boolean isDark() {
        return false;
    }

    @Override
    public SchemeDerivedColorsResolver invert() {
        return DerivedColorsResolverDark.INSTANCE;
    }

    @Override
    public Color getWatermarkStampColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getAlphaColor(substanceColorScheme.getMidColor(), 50);
    }

    @Override
    public Color getWatermarkLightColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getLightColor();
    }

    @Override
    public Color getWatermarkDarkColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getAlphaColor(substanceColorScheme.getDarkColor(), 15);
    }

    @Override
    public Color getLineColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getMidColor(), substanceColorScheme.getDarkColor(), 0.7);
    }

    @Override
    public Color getSelectionForegroundColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getUltraDarkColor().darker().darker();
    }

    @Override
    public Color getSelectionBackgroundColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getExtraLightColor();
    }

    @Override
    public Color getBackgroundFillColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getExtraLightColor();
    }

    @Override
    public Color getFocusRingColor(SubstanceColorScheme substanceColorScheme) {
        return substanceColorScheme.getDarkColor();
    }

    @Override
    public Color getTextBackgroundFillColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getInterpolatedColor(substanceColorScheme.getUltraLightColor(), substanceColorScheme.getExtraLightColor(), 0.8);
    }
}

