/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.fonts;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import org.pushingpixels.lafwidget.utils.LookUtils;
import org.pushingpixels.substance.api.fonts.FontPolicy;
import org.pushingpixels.substance.api.fonts.FontSet;
import org.pushingpixels.substance.internal.fonts.DefaultGnomeFontPolicy;
import org.pushingpixels.substance.internal.fonts.DefaultKDEFontPolicy;
import org.pushingpixels.substance.internal.fonts.DefaultMacFontPolicy;
import org.pushingpixels.substance.internal.fonts.FontPolicies;
import org.pushingpixels.substance.internal.fonts.ScaledFontSet;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceFontUtilities {
    public static FontPolicy getDefaultFontPolicy() {
        Object object;
        FontPolicy fontPolicy = FontPolicies.getDefaultPlasticPolicy();
        boolean bl = false;
        try {
            bl = DefaultKDEFontPolicy.isKDERunning();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (LookUtils.IS_OS_WINDOWS) {
            fontPolicy = FontPolicies.getDefaultWindowsPolicy();
        } else if (LookUtils.IS_OS_MAC) {
            fontPolicy = new DefaultMacFontPolicy();
        } else if (bl) {
            fontPolicy = new DefaultKDEFontPolicy();
        } else {
            try {
                object = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("sun.desktop");
                    }
                });
                if ("gnome".equals(object)) {
                    fontPolicy = new DefaultGnomeFontPolicy();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        SubstanceSizeUtils.resetPointsToPixelsRatio(fontPolicy);
        object = FontPolicies.customSettingsPolicy(fontPolicy);
        if (LookUtils.IS_OS_MAC || bl) {
            return object;
        }
        return new FontPolicy((FontPolicy)object){
            final /* synthetic */ FontPolicy val$fontPolicy;
            {
                this.val$fontPolicy = fontPolicy;
            }

            @Override
            public FontSet getFontSet(String string, UIDefaults uIDefaults) {
                FontSet fontSet = this.val$fontPolicy.getFontSet(string, uIDefaults);
                SubstanceFontSet substanceFontSet = new SubstanceFontSet(fontSet);
                return substanceFontSet;
            }
        };
    }

    public static FontPolicy getScaledFontPolicy(final float f) {
        final FontSet fontSet = SubstanceFontUtilities.getDefaultFontPolicy().getFontSet("Substance", null);
        FontPolicy fontPolicy = new FontPolicy(){

            @Override
            public FontSet getFontSet(String string, UIDefaults uIDefaults) {
                return new ScaledFontSet(fontSet, f);
            }
        };
        return fontPolicy;
    }

    private static class SubstanceFontSet
    implements FontSet {
        private FontSet systemFontSet;

        public SubstanceFontSet(FontSet fontSet) {
            this.systemFontSet = fontSet;
        }

        private FontUIResource getSubstanceFont(FontUIResource fontUIResource) {
            return fontUIResource;
        }

        private FontUIResource getSubstanceFont(FontUIResource fontUIResource, boolean bl, int n) {
            boolean bl2 = fontUIResource.isItalic();
            int n2 = fontUIResource.getStyle();
            if (bl) {
                n2 = bl2 ? 3 : 1;
            }
            return new FontUIResource(fontUIResource.deriveFont((float)(fontUIResource.getSize() + n)).deriveFont(n2));
        }

        @Override
        public FontUIResource getControlFont() {
            return this.getSubstanceFont(this.systemFontSet.getControlFont());
        }

        @Override
        public FontUIResource getMenuFont() {
            return this.getSubstanceFont(this.systemFontSet.getMenuFont());
        }

        @Override
        public FontUIResource getMessageFont() {
            return this.getSubstanceFont(this.systemFontSet.getMessageFont());
        }

        @Override
        public FontUIResource getSmallFont() {
            return this.getSubstanceFont(this.systemFontSet.getSmallFont(), false, 1);
        }

        @Override
        public FontUIResource getTitleFont() {
            return this.getSubstanceFont(this.systemFontSet.getTitleFont());
        }

        @Override
        public FontUIResource getWindowTitleFont() {
            return this.getSubstanceFont(this.systemFontSet.getWindowTitleFont(), true, 1);
        }
    }
}

