/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import org.pushingpixels.substance.api.ColorSchemeTransform;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.StandardBorderPainter;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class DelegateBorderPainter
extends StandardBorderPainter {
    protected String displayName;
    protected StandardBorderPainter delegate;
    protected int topMask;
    protected int midMask;
    protected int bottomMask;
    protected ColorSchemeTransform transform;
    protected static final LazyResettableHashMap<SubstanceColorScheme> transformMap = new LazyResettableHashMap("DelegateBorderPainter");

    public DelegateBorderPainter(String string, StandardBorderPainter standardBorderPainter, ColorSchemeTransform colorSchemeTransform) {
        this(string, standardBorderPainter, -1, -1, -1, colorSchemeTransform);
    }

    public DelegateBorderPainter(String string, StandardBorderPainter standardBorderPainter, int n, int n2, int n3, ColorSchemeTransform colorSchemeTransform) {
        this.displayName = string;
        this.delegate = standardBorderPainter;
        this.topMask = n;
        this.midMask = n2;
        this.bottomMask = n3;
        this.transform = colorSchemeTransform;
    }

    @Override
    public Color getTopBorderColor(SubstanceColorScheme substanceColorScheme) {
        return new Color(this.topMask & this.delegate.getTopBorderColor(substanceColorScheme).getRGB(), true);
    }

    @Override
    public Color getMidBorderColor(SubstanceColorScheme substanceColorScheme) {
        return new Color(this.midMask & this.delegate.getMidBorderColor(substanceColorScheme).getRGB(), true);
    }

    @Override
    public Color getBottomBorderColor(SubstanceColorScheme substanceColorScheme) {
        return new Color(this.bottomMask & this.delegate.getBottomBorderColor(substanceColorScheme).getRGB(), true);
    }

    @Override
    public void paintBorder(Graphics graphics, Component component, int n, int n2, Shape shape, Shape shape2, SubstanceColorScheme substanceColorScheme) {
        super.paintBorder(graphics, component, n, n2, shape, shape2, this.getShiftScheme(substanceColorScheme));
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    private SubstanceColorScheme getShiftScheme(SubstanceColorScheme substanceColorScheme) {
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(substanceColorScheme.getDisplayName(), this.getDisplayName(), this.transform);
        SubstanceColorScheme substanceColorScheme2 = transformMap.get(hashMapKey);
        if (substanceColorScheme2 == null) {
            substanceColorScheme2 = this.transform.transform(substanceColorScheme);
            transformMap.put(hashMapKey, substanceColorScheme2);
        }
        return substanceColorScheme2;
    }
}

