/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.decoration;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;

public abstract class ImageWrapperDecorationPainter
implements SubstanceDecorationPainter {
    protected Image originalTile = null;
    protected SubstanceDecorationPainter baseDecorationPainter;
    protected LinkedHashMap<String, Image> colorizedTileMap = new LinkedHashMap<String, Image>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Image> entry) {
            return this.size() > 10;
        }
    };
    protected float textureAlpha = 0.3f;

    @Override
    public void paintDecorationArea(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        if (decorationAreaType == DecorationAreaType.PRIMARY_TITLE_PANE || decorationAreaType == DecorationAreaType.SECONDARY_TITLE_PANE) {
            this.paintTitleBackground(graphics2D, component, decorationAreaType, n, n2, substanceSkin);
        } else {
            this.paintExtraBackground(graphics2D, component, decorationAreaType, n, n2, substanceSkin);
        }
    }

    private void paintTitleBackground(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        SubstanceColorScheme substanceColorScheme = substanceSkin.getBackgroundColorScheme(decorationAreaType);
        if (this.baseDecorationPainter == null) {
            graphics2D.setColor(substanceColorScheme.getMidColor());
            graphics2D.fillRect(0, 0, n, n2);
        } else {
            this.baseDecorationPainter.paintDecorationArea(graphics2D, component, decorationAreaType, n, n2, substanceSkin);
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        this.tileArea(graphics2D2, component, substanceColorScheme, 0, 0, 0, 0, n, n2);
        graphics2D2.dispose();
    }

    private void paintExtraBackground(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        Point point = SubstancePainterUtils.getOffsetInRootPaneCoords(component);
        SubstanceColorScheme substanceColorScheme = substanceSkin.getBackgroundColorScheme(decorationAreaType);
        if (this.baseDecorationPainter != null) {
            this.baseDecorationPainter.paintDecorationArea(graphics2D, component, decorationAreaType, n, n2, substanceSkin);
        } else {
            graphics2D.setColor(substanceColorScheme.getMidColor());
            graphics2D.fillRect(0, 0, n, n2);
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        this.tileArea(graphics2D2, component, substanceColorScheme, point.x, point.y, 0, 0, n, n2);
        graphics2D2.dispose();
    }

    protected void tileArea(Graphics2D graphics2D, Component component, SubstanceColorScheme substanceColorScheme, int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setComposite(LafWidgetUtilities.getAlphaComposite((Component)component, (float)this.textureAlpha, (Graphics)graphics2D));
        Image image = this.getColorizedTile(substanceColorScheme);
        int n7 = image.getWidth(null);
        int n8 = image.getHeight(null);
        n %= n7;
        int n9 = -(n2 %= n8);
        do {
            int n10 = -n;
            do {
                graphics2D2.drawImage(image, n10, n9, null);
            } while ((n10 += n7) < n5);
        } while ((n9 += n8) < n6);
        graphics2D2.dispose();
    }

    public void setBaseDecorationPainter(SubstanceDecorationPainter substanceDecorationPainter) {
        this.baseDecorationPainter = substanceDecorationPainter;
    }

    public void setTextureAlpha(float f) {
        this.textureAlpha = f;
    }

    protected Image getColorizedTile(SubstanceColorScheme substanceColorScheme) {
        Image image = this.colorizedTileMap.get(substanceColorScheme.getDisplayName());
        if (image == null) {
            BufferedImage bufferedImage = new BufferedImage(this.originalTile.getWidth(null), this.originalTile.getHeight(null), 2);
            bufferedImage.getGraphics().drawImage(this.originalTile, 0, 0, null);
            image = SubstanceImageCreator.getColorSchemeImage(bufferedImage, substanceColorScheme, 0.0f);
            this.colorizedTileMap.put(substanceColorScheme.getDisplayName(), image);
        }
        return image;
    }
}

