/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.SteelBlueColorScheme;
import org.pushingpixels.substance.api.painter.border.GlassBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.ArcDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.substance.api.painter.highlight.GlassHighlightPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.skin.CopyMutableColorScheme;
import org.pushingpixels.substance.internal.colorscheme.BlendBiColorScheme;

public class CeruleanSkin
extends SubstanceSkin {
    public static final String NAME = "Cerulean";

    public CeruleanSkin() {
        SubstanceSkin.ColorSchemes colorSchemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/nebula.colorschemes");
        SubstanceColorScheme substanceColorScheme = colorSchemes.get("Nebula Active");
        SubstanceColorScheme substanceColorScheme2 = colorSchemes.get("Nebula Enabled").saturate(-0.9);
        SubstanceColorScheme substanceColorScheme3 = colorSchemes.get("Nebula Pressed");
        SubstanceColorScheme substanceColorScheme4 = colorSchemes.get("Nebula Rollover Selected");
        SubstanceColorScheme substanceColorScheme5 = colorSchemes.get("Nebula Disabled").saturate(-0.9);
        SubstanceColorSchemeBundle substanceColorSchemeBundle = new SubstanceColorSchemeBundle(substanceColorScheme, substanceColorScheme2, substanceColorScheme5);
        CopyMutableColorScheme copyMutableColorScheme = new CopyMutableColorScheme("Cerulean Hover", new SteelBlueColorScheme().tint(0.4));
        copyMutableColorScheme.setForegroundColor(substanceColorScheme2.getForegroundColor());
        double d = 0.1;
        double d2 = 0.4;
        double d3 = d2 / 4.0;
        CopyMutableColorScheme copyMutableColorScheme2 = new CopyMutableColorScheme("Cerulean Pressed", copyMutableColorScheme.saturate(d).shade(d3));
        substanceColorSchemeBundle.registerColorScheme((SubstanceColorScheme)copyMutableColorScheme2, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        substanceColorSchemeBundle.registerColorScheme((SubstanceColorScheme)new BlendBiColorScheme(copyMutableColorScheme, substanceColorScheme5, 0.25), ComponentState.DISABLED_SELECTED);
        substanceColorSchemeBundle.registerColorScheme(copyMutableColorScheme.tint(d2).saturate(d), ComponentState.SELECTED);
        substanceColorSchemeBundle.registerColorScheme(copyMutableColorScheme.shade(d3 / 2.0).saturate(d / 2.0), ComponentState.ROLLOVER_SELECTED);
        substanceColorSchemeBundle.registerColorScheme(copyMutableColorScheme.tint(d2 / 2.0).saturate(d / 2.0), ComponentState.ROLLOVER_UNSELECTED);
        substanceColorSchemeBundle.registerColorScheme(copyMutableColorScheme.shade(0.5), ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        substanceColorSchemeBundle.registerColorScheme((SubstanceColorScheme)copyMutableColorScheme, ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        ComponentState componentState = new ComponentState("determinate enabled", new ComponentStateFacet[]{ComponentStateFacet.ENABLE, ComponentStateFacet.DETERMINATE, ComponentStateFacet.SELECTION}, null);
        ComponentState componentState2 = new ComponentState("determinate disabled", new ComponentStateFacet[]{ComponentStateFacet.DETERMINATE, ComponentStateFacet.SELECTION}, new ComponentStateFacet[]{ComponentStateFacet.ENABLE});
        ComponentState componentState3 = new ComponentState("indeterminate enabled", new ComponentStateFacet[]{ComponentStateFacet.ENABLE, ComponentStateFacet.SELECTION}, new ComponentStateFacet[]{ComponentStateFacet.DETERMINATE});
        ComponentState componentState4 = new ComponentState("indeterminate disabled", null, new ComponentStateFacet[]{ComponentStateFacet.DETERMINATE, ComponentStateFacet.ENABLE, ComponentStateFacet.SELECTION});
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme4, componentState, componentState3);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme4, ColorSchemeAssociationKind.BORDER, componentState, componentState3);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme5, componentState2, componentState4);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme5, ColorSchemeAssociationKind.BORDER, componentState2, componentState4);
        ComponentState componentState5 = new ComponentState("editable", new ComponentStateFacet[]{ComponentStateFacet.ENABLE, ComponentStateFacet.EDITABLE}, null);
        ComponentState componentState6 = new ComponentState("uneditable", componentState5, new ComponentStateFacet[]{ComponentStateFacet.ENABLE}, new ComponentStateFacet[]{ComponentStateFacet.EDITABLE});
        substanceColorSchemeBundle.registerColorScheme(substanceColorSchemeBundle.getColorScheme(componentState5), ColorSchemeAssociationKind.FILL, componentState6);
        SubstanceSkin.ColorSchemes colorSchemes2 = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/kitchen-sink.colorschemes");
        SubstanceColorScheme substanceColorScheme6 = colorSchemes2.get("Moderate Highlight");
        substanceColorSchemeBundle.registerHighlightColorScheme(substanceColorScheme6, new ComponentState[0]);
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle, DecorationAreaType.NONE);
        CopyMutableColorScheme copyMutableColorScheme3 = new CopyMutableColorScheme("Cerulean Chrome", substanceColorScheme3);
        copyMutableColorScheme3.setUltraDarkColor(copyMutableColorScheme3.getExtraLightColor());
        this.registerDecorationAreaSchemeBundle(new SubstanceColorSchemeBundle(substanceColorScheme3, substanceColorScheme3, substanceColorScheme5), copyMutableColorScheme3, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE);
        this.registerAsDecorationArea(substanceColorScheme2, DecorationAreaType.PRIMARY_TITLE_PANE_INACTIVE, DecorationAreaType.SECONDARY_TITLE_PANE_INACTIVE);
        this.registerAsDecorationArea(substanceColorScheme.saturate(-0.75), DecorationAreaType.HEADER, DecorationAreaType.FOOTER, DecorationAreaType.GENERAL);
        this.buttonShaper = new ClassicButtonShaper();
        this.fillPainter = new ClassicFillPainter();
        this.decorationPainter = new ArcDecorationPainter();
        this.highlightPainter = new GlassHighlightPainter();
        this.borderPainter = new GlassBorderPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

