/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.animation;

import java.awt.Component;
import java.awt.Container;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;

public class RootPaneDefaultButtonTracker
extends UIThreadTimelineCallbackAdapter {
    private static WeakHashMap<JButton, RootPaneDefaultButtonTracker> trackers = new WeakHashMap();
    private WeakReference<JButton> buttonRef;
    private Timeline timeline;

    private RootPaneDefaultButtonTracker(JButton jButton) {
        this.buttonRef = new WeakReference<JButton>(jButton);
        this.timeline = new Timeline((Object)this);
        this.timeline.addCallback((TimelineCallback)this);
        trackers.put(jButton, this);
    }

    private static boolean isInFocusedWindow(Component component) {
        if (component == null) {
            return false;
        }
        if (component.isFocusOwner()) {
            return true;
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                if (!RootPaneDefaultButtonTracker.isInFocusedWindow(component2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasGlassPane(Component component) {
        if (component == null) {
            return false;
        }
        Component component2 = null;
        if (component instanceof JDialog) {
            component2 = ((JDialog)component).getGlassPane();
        }
        if (component instanceof JFrame) {
            component2 = ((JFrame)component).getGlassPane();
        }
        return component2 != null && component2.isVisible();
    }

    public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
        this.onTimelineEvent();
    }

    public void onTimelinePulse(float f, float f2) {
        this.onTimelineEvent();
    }

    void onTimelineEvent() {
        JButton jButton = (JButton)this.buttonRef.get();
        if (jButton == null) {
            return;
        }
        if (!jButton.isDisplayable()) {
            this.timeline.abort();
            return;
        }
        if (RootPaneDefaultButtonTracker.hasGlassPane(jButton.getTopLevelAncestor())) {
            return;
        }
        if (!RootPaneDefaultButtonTracker.isPulsating(jButton)) {
            RootPaneDefaultButtonTracker rootPaneDefaultButtonTracker = trackers.get(jButton);
            rootPaneDefaultButtonTracker.stopTimer();
            rootPaneDefaultButtonTracker.buttonRef.clear();
            trackers.remove(jButton);
        } else if (!RootPaneDefaultButtonTracker.isInFocusedWindow(jButton.getTopLevelAncestor())) {
            RootPaneDefaultButtonTracker.update(jButton);
        } else if (!jButton.isEnabled()) {
            if (this.timeline.getState() != Timeline.TimelineState.SUSPENDED) {
                this.timeline.suspend();
            }
        } else if (this.timeline.getState() == Timeline.TimelineState.SUSPENDED) {
            this.timeline.resume();
        }
        if (SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            jButton.repaint();
        }
    }

    private void startTimer() {
        this.timeline.playLoop(Timeline.RepeatBehavior.REVERSE);
    }

    private void stopTimer() {
        this.timeline.cancel();
    }

    private boolean isRunning() {
        Timeline.TimelineState timelineState = this.timeline.getState();
        return timelineState == Timeline.TimelineState.PLAYING_FORWARD || timelineState == Timeline.TimelineState.PLAYING_REVERSE;
    }

    public static void update(JButton jButton) {
        if (jButton == null) {
            return;
        }
        boolean bl = RootPaneDefaultButtonTracker.isInFocusedWindow(jButton.getTopLevelAncestor());
        RootPaneDefaultButtonTracker rootPaneDefaultButtonTracker = trackers.get(jButton);
        if (!bl) {
            if (rootPaneDefaultButtonTracker == null) {
                return;
            }
        } else {
            if (rootPaneDefaultButtonTracker != null) {
                rootPaneDefaultButtonTracker.startTimer();
                return;
            }
            rootPaneDefaultButtonTracker = new RootPaneDefaultButtonTracker(jButton);
            rootPaneDefaultButtonTracker.startTimer();
            trackers.put(jButton, rootPaneDefaultButtonTracker);
        }
    }

    public static float getTimelinePosition(JButton jButton) {
        RootPaneDefaultButtonTracker rootPaneDefaultButtonTracker = trackers.get(jButton);
        if (rootPaneDefaultButtonTracker == null) {
            return 0.0f;
        }
        return rootPaneDefaultButtonTracker.timeline.getTimelinePosition();
    }

    public static boolean isAnimating(JButton jButton) {
        RootPaneDefaultButtonTracker rootPaneDefaultButtonTracker = trackers.get(jButton);
        if (rootPaneDefaultButtonTracker == null) {
            return false;
        }
        return rootPaneDefaultButtonTracker.isRunning();
    }

    static String getMemoryUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PulseTracker: \n");
        stringBuffer.append("\t" + trackers.size() + " trackers");
        return stringBuffer.toString();
    }

    public static boolean isPulsating(JButton jButton) {
        boolean bl = jButton.isDefaultButton();
        return bl;
    }

    public static void stopAllTimers() {
        for (RootPaneDefaultButtonTracker rootPaneDefaultButtonTracker : trackers.values()) {
            rootPaneDefaultButtonTracker.stopTimer();
        }
    }
}

