/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.animation;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.renderers.SubstanceRenderer;
import org.pushingpixels.substance.internal.animation.IconGlowTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionEvent;
import org.pushingpixels.substance.internal.animation.StateTransitionListener;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.TimelineCallbackAdapter;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class StateTransitionTracker {
    JComponent component;
    private ButtonModel model;
    private ChangeListener modelChangeListener;
    private Timeline transitionTimeline;
    private float transitionPosition;
    private FocusListener focusListener;
    private Timeline focusTimeline;
    private Timeline focusLoopTimeline;
    private IconGlowTracker iconGlowTracker;
    private RepaintCallback repaintCallback;
    private boolean isAutoTrackingModelChanges;
    private EventListenerList eventListenerList;
    private String name;
    private ModelStateInfo modelStateInfo;

    public StateTransitionTracker(final JComponent jComponent, ButtonModel buttonModel) {
        this.component = jComponent;
        this.model = buttonModel;
        this.modelStateInfo = new ModelStateInfo();
        this.modelStateInfo.currState = ComponentState.getState(buttonModel, jComponent);
        this.modelStateInfo.currStateNoSelection = ComponentState.getState(buttonModel, jComponent, true);
        this.modelStateInfo.clear();
        this.repaintCallback = new RepaintCallback(){

            public SwingRepaintCallback getRepaintCallback() {
                return new SwingRepaintCallback((Component)jComponent);
            }
        };
        this.isAutoTrackingModelChanges = true;
        this.eventListenerList = new EventListenerList();
        this.focusTimeline = new Timeline((Object)this.component);
        AnimationConfigurationManager.getInstance().configureTimeline(this.focusTimeline);
        this.focusTimeline.addCallback(this.repaintCallback.getRepaintCallback());
        this.focusTimeline.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                StateTransitionTracker.this.fireFocusStateTransitionEvent(timelineState, timelineState2);
            }
        });
        this.focusLoopTimeline = new Timeline((Object)this.component);
        AnimationConfigurationManager.getInstance().configureTimeline(this.focusLoopTimeline);
        this.focusLoopTimeline.addCallback(this.repaintCallback.getRepaintCallback());
        this.iconGlowTracker = new IconGlowTracker(this.component);
        this.name = "";
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setRepaintCallback(RepaintCallback repaintCallback) {
        this.repaintCallback = repaintCallback;
    }

    public void registerFocusListeners() {
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                StateTransitionTracker.this.setFocusState(true);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StateTransitionTracker.this.setFocusState(false);
            }
        };
        this.component.addFocusListener(this.focusListener);
    }

    public void registerModelListeners() {
        this.modelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (StateTransitionTracker.this.isAutoTrackingModelChanges) {
                    StateTransitionTracker.this.onModelStateChanged();
                }
            }
        };
        this.model.addChangeListener(this.modelChangeListener);
    }

    public void unregisterFocusListeners() {
        this.component.removeFocusListener(this.focusListener);
        this.focusListener = null;
    }

    public void unregisterModelListeners() {
        this.model.removeChangeListener(this.modelChangeListener);
        this.modelChangeListener = null;
    }

    public void setTransitionPosition(float f) {
        this.transitionPosition = f;
    }

    public void setModel(ButtonModel buttonModel) {
        this.model.removeChangeListener(this.modelChangeListener);
        if (this.transitionTimeline != null) {
            this.transitionTimeline.abort();
            this.transitionPosition = 0.0f;
        }
        this.modelStateInfo.currState = ComponentState.getState(buttonModel, this.component);
        this.modelStateInfo.currStateNoSelection = ComponentState.getState(buttonModel, this.component, true);
        this.modelStateInfo.clear();
        this.model = buttonModel;
        this.model.addChangeListener(this.modelChangeListener);
        this.component.repaint();
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void turnOffModelChangeTracking() {
        this.isAutoTrackingModelChanges = false;
    }

    public void onModelStateChanged() {
        this.isAutoTrackingModelChanges = true;
        ComponentState componentState = ComponentState.getState(this.model, this.component);
        ComponentState componentState2 = ComponentState.getState(this.model, this.component, true);
        boolean bl = this.component.getClass().isAnnotationPresent(SubstanceRenderer.class);
        if (!bl) {
            for (Container container = this.component.getParent(); container != null; container = container.getParent()) {
                if (!CellRendererPane.class.isInstance(container) && !ListCellRenderer.class.isInstance(container) && !TreeCellRenderer.class.isInstance(container) && !TableCellRenderer.class.isInstance(container)) continue;
                bl = true;
                break;
            }
        }
        if (bl || this.component.getParent() == null) {
            this.modelStateInfo.currState = componentState;
            this.modelStateInfo.currStateNoSelection = componentState2;
            this.modelStateInfo.clear();
            return;
        }
        if (this.modelStateInfo.currState == componentState) {
            return;
        }
        if (this.transitionTimeline != null) {
            this.transitionTimeline.abort();
        }
        this.transitionTimeline = new Timeline((Object)this);
        this.transitionTimeline.setName("Model transitions");
        this.transitionTimeline.addCallback(this.repaintCallback.getRepaintCallback());
        AnimationConfigurationManager.getInstance().configureTimeline(this.transitionTimeline);
        if (!this.modelStateInfo.currState.isFacetActive(ComponentStateFacet.SELECTION) && componentState.isFacetActive(ComponentStateFacet.SELECTION)) {
            this.transitionTimeline.setDuration(this.transitionTimeline.getDuration() / 2L);
        }
        long l = this.transitionTimeline.getDuration();
        if (this.modelStateInfo.stateContributionMap.containsKey(componentState)) {
            this.transitionPosition = this.modelStateInfo.stateContributionMap.get(componentState).getContribution();
            this.transitionTimeline.addPropertyToInterpolate("transitionPosition", (Object)Float.valueOf(this.transitionPosition), (Object)Float.valueOf(1.0f));
            this.transitionTimeline.setDuration((long)((float)l * (1.0f - this.transitionPosition)));
        } else {
            this.transitionPosition = 0.0f;
            this.transitionTimeline.addPropertyToInterpolate("transitionPosition", (Object)Float.valueOf(0.0f), (Object)Float.valueOf(1.0f));
        }
        HashMap<ComponentState, StateContributionInfo> hashMap = new HashMap<ComponentState, StateContributionInfo>();
        if (this.modelStateInfo.stateContributionMap.containsKey(componentState)) {
            for (Map.Entry<ComponentState, StateContributionInfo> iterator : this.modelStateInfo.stateContributionMap.entrySet()) {
                StateContributionInfo stateContributionInfo = iterator.getValue();
                ComponentState componentState3 = iterator.getKey();
                float f = componentState3 == componentState ? 1.0f : 0.0f;
                hashMap.put(componentState3, new StateContributionInfo(stateContributionInfo.curr, f));
            }
        } else {
            for (Map.Entry<ComponentState, StateContributionInfo> bl2 : this.modelStateInfo.stateContributionMap.entrySet()) {
                StateContributionInfo stateContributionInfo = bl2.getValue();
                ComponentState componentState4 = bl2.getKey();
                hashMap.put(componentState4, new StateContributionInfo(stateContributionInfo.curr, 0.0f));
            }
            hashMap.put(componentState, new StateContributionInfo(0.0f, 1.0f));
        }
        this.modelStateInfo.stateContributionMap = hashMap;
        HashMap hashMap2 = new HashMap();
        if (this.modelStateInfo.stateNoSelectionContributionMap.containsKey(componentState2)) {
            for (Map.Entry<ComponentState, StateContributionInfo> entry : this.modelStateInfo.stateNoSelectionContributionMap.entrySet()) {
                StateContributionInfo stateContributionInfo = entry.getValue();
                ComponentState componentState5 = entry.getKey();
                float f = componentState5 == componentState2 ? 1.0f : 0.0f;
                hashMap2.put(componentState5, new StateContributionInfo(stateContributionInfo.curr, f));
            }
        } else {
            for (Map.Entry<ComponentState, StateContributionInfo> entry : this.modelStateInfo.stateNoSelectionContributionMap.entrySet()) {
                StateContributionInfo stateContributionInfo = entry.getValue();
                ComponentState componentState6 = entry.getKey();
                hashMap2.put(componentState6, new StateContributionInfo(stateContributionInfo.curr, 0.0f));
            }
            hashMap2.put(componentState2, new StateContributionInfo(0.0f, 1.0f));
        }
        this.modelStateInfo.stateNoSelectionContributionMap = hashMap2;
        this.modelStateInfo.sync();
        this.transitionTimeline.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(final Timeline.TimelineState timelineState, final Timeline.TimelineState timelineState2, final float f, final float f2) {
                if (timelineState2 == Timeline.TimelineState.DONE) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StateTransitionTracker.this.modelStateInfo.clear();
                            StateTransitionTracker.this.repaintCallback.getRepaintCallback().onTimelineStateChanged(timelineState, timelineState2, f, f2);
                        }
                    });
                }
            }
        });
        this.transitionTimeline.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(final Timeline.TimelineState timelineState, final Timeline.TimelineState timelineState2, float f, float f2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StateTransitionTracker.this.fireModelStateTransitionEvent(timelineState, timelineState2);
                    }
                });
            }
        });
        this.transitionTimeline.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (StateTransitionTracker.this.component instanceof JMenuItem) {
                            if (SubstanceCoreUtilities.isCoveredByLightweightPopups(StateTransitionTracker.this.component)) {
                                StateTransitionTracker.this.component.putClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups", Boolean.TRUE);
                            } else {
                                StateTransitionTracker.this.component.putClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups", null);
                            }
                        }
                    }
                });
            }

            public void onTimelinePulse(float f, float f2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (StateTransitionTracker.this.component instanceof JMenuItem) {
                            if (SubstanceCoreUtilities.isCoveredByLightweightPopups(StateTransitionTracker.this.component)) {
                                StateTransitionTracker.this.component.putClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups", Boolean.TRUE);
                            } else {
                                StateTransitionTracker.this.component.putClientProperty("substancelaf.internal.paint.isCoveredByLightweightPopups", null);
                            }
                        }
                    }
                });
            }
        });
        this.transitionTimeline.addCallback((TimelineCallback)new TimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                this.updateActiveStates(f2);
            }

            public void onTimelinePulse(float f, float f2) {
                this.updateActiveStates(f2);
            }

            private void updateActiveStates(final float f) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (StateContributionInfo stateContributionInfo : StateTransitionTracker.this.modelStateInfo.stateContributionMap.values()) {
                            stateContributionInfo.updateContribution(f);
                        }
                        for (StateContributionInfo stateContributionInfo : StateTransitionTracker.this.modelStateInfo.stateNoSelectionContributionMap.values()) {
                            stateContributionInfo.updateContribution(f);
                        }
                        StateTransitionTracker.this.modelStateInfo.sync();
                    }
                });
            }
        });
        this.modelStateInfo.currState = componentState;
        this.modelStateInfo.currStateNoSelection = componentState2;
        this.transitionTimeline.play();
        if (AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.ICON_GLOW, (Component)this.component)) {
            boolean bl2;
            boolean bl3 = false;
            for (Map.Entry<ComponentState, StateContributionInfo> entry : this.modelStateInfo.stateContributionMap.entrySet()) {
                ComponentState componentState7 = entry.getKey();
                if (componentState7 == this.modelStateInfo.currState || !componentState7.isFacetActive(ComponentStateFacet.ROLLOVER)) continue;
                bl2 = true;
                break;
            }
            boolean bl4 = this.modelStateInfo.currState.isFacetActive(ComponentStateFacet.ROLLOVER);
            if (bl2 && !bl4) {
                this.iconGlowTracker.cancel();
            }
            if (!bl2 && bl4) {
                this.iconGlowTracker.play();
            }
        }
    }

    public float getFocusStrength(boolean bl) {
        if (this.focusTimeline == null) {
            return 0.0f;
        }
        Timeline.TimelineState timelineState = this.focusTimeline.getState();
        if (timelineState == Timeline.TimelineState.READY || timelineState == Timeline.TimelineState.PLAYING_FORWARD || timelineState == Timeline.TimelineState.PLAYING_REVERSE) {
            return this.focusTimeline.getTimelinePosition();
        }
        return bl ? 1.0f : 0.0f;
    }

    public float getFocusLoopPosition() {
        if (this.focusLoopTimeline == null) {
            return 0.0f;
        }
        return this.focusLoopTimeline.getTimelinePosition();
    }

    public float getIconGlowPosition() {
        return this.iconGlowTracker.getIconGlowPosition();
    }

    public float getFacetStrength(ComponentStateFacet componentStateFacet) {
        float f = 0.0f;
        for (Map.Entry<ComponentState, StateContributionInfo> entry : this.modelStateInfo.stateContributionMap.entrySet()) {
            ComponentState componentState = entry.getKey();
            if (!componentState.isFacetActive(componentStateFacet)) continue;
            f += entry.getValue().getContribution();
        }
        return f;
    }

    public float getActiveStrength() {
        return this.modelStateInfo.getActiveStrength();
    }

    public void addStateTransitionListener(StateTransitionListener stateTransitionListener) {
        this.eventListenerList.add(StateTransitionListener.class, stateTransitionListener);
    }

    public void removeStateTransitionListener(StateTransitionListener stateTransitionListener) {
        this.eventListenerList.remove(StateTransitionListener.class, stateTransitionListener);
    }

    private void fireModelStateTransitionEvent(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2) {
        if (this.eventListenerList.getListenerCount() == 0) {
            return;
        }
        StateTransitionListener[] stateTransitionListenerArray = (StateTransitionListener[])this.eventListenerList.getListeners(StateTransitionListener.class);
        if (stateTransitionListenerArray == null || stateTransitionListenerArray.length == 0) {
            return;
        }
        StateTransitionEvent stateTransitionEvent = new StateTransitionEvent(this, timelineState, timelineState2);
        for (StateTransitionListener stateTransitionListener : stateTransitionListenerArray) {
            stateTransitionListener.onModelStateTransition(stateTransitionEvent);
        }
    }

    private void fireFocusStateTransitionEvent(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2) {
        if (this.eventListenerList.getListenerCount() == 0) {
            return;
        }
        StateTransitionListener[] stateTransitionListenerArray = (StateTransitionListener[])this.eventListenerList.getListeners(StateTransitionListener.class);
        if (stateTransitionListenerArray == null || stateTransitionListenerArray.length == 0) {
            return;
        }
        StateTransitionEvent stateTransitionEvent = new StateTransitionEvent(this, timelineState, timelineState2);
        for (StateTransitionListener stateTransitionListener : stateTransitionListenerArray) {
            stateTransitionListener.onFocusStateTransition(stateTransitionEvent);
        }
    }

    public void endTransition() {
        if (this.transitionTimeline != null) {
            this.transitionTimeline.end();
        }
    }

    public void setFocusState(boolean bl) {
        if (bl) {
            this.focusTimeline.play();
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.FOCUS_LOOP_ANIMATION, (Component)this.component)) {
                this.focusLoopTimeline.playLoop(Timeline.RepeatBehavior.LOOP);
            }
        } else {
            this.focusTimeline.playReverse();
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.FOCUS_LOOP_ANIMATION, (Component)this.component)) {
                this.focusLoopTimeline.cancel();
            }
        }
    }

    public boolean hasRunningTimelines() {
        Timeline.TimelineState timelineState;
        if (this.focusTimeline != null && (timelineState = this.focusTimeline.getState()) != Timeline.TimelineState.IDLE) {
            return true;
        }
        if (this.focusLoopTimeline != null && (timelineState = this.focusLoopTimeline.getState()) != Timeline.TimelineState.IDLE) {
            return true;
        }
        if (this.iconGlowTracker.isPlaying()) {
            return true;
        }
        return this.transitionTimeline != null && (timelineState = this.transitionTimeline.getState()) != Timeline.TimelineState.IDLE;
    }

    public IconGlowTracker getIconGlowTracker() {
        return this.iconGlowTracker;
    }

    public ModelStateInfo getModelStateInfo() {
        return this.modelStateInfo;
    }

    public static class ModelStateInfo {
        private Map<ComponentState, StateContributionInfo> stateContributionMap = new HashMap<ComponentState, StateContributionInfo>();
        private Map<ComponentState, StateContributionInfo> stateNoSelectionContributionMap = new HashMap<ComponentState, StateContributionInfo>();
        ComponentState currState;
        ComponentState currStateNoSelection;
        float activeStrength = 0.0f;

        public ComponentState getCurrModelState() {
            return this.currState;
        }

        public ComponentState getCurrModelStateNoSelection() {
            return this.currStateNoSelection;
        }

        public Map<ComponentState, StateContributionInfo> getStateContributionMap() {
            return this.stateContributionMap;
        }

        public Map<ComponentState, StateContributionInfo> getStateNoSelectionContributionMap() {
            return this.stateNoSelectionContributionMap;
        }

        void sync() {
            this.activeStrength = 0.0f;
            for (Map.Entry<ComponentState, StateContributionInfo> entry : this.stateContributionMap.entrySet()) {
                ComponentState componentState = entry.getKey();
                if (!componentState.isActive()) continue;
                this.activeStrength += entry.getValue().getContribution();
            }
        }

        float getActiveStrength() {
            return this.activeStrength;
        }

        void clear() {
            this.stateContributionMap.clear();
            this.stateContributionMap.put(this.currState, new StateContributionInfo(1.0f, 1.0f));
            this.stateNoSelectionContributionMap.clear();
            this.stateNoSelectionContributionMap.put(this.currStateNoSelection, new StateContributionInfo(1.0f, 1.0f));
            this.sync();
        }
    }

    public static interface RepaintCallback {
        public TimelineCallback getRepaintCallback();
    }

    public static class StateContributionInfo {
        float start;
        float end;
        float curr;

        public StateContributionInfo(float f, float f2) {
            this.start = f;
            this.end = f2;
            this.curr = f;
        }

        public float getContribution() {
            return this.curr;
        }

        void updateContribution(float f) {
            this.curr = this.start + f * (this.end - this.start);
        }
    }
}

