/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.BaseColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class HueShiftColorScheme
extends BaseColorScheme {
    private double hueShiftFactor;
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private SubstanceColorScheme origScheme;

    public HueShiftColorScheme(SubstanceColorScheme substanceColorScheme, double d) {
        super("Hue-shift " + substanceColorScheme.getDisplayName() + " " + (int)(100.0 * d) + "%", HueShiftColorScheme.getResolver(substanceColorScheme));
        this.hueShiftFactor = d;
        this.origScheme = substanceColorScheme;
        this.foregroundColor = SubstanceColorUtilities.getHueShiftedColor(substanceColorScheme.getForegroundColor(), this.hueShiftFactor / 2.0);
        this.mainUltraDarkColor = SubstanceColorUtilities.getHueShiftedColor(substanceColorScheme.getUltraDarkColor(), this.hueShiftFactor);
        this.mainDarkColor = SubstanceColorUtilities.getHueShiftedColor(substanceColorScheme.getDarkColor(), this.hueShiftFactor);
        this.mainMidColor = SubstanceColorUtilities.getHueShiftedColor(substanceColorScheme.getMidColor(), this.hueShiftFactor);
        this.mainLightColor = SubstanceColorUtilities.getHueShiftedColor(substanceColorScheme.getLightColor(), this.hueShiftFactor);
        this.mainExtraLightColor = SubstanceColorUtilities.getHueShiftedColor(substanceColorScheme.getExtraLightColor(), this.hueShiftFactor);
        this.mainUltraLightColor = SubstanceColorUtilities.getHueShiftedColor(substanceColorScheme.getUltraLightColor(), this.hueShiftFactor);
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public SubstanceColorScheme getOrigScheme() {
        return this.origScheme;
    }

    public double getHueShiftFactor() {
        return this.hueShiftFactor;
    }
}

