/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.BaseColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class NegatedColorScheme
extends BaseColorScheme {
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private SubstanceColorScheme origScheme;

    public NegatedColorScheme(SubstanceColorScheme substanceColorScheme) {
        super("Negated " + substanceColorScheme.getDisplayName(), NegatedColorScheme.getResolver(substanceColorScheme).invert());
        this.origScheme = substanceColorScheme;
        this.foregroundColor = SubstanceColorUtilities.invertColor(substanceColorScheme.getForegroundColor());
        this.mainUltraDarkColor = SubstanceColorUtilities.invertColor(substanceColorScheme.getUltraDarkColor());
        this.mainDarkColor = SubstanceColorUtilities.invertColor(substanceColorScheme.getDarkColor());
        this.mainMidColor = SubstanceColorUtilities.invertColor(substanceColorScheme.getMidColor());
        this.mainLightColor = SubstanceColorUtilities.invertColor(substanceColorScheme.getLightColor());
        this.mainExtraLightColor = SubstanceColorUtilities.invertColor(substanceColorScheme.getExtraLightColor());
        this.mainUltraLightColor = SubstanceColorUtilities.invertColor(substanceColorScheme.getUltraLightColor());
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public SubstanceColorScheme getOrigScheme() {
        return this.origScheme;
    }
}

