/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.BaseColorScheme;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class SaturatedColorScheme
extends BaseColorScheme {
    private double saturationFactor;
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private SubstanceColorScheme origScheme;

    public SaturatedColorScheme(SubstanceColorScheme substanceColorScheme, double d) {
        super("Saturated (" + (int)(100.0 * d) + "%) " + substanceColorScheme.getDisplayName(), SaturatedColorScheme.getResolver(substanceColorScheme));
        this.saturationFactor = d;
        this.origScheme = substanceColorScheme;
        this.foregroundColor = substanceColorScheme.getForegroundColor();
        this.mainUltraDarkColor = SubstanceColorUtilities.getSaturatedColor(substanceColorScheme.getUltraDarkColor(), d);
        this.mainDarkColor = SubstanceColorUtilities.getSaturatedColor(substanceColorScheme.getDarkColor(), d);
        this.mainMidColor = SubstanceColorUtilities.getSaturatedColor(substanceColorScheme.getMidColor(), d);
        this.mainLightColor = SubstanceColorUtilities.getSaturatedColor(substanceColorScheme.getLightColor(), d);
        this.mainExtraLightColor = SubstanceColorUtilities.getSaturatedColor(substanceColorScheme.getExtraLightColor(), d);
        this.mainUltraLightColor = SubstanceColorUtilities.getSaturatedColor(substanceColorScheme.getUltraLightColor(), d);
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public SubstanceColorScheme getOrigScheme() {
        return this.origScheme;
    }

    public double getSaturationFactor() {
        return this.saturationFactor;
    }
}

