/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.colorscheme;

import java.awt.Color;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.BaseColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class ShiftColorScheme
extends BaseColorScheme {
    private double backgroundShiftFactor;
    private double foregroundShiftFactor;
    private Color backgroundShiftColor;
    private Color foregroundShiftColor;
    private Color mainUltraLightColor;
    private Color mainExtraLightColor;
    private Color mainLightColor;
    private Color mainMidColor;
    private Color mainDarkColor;
    private Color mainUltraDarkColor;
    private Color foregroundColor;
    private SubstanceColorScheme origScheme;
    protected static final LazyResettableHashMap<SubstanceColorScheme> shiftedCache = new LazyResettableHashMap("ShiftColorScheme.shiftedSchemes");

    public ShiftColorScheme(SubstanceColorScheme substanceColorScheme, Color color, double d) {
        this(substanceColorScheme, color, d, color, d / 2.0, false);
    }

    public ShiftColorScheme(SubstanceColorScheme substanceColorScheme, Color color, double d, Color color2, double d2, boolean bl) {
        super("Shift " + substanceColorScheme.getDisplayName() + " to backgr [" + String.valueOf(color) + "] " + (int)(100.0 * d) + "%, foregr [" + String.valueOf(color2) + "]" + (int)(100.0 * d2) + "%", ShiftColorScheme.getResolver(substanceColorScheme));
        this.backgroundShiftColor = color;
        this.backgroundShiftFactor = d;
        this.foregroundShiftColor = color2;
        this.foregroundShiftFactor = d2;
        this.origScheme = substanceColorScheme;
        this.foregroundColor = this.foregroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(this.foregroundShiftColor, substanceColorScheme.getForegroundColor(), this.foregroundShiftFactor) : substanceColorScheme.getForegroundColor();
        bl = bl && this.backgroundShiftColor != null;
        Color color3 = bl ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, substanceColorScheme.getUltraDarkColor()) : this.backgroundShiftColor;
        this.mainUltraDarkColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(color3, substanceColorScheme.getUltraDarkColor(), this.backgroundShiftFactor) : substanceColorScheme.getUltraDarkColor();
        Color color4 = bl ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, substanceColorScheme.getDarkColor()) : this.backgroundShiftColor;
        this.mainDarkColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(color4, substanceColorScheme.getDarkColor(), this.backgroundShiftFactor) : substanceColorScheme.getDarkColor();
        Color color5 = bl ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, substanceColorScheme.getMidColor()) : this.backgroundShiftColor;
        this.mainMidColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(color5, substanceColorScheme.getMidColor(), this.backgroundShiftFactor) : substanceColorScheme.getMidColor();
        Color color6 = bl ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, substanceColorScheme.getLightColor()) : this.backgroundShiftColor;
        this.mainLightColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(color6, substanceColorScheme.getLightColor(), this.backgroundShiftFactor) : substanceColorScheme.getLightColor();
        Color color7 = bl ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, substanceColorScheme.getExtraLightColor()) : this.backgroundShiftColor;
        this.mainExtraLightColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(color7, substanceColorScheme.getExtraLightColor(), this.backgroundShiftFactor) : substanceColorScheme.getExtraLightColor();
        Color color8 = bl ? SubstanceColorUtilities.deriveByBrightness(this.backgroundShiftColor, substanceColorScheme.getUltraLightColor()) : this.backgroundShiftColor;
        this.mainUltraLightColor = this.backgroundShiftColor != null ? SubstanceColorUtilities.getInterpolatedColor(color8, substanceColorScheme.getUltraLightColor(), this.backgroundShiftFactor) : substanceColorScheme.getUltraLightColor();
    }

    @Override
    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public Color getUltraLightColor() {
        return this.mainUltraLightColor;
    }

    @Override
    public Color getExtraLightColor() {
        return this.mainExtraLightColor;
    }

    @Override
    public Color getLightColor() {
        return this.mainLightColor;
    }

    @Override
    public Color getMidColor() {
        return this.mainMidColor;
    }

    @Override
    public Color getDarkColor() {
        return this.mainDarkColor;
    }

    @Override
    public Color getUltraDarkColor() {
        return this.mainUltraDarkColor;
    }

    public SubstanceColorScheme getOrigScheme() {
        return this.origScheme;
    }

    public double getShiftFactor() {
        return this.backgroundShiftFactor;
    }

    public static SubstanceColorScheme getShiftedScheme(SubstanceColorScheme substanceColorScheme, Color color, double d, Color color2, double d2) {
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(substanceColorScheme.getDisplayName(), color == null ? "" : Integer.valueOf(color.getRGB()), d, color2 == null ? "" : Integer.valueOf(color2.getRGB()), d2);
        SubstanceColorScheme substanceColorScheme2 = shiftedCache.get(hashMapKey);
        if (substanceColorScheme2 == null) {
            substanceColorScheme2 = substanceColorScheme.shift(color, d, color2, d2);
            shiftedCache.put(hashMapKey, substanceColorScheme2);
        }
        return substanceColorScheme2;
    }
}

