/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.jgoodies.looks.common;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.common.ShadowPopupBorder;

public final class ShadowPopup
extends Popup {
    private static final int MAX_CACHE_SIZE = 5;
    private static List<Object> cache;
    private static final Border SHADOW_BORDER;
    private static final int SHADOW_SIZE = 5;
    private static boolean canSnapshot;
    private Component owner;
    private Component contents;
    private int x;
    private int y;
    private Popup popup;
    private Border oldBorder;
    private boolean oldOpaque;
    private Container heavyWeightContainer;
    private static final Point POINT;
    private static final Rectangle RECT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Popup getInstance(Component component, Component component2, int n, int n2, Popup popup) {
        Class<ShadowPopup> clazz = ShadowPopup.class;
        synchronized (ShadowPopup.class) {
            if (cache == null) {
                cache = new ArrayList<Object>(5);
            }
            ShadowPopup shadowPopup = cache.size() > 0 ? (ShadowPopup)cache.remove(0) : new ShadowPopup();
            // ** MonitorExit[var6_5] (shouldn't be in output)
            shadowPopup.reset(component, component2, n, n2, popup);
            return shadowPopup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycle(ShadowPopup shadowPopup) {
        Class<ShadowPopup> clazz = ShadowPopup.class;
        synchronized (ShadowPopup.class) {
            if (cache.size() < 5) {
                cache.add(shadowPopup);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean canSnapshot() {
        return canSnapshot;
    }

    @Override
    public void hide() {
        if (this.contents == null) {
            return;
        }
        JComponent jComponent = (JComponent)this.contents.getParent();
        this.popup.hide();
        if (jComponent != null && jComponent.getBorder() == SHADOW_BORDER) {
            jComponent.setBorder(this.oldBorder);
            jComponent.setOpaque(this.oldOpaque);
            this.oldBorder = null;
            if (this.heavyWeightContainer != null) {
                jComponent.putClientProperty("jgoodies.hShadowBg", null);
                jComponent.putClientProperty("jgoodies.vShadowBg", null);
                this.heavyWeightContainer = null;
            }
        }
        this.owner = null;
        this.contents = null;
        this.popup = null;
        ShadowPopup.recycle(this);
    }

    @Override
    public void show() {
        if (this.heavyWeightContainer != null) {
            this.snapshot();
        }
        this.popup.show();
    }

    private void reset(Component component, Component component2, int n, int n2, Popup popup) {
        Container container;
        this.owner = component;
        this.contents = component2;
        this.popup = popup;
        this.x = n;
        this.y = n2;
        if (component instanceof JComboBox) {
            return;
        }
        Dimension dimension = component2.getPreferredSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        for (container = component2.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JWindow) && !(container instanceof Panel)) continue;
            container.setBackground(component2.getBackground());
            this.heavyWeightContainer = container;
            break;
        }
        container = (JComponent)component2.getParent();
        this.oldOpaque = ((JComponent)container).isOpaque();
        this.oldBorder = ((JComponent)container).getBorder();
        ((JComponent)container).setOpaque(false);
        ((JComponent)container).setBorder(SHADOW_BORDER);
        if (this.heavyWeightContainer != null) {
            this.heavyWeightContainer.setSize(this.heavyWeightContainer.getPreferredSize());
        } else {
            container.setSize(((JComponent)container).getPreferredSize());
        }
    }

    private void snapshot() {
        try {
            boolean bl;
            JComponent jComponent;
            Graphics2D graphics2D;
            Dimension dimension = this.heavyWeightContainer.getPreferredSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (n <= 0 || n2 <= 5) {
                return;
            }
            Robot robot = new Robot();
            RECT.setBounds(this.x, this.y + n2 - 5, n, 5);
            BufferedImage bufferedImage = robot.createScreenCapture(RECT);
            RECT.setBounds(this.x + n - 5, this.y, 5, n2 - 5);
            BufferedImage bufferedImage2 = robot.createScreenCapture(RECT);
            JComponent jComponent2 = (JComponent)this.contents.getParent();
            jComponent2.putClientProperty("jgoodies.hShadowBg", bufferedImage);
            jComponent2.putClientProperty("jgoodies.vShadowBg", bufferedImage2);
            Container container = this.getLayeredPane();
            if (container == null) {
                return;
            }
            int n3 = container.getWidth();
            int n4 = container.getHeight();
            ShadowPopup.POINT.x = this.x;
            ShadowPopup.POINT.y = this.y;
            SwingUtilities.convertPointFromScreen(POINT, container);
            ShadowPopup.RECT.x = ShadowPopup.POINT.x;
            ShadowPopup.RECT.y = ShadowPopup.POINT.y + n2 - 5;
            ShadowPopup.RECT.width = n;
            ShadowPopup.RECT.height = 5;
            if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n3) {
                ShadowPopup.RECT.width = n3 - ShadowPopup.RECT.x;
            }
            if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n4) {
                ShadowPopup.RECT.height = n4 - ShadowPopup.RECT.y;
            }
            if (!RECT.isEmpty()) {
                graphics2D = bufferedImage.createGraphics();
                ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                graphics2D.setClip(RECT);
                if (container instanceof JComponent) {
                    jComponent = (JComponent)container;
                    bl = jComponent.isDoubleBuffered();
                    jComponent.setDoubleBuffered(false);
                    jComponent.paintAll(graphics2D);
                    jComponent.setDoubleBuffered(bl);
                } else {
                    container.paintAll(graphics2D);
                }
                graphics2D.dispose();
            }
            ShadowPopup.RECT.x = ShadowPopup.POINT.x + n - 5;
            ShadowPopup.RECT.y = ShadowPopup.POINT.y;
            ShadowPopup.RECT.width = 5;
            ShadowPopup.RECT.height = n2 - 5;
            if (ShadowPopup.RECT.x + ShadowPopup.RECT.width > n3) {
                ShadowPopup.RECT.width = n3 - ShadowPopup.RECT.x;
            }
            if (ShadowPopup.RECT.y + ShadowPopup.RECT.height > n4) {
                ShadowPopup.RECT.height = n4 - ShadowPopup.RECT.y;
            }
            if (!RECT.isEmpty()) {
                graphics2D = bufferedImage2.createGraphics();
                ((Graphics)graphics2D).translate(-ShadowPopup.RECT.x, -ShadowPopup.RECT.y);
                graphics2D.setClip(RECT);
                if (container instanceof JComponent) {
                    jComponent = (JComponent)container;
                    bl = jComponent.isDoubleBuffered();
                    jComponent.setDoubleBuffered(false);
                    jComponent.paintAll(graphics2D);
                    jComponent.setDoubleBuffered(bl);
                } else {
                    container.paintAll(graphics2D);
                }
                graphics2D.dispose();
            }
        }
        catch (AWTException aWTException) {
            canSnapshot = false;
        }
        catch (SecurityException securityException) {
            canSnapshot = false;
        }
    }

    private Container getLayeredPane() {
        Container container = null;
        if (this.owner != null) {
            container = this.owner instanceof Container ? (Container)this.owner : this.owner.getParent();
        }
        for (Container container2 = container; container2 != null; container2 = container2.getParent()) {
            if (container2 instanceof JRootPane) {
                if (container2.getParent() instanceof JInternalFrame) continue;
                container = ((JRootPane)container2).getLayeredPane();
                continue;
            }
            if (container2 instanceof Window) {
                if (container != null) break;
                container = container2;
                break;
            }
            if (container2 instanceof JApplet) break;
        }
        return container;
    }

    static {
        SHADOW_BORDER = ShadowPopupBorder.getInstance();
        canSnapshot = true;
        POINT = new Point();
        RECT = new Rectangle();
    }
}

