/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.util.Images;

public abstract class MultiIcon
implements Icon {
    protected Icon[] icons;
    private Image tiledImage;
    private int tileCount;
    private boolean isTiledHorizontaly;

    public MultiIcon(Icon[] iconArray) {
        this.icons = iconArray;
        this.generateMissingIcons();
    }

    public MultiIcon(Image[] imageArray) {
        this.icons = new Icon[imageArray.length];
        int n = this.icons.length;
        for (int i = 0; i < n; ++i) {
            if (imageArray[i] == null) continue;
            this.icons[i] = new ImageIcon(imageArray[i]);
        }
        this.generateMissingIcons();
    }

    public MultiIcon(Image image, int n, boolean bl) {
        this.tiledImage = image;
        this.tileCount = n;
        this.isTiledHorizontaly = bl;
    }

    @Override
    public int getIconHeight() {
        this.generateIconsFromTiledImage();
        return this.icons[0].getIconHeight();
    }

    @Override
    public int getIconWidth() {
        this.generateIconsFromTiledImage();
        return this.icons[0].getIconWidth();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.generateIconsFromTiledImage();
        Icon icon = this.getIcon(component);
        if (icon != null) {
            icon.paintIcon(component, graphics, n, n2);
        }
    }

    private void generateIconsFromTiledImage() {
        if (this.icons == null) {
            this.icons = new Icon[this.tileCount];
            BufferedImage[] bufferedImageArray = Images.split(this.tiledImage, this.tileCount, this.isTiledHorizontaly);
            int n = Math.min(bufferedImageArray.length, this.icons.length);
            for (int i = 0; i < n; ++i) {
                if (bufferedImageArray[i] == null) continue;
                this.icons[i] = new ImageIcon(bufferedImageArray[i]);
            }
            this.generateMissingIcons();
            this.tiledImage = null;
        }
    }

    protected abstract Icon getIcon(Component var1);

    protected abstract void generateMissingIcons();
}

