/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua;

import java.awt.BorderLayout;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorChooserMainPanel;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.QuaquaColorPreviewPanel;

public class Quaqua13ColorChooserUI
extends ColorChooserUI {
    protected ColorChooserMainPanel mainPanel;
    protected JColorChooser chooser;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected JComponent previewPanel;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        return new Quaqua13ColorChooserUI();
    }

    public void installUIInternal(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        this.installDefaults();
        this.installListeners();
        this.chooser.setLayout(new BorderLayout());
        this.mainPanel = new ColorChooserMainPanel();
        this.chooser.add(this.mainPanel);
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.installPreviewPanel();
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        String[] stringArray = (String[])UIManager.get("ColorChooser.defaultChoosers");
        ArrayList arrayList = new ArrayList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(Class.forName(stringArray[i]).newInstance());
                continue;
            }
            catch (AccessControlException accessControlException) {
                System.err.println("Quaqua13ColorChooserUI warning: unable to instantiate " + stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                throw new InternalError("Unable to instantiate " + stringArray[i]);
            }
            catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                System.err.println("Quaqua13ColorChooserUI warning: unable to instantiate " + stringArray[i]);
            }
        }
        return arrayList.toArray(new AbstractColorChooserPanel[arrayList.size()]);
    }

    public void uninstallUIInternal(JComponent jComponent) {
        this.chooser.remove(this.mainPanel);
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.mainPanel.setPreviewPanel(null);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.mainPanel = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
    }

    protected void installDefaultsInternal() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
    }

    protected void uninstallDefaultsInternal() {
    }

    protected void installListenersInternal() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected void uninstallListenersInternal() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.mainPanel.setPreviewPanel(null);
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel != null && "javax.swing.colorchooser.DefaultPreviewPanel".equals(this.previewPanel.getClass().getName())) {
            this.previewPanel = null;
        }
        if (this.previewPanel != null && this.mainPanel != null && this.chooser != null && this.previewPanel.getSize().getHeight() + this.previewPanel.getSize().getWidth() == 0.0) {
            this.mainPanel.setPreviewPanel(null);
            return;
        }
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = new QuaquaColorPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.mainPanel.setPreviewPanel(this.previewPanel);
    }

    protected void uninstallDefaultChoosers() {
        for (int i = 0; i < this.defaultChoosers.length; ++i) {
            this.chooser.removeChooserPanel(this.defaultChoosers[i]);
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.installUIInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void uninstallDefaults() {
        this.uninstallDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    class PreviewListener
    implements ChangeListener {
        PreviewListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ColorSelectionModel colorSelectionModel = (ColorSelectionModel)changeEvent.getSource();
            if (Quaqua13ColorChooserUI.this.previewPanel != null) {
                Quaqua13ColorChooserUI.this.previewPanel.setForeground(colorSelectionModel.getSelectedColor());
                Quaqua13ColorChooserUI.this.previewPanel.repaint();
            }
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("chooserPanels")) {
                int n;
                AbstractColorChooserPanel[] abstractColorChooserPanelArray = (AbstractColorChooserPanel[])propertyChangeEvent.getOldValue();
                AbstractColorChooserPanel[] abstractColorChooserPanelArray2 = (AbstractColorChooserPanel[])propertyChangeEvent.getNewValue();
                for (n = 0; n < abstractColorChooserPanelArray.length; ++n) {
                    Container container = abstractColorChooserPanelArray[n].getParent();
                    if (container == null) continue;
                    Container container2 = container.getParent();
                    if (container2 != null) {
                        container2.remove(container);
                    }
                    abstractColorChooserPanelArray[n].uninstallChooserPanel(Quaqua13ColorChooserUI.this.chooser);
                }
                Quaqua13ColorChooserUI.this.mainPanel.removeAllColorChooserPanels();
                for (n = 0; n < abstractColorChooserPanelArray2.length; ++n) {
                    if (abstractColorChooserPanelArray2[n] == null) continue;
                    Quaqua13ColorChooserUI.this.mainPanel.addColorChooserPanel(abstractColorChooserPanelArray2[n]);
                }
                for (n = 0; n < abstractColorChooserPanelArray2.length; ++n) {
                    if (abstractColorChooserPanelArray2[n] == null) continue;
                    abstractColorChooserPanelArray2[n].installChooserPanel(Quaqua13ColorChooserUI.this.chooser);
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("previewPanel") && propertyChangeEvent.getNewValue() != Quaqua13ColorChooserUI.this.previewPanel) {
                Quaqua13ColorChooserUI.this.installPreviewPanel();
            }
        }
    }
}

