/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.util.Methods;

public class QuaquaUtilities
extends BasicGraphicsUtils
implements SwingConstants {
    private QuaquaUtilities() {
    }

    public static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    public static void drawStringUnderlineCharAt(Graphics graphics, String string, int n, int n2, int n3) {
        graphics.drawString(string, n2, n3);
        if (n >= 0 && n < string.length()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n4 = n2 + fontMetrics.stringWidth(string.substring(0, n));
            int n5 = n3;
            int n6 = fontMetrics.charWidth(string.charAt(n));
            int n7 = 1;
            graphics.fillRect(n4, n5 + fontMetrics.getDescent() - 1, n6, n7);
        }
    }

    static int findDisplayedMnemonicIndex(String string, int n) {
        if (string == null || n == 0) {
            return -1;
        }
        char c = Character.toUpperCase((char)n);
        char c2 = Character.toLowerCase((char)n);
        int n2 = string.indexOf(c);
        int n3 = string.indexOf(c2);
        if (n2 == -1) {
            return n3;
        }
        if (n3 == -1) {
            return n2;
        }
        return n3 < n2 ? n3 : n2;
    }

    public static boolean isOnActiveWindow(Component component) {
        Serializable serializable;
        if (component instanceof JComponent && (serializable = (Boolean)((JComponent)component).getClientProperty("Frame.active")) != null && ((Boolean)serializable).booleanValue()) {
            return true;
        }
        serializable = SwingUtilities.getWindowAncestor(component);
        boolean bl = serializable == null ? true : (serializable instanceof Frame || serializable instanceof Dialog ? Methods.invokeGetter((Object)serializable, "isActive", true) : (Methods.invokeGetter((Object)serializable, "getFocusableWindowState", true) ? Methods.invokeGetter((Object)serializable, "isFocused", true) : true));
        if (bl && component instanceof JComponent) {
            ((JComponent)component).putClientProperty("Frame.active", bl);
        }
        return bl;
    }

    public static String getKeyModifiersText(int n, boolean bl) {
        return QuaquaUtilities.getKeyModifiersUnicode(n, bl);
    }

    static String getKeyModifiersUnicode(int n, boolean bl) {
        char[] cArray = new char[4];
        int n2 = 0;
        if (bl) {
            if ((n & 2) != 0) {
                cArray[n2++] = 8963;
            }
            if ((n & 0x28) != 0) {
                cArray[n2++] = 8997;
            }
            if ((n & 1) != 0) {
                cArray[n2++] = 8679;
            }
            if ((n & 4) != 0) {
                cArray[n2++] = 8984;
            }
        } else {
            if ((n & 4) != 0) {
                cArray[n2++] = 8984;
            }
            if ((n & 1) != 0) {
                cArray[n2++] = 8679;
            }
            if ((n & 0x28) != 0) {
                cArray[n2++] = 8997;
            }
            if ((n & 2) != 0) {
                cArray[n2++] = 8963;
            }
        }
        return new String(cArray, 0, n2);
    }

    public static void repaintBorder(JComponent jComponent) {
        JComponent jComponent2 = jComponent;
        Border border = null;
        Container container = jComponent.getParent();
        if (container instanceof JViewport && (jComponent2 = (JComponent)container.getParent()) != null) {
            border = jComponent2.getBorder();
        }
        if (border == null) {
            border = jComponent.getBorder();
            jComponent2 = jComponent;
        }
        if (border != null && jComponent2 != null) {
            int n = jComponent2.getWidth();
            int n2 = jComponent2.getHeight();
            Insets insets = jComponent2.getInsets();
            jComponent2.repaint(0, 0, n, insets.top);
            jComponent2.repaint(0, 0, insets.left, n2);
            jComponent2.repaint(0, n2 - insets.bottom, n, insets.bottom);
            jComponent2.repaint(n - insets.right, 0, insets.right, n2);
        }
    }

    public static final Object beginGraphics(Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return object;
    }

    public static final void endGraphics(Graphics2D graphics2D, Object object) {
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static final boolean isFocused(Component component) {
        Component component2;
        if (QuaquaUtilities.isOnActiveWindow(component) && (component2 = component) instanceof JComponent) {
            JViewport jViewport;
            if (component2 instanceof JScrollPane && (jViewport = ((JScrollPane)component).getViewport()) != null) {
                component2 = jViewport.getView();
            }
            if (component2 instanceof JTextComponent && !((JTextComponent)component2).isEditable()) {
                return false;
            }
            return component2 != null && (((JComponent)component2).hasFocus() || ((JComponent)component2).getClientProperty("Quaqua.drawFocusBorder") == Boolean.TRUE);
        }
        return false;
    }

    static boolean isHeadless() {
        return Methods.invokeStaticGetter(GraphicsEnvironment.class, "isHeadless", false);
    }

    public static int getLeftSideBearing(Font font, String string) {
        return (Integer)Methods.invokeStatic("com.sun.java.swing.SwingUtilities2", "getLeftSideBearing", new Class[]{Font.class, String.class}, new Object[]{font, string}, new Integer(0));
    }

    static void provideErrorFeedback(Component component) {
        Toolkit toolkit = null;
        toolkit = component != null ? component.getToolkit() : Toolkit.getDefaultToolkit();
        toolkit.beep();
    }

    public static BufferedImage createBufferedImage(URL uRL) {
        BufferedImage bufferedImage;
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            QuaquaUtilities.loadImage(image);
            bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(image.getWidth(null), image.getHeight(null), 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
            image.flush();
        }
        return bufferedImage;
    }

    public static TexturePaint createTexturePaint(URL uRL) {
        BufferedImage bufferedImage = QuaquaUtilities.createBufferedImage(uRL);
        TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        return texturePaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadImage(Image image) {
        MediaTracker mediaTracker;
        Component component = new Component(){};
        MediaTracker mediaTracker2 = mediaTracker = new MediaTracker(component);
        synchronized (mediaTracker2) {
            int n = 0;
            mediaTracker.addImage(image, n);
            try {
                mediaTracker.waitForID(n, 0L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            mediaTracker.removeImage(image, n);
        }
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        boolean bl = true;
        int n6 = n2;
        int n7 = n4;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n2) {
            case 10: {
                n6 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n6 = bl ? 4 : 2;
            }
        }
        switch (n4) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        return QuaquaUtilities.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n, n6, n3, n7, rectangle, rectangle2, rectangle3, n5);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        return QuaquaUtilities.layoutCompoundLabelImpl(null, fontMetrics, string, icon, n, n2, n3, n4, rectangle, rectangle2, rectangle3, n5);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String object, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = object == null || ((String)object).equals("");
        int n12 = 0;
        View view = null;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            object = "";
        } else {
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = (int)view.getPreferredSpan(0);
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, (String)object);
                n12 = QuaquaUtilities.getLeftSideBearing(fontMetrics.getFont(), (String)object);
                if (n12 < 0) {
                    rectangle3.width -= n12;
                }
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        int n13 = n11 = bl || icon == null ? 0 : n5;
        if (!bl && rectangle3.width > (n10 = n4 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n11))) {
            if (view != null) {
                rectangle3.width = n10;
            } else {
                String string = "...";
                n9 = SwingUtilities.computeStringWidth(fontMetrics, string);
                n8 = ((String)object).length();
                for (n7 = 0; n7 < n8; ++n7) {
                    int n14 = n6 = n7 % 2 == 0 ? n7 / 2 : n8 - 1 - n7 / 2;
                    if ((n9 += fontMetrics.charWidth(((String)object).charAt(n6))) > n10) break;
                }
                object = ((String)object).substring(0, n7 / 2) + string + ((String)object).substring(n8 - n7 / 2);
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, (String)object);
            }
        }
        rectangle3.y = n3 == 1 ? (n4 != 0 ? 0 : -(rectangle3.height + n11)) : (n3 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n4 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n11));
        rectangle3.x = n4 == 2 ? -(rectangle3.width + n11) : (n4 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n11);
        n10 = Math.min(rectangle2.x, rectangle3.x);
        int n15 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n10;
        n9 = Math.min(rectangle2.y, rectangle3.y);
        n7 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n9;
        n6 = n == 1 ? rectangle.y - n9 : (n == 0 ? rectangle.y + rectangle.height / 2 - (n9 + n7 / 2) : rectangle.y + rectangle.height - (n9 + n7));
        n8 = n2 == 2 ? rectangle.x - n10 : (n2 == 4 ? rectangle.x + rectangle.width - (n10 + n15) : rectangle.x + rectangle.width / 2 - (n10 + n15 / 2));
        rectangle3.x += n8;
        rectangle3.y += n6;
        rectangle2.x += n8;
        rectangle2.y += n6;
        if (n12 < 0) {
            rectangle3.width += n12;
            rectangle3.x -= n12;
        }
        return object;
    }

    public static void configureGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    public static Component compositeRequestFocus(Component component) {
        try {
            if (component instanceof Container) {
                Component component2;
                Object object;
                Object object2;
                Container container = (Container)component;
                if (Methods.invokeGetter((Object)container, "isFocusCycleRoot", false) && (object2 = (Component)Methods.invoke(object = Methods.invokeGetter((Object)container, "getFocusTraversalPolicy", null), "getDefaultComponent", Container.class, container)) != null) {
                    ((Component)object2).requestFocus();
                    return object2;
                }
                object = (Container)Methods.invokeGetter((Object)container, "getFocusCycleRootAncestor", null);
                if (object != null && (component2 = (Component)Methods.invoke(object2 = Methods.invokeGetter(object, "getFocusTraversalPolicy", null), "getComponentAfter", new Class[]{Container.class, Component.class}, new Object[]{object, container})) != null && SwingUtilities.isDescendingFrom(component2, container)) {
                    component2.requestFocus();
                    return component2;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (Methods.invokeGetter((Object)component, "isFocusable", true)) {
            component.requestFocus();
            return component;
        }
        return null;
    }
}

