/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.VisualMargin;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorSliderModel;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorSliderTextFieldHandler;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.NominalCMYKColorSliderModel;

public class CMYKChooser
extends AbstractColorChooserPanel
implements UIResource {
    private ColorSliderModel ccModel;
    private int updateRecursion = 0;
    private JTextField blackField;
    private JLabel blackFieldLabel;
    private JPanel blackFieldPanel;
    private JLabel blackLabel;
    private JSlider blackSlider;
    private JTextField cyanField;
    private JLabel cyanFieldLabel;
    private JPanel cyanFieldPanel;
    private JLabel cyanLabel;
    private JSlider cyanSlider;
    private JTextField magentaField;
    private JLabel magentaFieldLabel;
    private JPanel magentaFieldPanel;
    private JLabel magentaLabel;
    private JSlider magentaSlider;
    private JPanel springPanel;
    private JTextField yellowField;
    private JLabel yellowFieldLabel;
    private JPanel yellowFieldPanel;
    private JLabel yellowLabel;
    private JSlider yellowSlider;

    public CMYKChooser() {
        Serializable serializable;
        this.initComponents();
        Font font = UIManager.getFont("ColorChooser.font");
        this.cyanLabel.setFont(font);
        this.cyanSlider.setFont(font);
        this.cyanField.setFont(font);
        this.cyanFieldLabel.setFont(font);
        this.magentaLabel.setFont(font);
        this.magentaSlider.setFont(font);
        this.magentaField.setFont(font);
        this.magentaFieldLabel.setFont(font);
        this.yellowLabel.setFont(font);
        this.yellowSlider.setFont(font);
        this.yellowField.setFont(font);
        this.yellowFieldLabel.setFont(font);
        this.blackLabel.setFont(font);
        this.blackSlider.setFont(font);
        this.blackField.setFont(font);
        this.blackFieldLabel.setFont(font);
        int n = UIManager.getInt("ColorChooser.textSliderGap");
        if (n != 0) {
            serializable = new EmptyBorder(0, n, 0, 0);
            this.cyanFieldPanel.setBorder((Border)((Object)serializable));
            this.magentaFieldPanel.setBorder((Border)((Object)serializable));
            this.yellowFieldPanel.setBorder((Border)((Object)serializable));
            this.blackFieldPanel.setBorder((Border)((Object)serializable));
        }
        this.ccModel = new NominalCMYKColorSliderModel();
        this.ccModel.configureColorSlider(0, this.cyanSlider);
        this.ccModel.configureColorSlider(1, this.magentaSlider);
        this.ccModel.configureColorSlider(2, this.yellowSlider);
        this.ccModel.configureColorSlider(3, this.blackSlider);
        this.cyanField.setText(Integer.toString(this.cyanSlider.getValue()));
        this.magentaField.setText(Integer.toString(this.magentaSlider.getValue()));
        this.yellowField.setText(Integer.toString(this.yellowSlider.getValue()));
        this.blackField.setText(Integer.toString(this.blackSlider.getValue()));
        serializable = (Insets)UIManager.getInsets("Component.visualMargin").clone();
        ((Insets)serializable).left = 3 - ((Insets)serializable).left;
        this.cyanFieldLabel.putClientProperty("Quaqua.Component.visualMargin", serializable);
        this.magentaFieldLabel.putClientProperty("Quaqua.Component.visualMargin", serializable);
        this.yellowFieldLabel.putClientProperty("Quaqua.Component.visualMargin", serializable);
        this.blackFieldLabel.putClientProperty("Quaqua.Component.visualMargin", serializable);
        new ColorSliderTextFieldHandler(this.cyanField, this.ccModel, 0);
        new ColorSliderTextFieldHandler(this.magentaField, this.ccModel, 1);
        new ColorSliderTextFieldHandler(this.yellowField, this.ccModel, 2);
        new ColorSliderTextFieldHandler(this.blackField, this.ccModel, 3);
        this.ccModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CMYKChooser.this.setColorToModel(CMYKChooser.this.ccModel.getColor());
            }
        });
        this.cyanField.setMinimumSize(this.cyanField.getPreferredSize());
        this.magentaField.setMinimumSize(this.magentaField.getPreferredSize());
        this.yellowField.setMinimumSize(this.yellowField.getPreferredSize());
        this.blackField.setMinimumSize(this.blackField.getPreferredSize());
        VisualMargin visualMargin = new VisualMargin(false, false, true, false);
        this.cyanLabel.setBorder(visualMargin);
        this.magentaLabel.setBorder(visualMargin);
        this.yellowLabel.setBorder(visualMargin);
        this.blackLabel.setBorder(visualMargin);
    }

    @Override
    protected void buildChooser() {
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.cmykSliders");
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return UIManager.getIcon("ColorChooser.colorSlidersIcon");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return this.getLargeDisplayIcon();
    }

    @Override
    public void updateChooser() {
        if (this.updateRecursion == 0) {
            ++this.updateRecursion;
            this.ccModel.setColor(this.getColorFromModel());
            --this.updateRecursion;
        }
    }

    public void setColorToModel(Color color) {
        if (this.updateRecursion == 0) {
            ++this.updateRecursion;
            this.getColorSelectionModel().setSelectedColor(color);
            --this.updateRecursion;
        }
    }

    private void initComponents() {
        this.cyanLabel = new JLabel();
        this.cyanSlider = new JSlider();
        this.cyanFieldPanel = new JPanel();
        this.cyanField = new JTextField();
        this.cyanFieldLabel = new JLabel();
        this.magentaLabel = new JLabel();
        this.magentaSlider = new JSlider();
        this.magentaFieldPanel = new JPanel();
        this.magentaField = new JTextField();
        this.magentaFieldLabel = new JLabel();
        this.yellowLabel = new JLabel();
        this.yellowSlider = new JSlider();
        this.yellowFieldPanel = new JPanel();
        this.yellowField = new JTextField();
        this.yellowFieldLabel = new JLabel();
        this.blackLabel = new JLabel();
        this.blackSlider = new JSlider();
        this.blackFieldPanel = new JPanel();
        this.blackField = new JTextField();
        this.blackFieldLabel = new JLabel();
        this.springPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.cyanLabel.setText(UIManager.getString("ColorChooser.cmykCyanText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)this.cyanLabel, gridBagConstraints);
        this.cyanSlider.setMajorTickSpacing(100);
        this.cyanSlider.setMinorTickSpacing(50);
        this.cyanSlider.setPaintTicks(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cyanSlider, gridBagConstraints);
        this.cyanFieldPanel.setLayout(new FlowLayout(1, 0, 0));
        this.cyanField.setColumns(3);
        this.cyanField.setHorizontalAlignment(11);
        this.cyanField.setText("0");
        this.cyanField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CMYKChooser.this.cyanFieldFocusLost(focusEvent);
            }
        });
        this.cyanFieldPanel.add(this.cyanField);
        this.cyanFieldLabel.setText("%");
        this.cyanFieldPanel.add(this.cyanFieldLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.cyanFieldPanel, gridBagConstraints);
        this.magentaLabel.setText(UIManager.getString("ColorChooser.cmykMagentaText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)this.magentaLabel, gridBagConstraints);
        this.magentaSlider.setMajorTickSpacing(100);
        this.magentaSlider.setMinorTickSpacing(50);
        this.magentaSlider.setPaintTicks(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.magentaSlider, gridBagConstraints);
        this.magentaFieldPanel.setLayout(new FlowLayout(1, 0, 0));
        this.magentaField.setColumns(3);
        this.magentaField.setHorizontalAlignment(11);
        this.magentaField.setText("0");
        this.magentaField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CMYKChooser.this.magentaFieldFocusLost(focusEvent);
            }
        });
        this.magentaFieldPanel.add(this.magentaField);
        this.magentaFieldLabel.setText("%");
        this.magentaFieldPanel.add(this.magentaFieldLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.magentaFieldPanel, gridBagConstraints);
        this.yellowLabel.setText(UIManager.getString("ColorChooser.cmykYellowText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)this.yellowLabel, gridBagConstraints);
        this.yellowSlider.setMajorTickSpacing(100);
        this.yellowSlider.setMinorTickSpacing(50);
        this.yellowSlider.setPaintTicks(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.yellowSlider, gridBagConstraints);
        this.yellowFieldPanel.setLayout(new FlowLayout(1, 0, 0));
        this.yellowField.setColumns(3);
        this.yellowField.setHorizontalAlignment(11);
        this.yellowField.setText("0");
        this.yellowField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CMYKChooser.this.yellowFieldFocusLost(focusEvent);
            }
        });
        this.yellowFieldPanel.add(this.yellowField);
        this.yellowFieldLabel.setText("%");
        this.yellowFieldPanel.add(this.yellowFieldLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.yellowFieldPanel, gridBagConstraints);
        this.blackLabel.setText(UIManager.getString("ColorChooser.cmykBlackText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)this.blackLabel, gridBagConstraints);
        this.blackSlider.setMajorTickSpacing(100);
        this.blackSlider.setMinorTickSpacing(50);
        this.blackSlider.setPaintTicks(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.blackSlider, gridBagConstraints);
        this.blackFieldPanel.setLayout(new FlowLayout(1, 0, 0));
        this.blackField.setColumns(3);
        this.blackField.setHorizontalAlignment(11);
        this.blackField.setText("0");
        this.blackField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                CMYKChooser.this.blackFieldFocusLost(focusEvent);
            }
        });
        this.blackFieldPanel.add(this.blackField);
        this.blackFieldLabel.setText("%");
        this.blackFieldPanel.add(this.blackFieldLabel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.blackFieldPanel, gridBagConstraints);
        this.springPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 100;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.springPanel, gridBagConstraints);
    }

    private void blackFieldFocusLost(FocusEvent focusEvent) {
        this.blackField.setText(Integer.toString(this.ccModel.getBoundedRangeModel(3).getValue()));
    }

    private void yellowFieldFocusLost(FocusEvent focusEvent) {
        this.yellowField.setText(Integer.toString(this.ccModel.getBoundedRangeModel(2).getValue()));
    }

    private void magentaFieldFocusLost(FocusEvent focusEvent) {
        this.magentaField.setText(Integer.toString(this.ccModel.getBoundedRangeModel(1).getValue()));
    }

    private void cyanFieldFocusLost(FocusEvent focusEvent) {
        this.cyanField.setText(Integer.toString(this.ccModel.getBoundedRangeModel(0).getValue()));
    }
}

