/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.util.Methods;

public class ColorChooserMainPanel
extends JPanel {
    private static String lastSelectedChooserName = null;
    private JPanel chooserPanelHolder;
    private JPanel mainPanel;
    private JPanel northPanel;
    private JPanel previewPanelHolder;
    private JToolBar toolBar;
    private ButtonGroup toolBarButtonGroup;

    public ColorChooserMainPanel() {
        this.initComponents();
        this.toolBar.putClientProperty("Quaqua.ToolBar.isDividerDrawn", Boolean.TRUE);
    }

    public void setPreviewPanel(JComponent jComponent) {
        this.previewPanelHolder.removeAll();
        if (jComponent != null) {
            this.previewPanelHolder.add(jComponent);
        }
    }

    public void addColorChooserPanel(AbstractColorChooserPanel abstractColorChooserPanel) {
        final String string = abstractColorChooserPanel.getDisplayName();
        if (string.equals("Color Picker")) {
            this.northPanel.add((Component)abstractColorChooserPanel, "West");
        } else {
            Icon icon = abstractColorChooserPanel.getLargeDisplayIcon();
            JToggleButton jToggleButton = new JToggleButton(null, icon);
            jToggleButton.setToolTipText(string);
            Methods.invokeIfExists((Object)jToggleButton, "setFocusable", false);
            jToggleButton.setHorizontalTextPosition(0);
            jToggleButton.setVerticalTextPosition(3);
            jToggleButton.setFont(UIManager.getFont("ColorChooser.font"));
            jToggleButton.putClientProperty("Quaqua.Button.style", "toolBarTab");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(abstractColorChooserPanel);
            this.chooserPanelHolder.add((Component)jPanel, string);
            this.toolBarButtonGroup.add(jToggleButton);
            this.toolBar.add(jToggleButton);
            if (this.toolBar.getComponentCount() == 1 || lastSelectedChooserName != null && lastSelectedChooserName.equals(string)) {
                jToggleButton.setSelected(true);
                CardLayout cardLayout = (CardLayout)this.chooserPanelHolder.getLayout();
                cardLayout.show(this.chooserPanelHolder, string);
            }
            jToggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        CardLayout cardLayout = (CardLayout)ColorChooserMainPanel.this.chooserPanelHolder.getLayout();
                        cardLayout.show(ColorChooserMainPanel.this.chooserPanelHolder, string);
                        lastSelectedChooserName = string;
                    }
                }
            });
        }
    }

    public void removeAllColorChooserPanels() {
        Component[] componentArray = this.toolBar.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof AbstractButton)) continue;
            this.toolBarButtonGroup.remove((AbstractButton)componentArray[i]);
        }
        this.toolBar.removeAll();
        this.chooserPanelHolder.removeAll();
        this.northPanel.removeAll();
        this.northPanel.add(this.previewPanelHolder);
    }

    private void initComponents() {
        this.toolBarButtonGroup = new ButtonGroup();
        this.toolBar = new JToolBar();
        this.mainPanel = new JPanel();
        this.northPanel = new JPanel();
        this.previewPanelHolder = new JPanel();
        this.chooserPanelHolder = new JPanel();
        this.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(5, 4, 7, 4)));
        this.northPanel.setLayout(new BorderLayout());
        this.previewPanelHolder.setLayout(new BorderLayout());
        this.northPanel.add((Component)this.previewPanelHolder, "Center");
        this.mainPanel.add((Component)this.northPanel, "North");
        this.chooserPanelHolder.setLayout(new CardLayout());
        this.chooserPanelHolder.setBorder(new EmptyBorder(new Insets(5, 0, 0, 0)));
        this.mainPanel.add((Component)this.chooserPanelHolder, "Center");
        this.add((Component)this.mainPanel, "Center");
    }
}

