/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.DefaultPalettes;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.PaletteEntry;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.PaletteEntryCellRenderer;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.PaletteListModel;

public class ColorPalettesChooser
extends AbstractColorChooserPanel
implements UIResource {
    private static int lastSelectedPalette = 0;
    private JComboBox paletteCombo;
    private JLabel paletteLabel;
    private JList paletteList;
    private JScrollPane paletteScrollPane;

    public ColorPalettesChooser() {
        this.initComponents();
        Font font = UIManager.getFont("ColorChooser.font");
        this.paletteLabel.setFont(font);
        this.paletteCombo.setFont(font);
        this.paletteScrollPane.setFont(font);
        this.paletteList.setFont(font);
        this.paletteList.setCellRenderer(new PaletteEntryCellRenderer());
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(this.loadPalettes());
        this.paletteCombo.setModel(defaultComboBoxModel);
        this.paletteList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PaletteEntry paletteEntry = (PaletteEntry)ColorPalettesChooser.this.paletteList.getSelectedValue();
                if (paletteEntry != null) {
                    PaletteListModel paletteListModel = (PaletteListModel)ColorPalettesChooser.this.paletteList.getModel();
                    paletteListModel.setClosestIndex(-1);
                    ColorPalettesChooser.this.setColorToModel(paletteEntry.getColor());
                }
            }
        });
        this.paletteCombo.setSelectedIndex(lastSelectedPalette);
        this.loadPalettes();
        this.updatePaletteList();
    }

    protected Vector loadPalettes() {
        int n;
        Vector<PaletteListModel> vector = new Vector<PaletteListModel>();
        Color[] colorArray = DefaultPalettes.APPLE_COLORS;
        PaletteEntry[] paletteEntryArray = new PaletteEntry[colorArray.length];
        for (n = 0; n < colorArray.length; ++n) {
            paletteEntryArray[n] = new PaletteEntry(UIManager.getString("ColorChooser.apple." + Integer.toHexString(0xFF000000 | colorArray[n].getRGB()).substring(2)), colorArray[n]);
        }
        vector.add(new PaletteListModel(UIManager.getString("ColorChooser.appleColors"), MessageFormat.format(UIManager.getString("ColorChooser.profileContainsNColors"), UIManager.getString("ColorChooser.appleColors"), paletteEntryArray.length), paletteEntryArray));
        colorArray = DefaultPalettes.CRAYONS;
        paletteEntryArray = new PaletteEntry[colorArray.length];
        for (n = 0; n < colorArray.length; ++n) {
            paletteEntryArray[n % 8 + colorArray.length - n / 8 * 8 - 8] = new PaletteEntry(UIManager.getString("ColorChooser.crayon." + Integer.toHexString(0xFF000000 | colorArray[n].getRGB()).substring(2)), colorArray[n]);
        }
        vector.add(new PaletteListModel(UIManager.getString("ColorChooser.crayons"), MessageFormat.format(UIManager.getString("ColorChooser.profileContainsNColors"), UIManager.getString("ColorChooser.crayons"), paletteEntryArray.length), paletteEntryArray));
        colorArray = DefaultPalettes.WEB_SAFE_COLORS;
        paletteEntryArray = new PaletteEntry[colorArray.length];
        for (n = 0; n < colorArray.length; ++n) {
            paletteEntryArray[n] = new PaletteEntry(Integer.toHexString(0xFF000000 | colorArray[n].getRGB()).substring(2).toUpperCase(), colorArray[n]);
        }
        vector.add(new PaletteListModel(UIManager.getString("ColorChooser.webSafeColors"), MessageFormat.format(UIManager.getString("ColorChooser.profileContainsNColors"), UIManager.getString("ColorChooser.webSafeColors"), paletteEntryArray.length), paletteEntryArray));
        return vector;
    }

    private void updatePaletteList() {
        PaletteListModel paletteListModel = (PaletteListModel)this.paletteCombo.getSelectedItem();
        this.paletteList.setModel(paletteListModel);
        this.paletteCombo.setToolTipText(paletteListModel.getInfo());
        this.updateChooser();
    }

    @Override
    protected void buildChooser() {
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.colorPalettes");
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return UIManager.getIcon("ColorChooser.colorPalettesIcon");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return this.getLargeDisplayIcon();
    }

    @Override
    public void updateChooser() {
        int n;
        Color color;
        try {
            color = this.getColorFromModel();
            if (color == null) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        int n2 = color.getRGB() & 0xFFFFFF;
        PaletteEntry paletteEntry = (PaletteEntry)this.paletteList.getSelectedValue();
        if (paletteEntry != null && (paletteEntry.getColor().getRGB() & 0xFFFFFF) == n2) {
            return;
        }
        PaletteListModel paletteListModel = (PaletteListModel)this.paletteList.getModel();
        int n3 = paletteListModel.getSize();
        for (n = 0; n < n3 && ((paletteEntry = (PaletteEntry)paletteListModel.getElementAt(n)).getColor().getRGB() & 0xFFFFFF) != n2; ++n) {
        }
        if (n < n3) {
            paletteListModel.setClosestIndex(-1);
            this.paletteList.setSelectedIndex(n);
            this.paletteList.scrollRectToVisible(this.paletteList.getCellBounds(n, n));
        } else {
            this.paletteList.clearSelection();
            int n4 = paletteListModel.computeClosestIndex(color);
            paletteListModel.setClosestIndex(n4);
            if (n4 != -1) {
                this.paletteList.scrollRectToVisible(this.paletteList.getCellBounds(n4, n4));
            }
        }
    }

    public void setColorToModel(Color color) {
        this.getColorSelectionModel().setSelectedColor(color);
    }

    private void initComponents() {
        this.paletteLabel = new JLabel();
        this.paletteCombo = new JComboBox();
        this.paletteScrollPane = new JScrollPane();
        this.paletteList = new JList();
        this.setLayout(new GridBagLayout());
        this.paletteLabel.setLabelFor(this.paletteCombo);
        this.paletteLabel.setText(UIManager.getString("ColorChooser.list"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        this.add((Component)this.paletteLabel, gridBagConstraints);
        this.paletteCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ColorPalettesChooser.this.paletteChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.paletteCombo, gridBagConstraints);
        this.paletteScrollPane.setHorizontalScrollBarPolicy(31);
        this.paletteScrollPane.setVerticalScrollBarPolicy(22);
        this.paletteList.setSelectionMode(0);
        this.paletteScrollPane.setViewportView(this.paletteList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.paletteScrollPane, gridBagConstraints);
    }

    private void paletteChanged(ItemEvent itemEvent) {
        this.updatePaletteList();
        lastSelectedPalette = this.paletteCombo.getSelectedIndex();
    }
}

