/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.util.LinkedList;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorSliderUI;

public abstract class ColorSliderModel {
    private LinkedList sliders = new LinkedList();
    private LinkedList listeners = new LinkedList();
    protected DefaultBoundedRangeModel[] components;
    protected int[] values;

    protected ColorSliderModel(DefaultBoundedRangeModel[] defaultBoundedRangeModelArray) {
        this.components = defaultBoundedRangeModelArray;
        this.values = new int[defaultBoundedRangeModelArray.length];
        for (int i = 0; i < defaultBoundedRangeModelArray.length; ++i) {
            final int n = i;
            defaultBoundedRangeModelArray[i].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ColorSliderModel.this.fireColorChanged(n);
                    ColorSliderModel.this.fireStateChanged();
                }
            });
        }
    }

    public void configureColorSlider(int n, JSlider jSlider) {
        if (jSlider.getClientProperty("ColorSliderModel") != null) {
            ((ColorSliderModel)jSlider.getClientProperty("ColorSliderModel")).unconfigureColorSlider(jSlider);
        }
        if (!(jSlider.getUI() instanceof ColorSliderUI)) {
            jSlider.setUI(new ColorSliderUI(jSlider));
            jSlider.createStandardLabels(16);
        }
        jSlider.setModel(this.getBoundedRangeModel(n));
        jSlider.putClientProperty("ColorSliderModel", this);
        jSlider.putClientProperty("ColorComponentIndex", n);
        this.addColorSlider(jSlider);
    }

    public void unconfigureColorSlider(JSlider jSlider) {
        if (jSlider.getClientProperty("ColorSliderModel") == this) {
            jSlider.setModel(new DefaultBoundedRangeModel());
            jSlider.putClientProperty("ColorSliderModel", null);
            jSlider.putClientProperty("ColorComponentIndex", null);
            this.removeColorSlider(jSlider);
        }
    }

    public int getComponentCount() {
        return this.components.length;
    }

    public DefaultBoundedRangeModel getBoundedRangeModel(int n) {
        return this.components[n];
    }

    public int getValue(int n) {
        return this.components[n].getValue();
    }

    public void setValue(int n, int n2) {
        this.components[n].setValue(n2);
    }

    public int getInterpolatedRGB(int n, float f) {
        int n2 = this.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            this.values[i] = this.components[i].getValue();
        }
        this.values[n] = (int)(f * (float)this.components[n].getMaximum());
        return this.toRGB(this.values);
    }

    protected void addColorSlider(JSlider jSlider) {
        this.sliders.add(jSlider);
    }

    protected void removeColorSlider(JSlider jSlider) {
        this.sliders.remove(jSlider);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    protected void fireColorChanged(int n) {
        Integer n2 = n;
        Color color = this.getColor();
        for (JSlider jSlider : this.sliders) {
            jSlider.putClientProperty("ColorComponentChange", n2);
            jSlider.putClientProperty("ColorComponentValue", color);
        }
    }

    public void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public Color getColor() {
        return new Color(this.getRGB());
    }

    public void setColor(Color color) {
        int n = color.getRGB();
        if (n != this.getRGB()) {
            this.setRGB(n);
        }
    }

    public abstract void setRGB(int var1);

    public abstract int getRGB();

    public abstract int toRGB(int[] var1);
}

