/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.QuaquaUtilities;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.VisualMargin;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorSliderModel;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;

public class ColorSliderUI
extends BasicSliderUI
implements TransitionAwareUI {
    private static final Color foreground = new Color(0x949494);
    private static final Color trackBackground = new Color(0xFFFFFF);
    protected Integer componentIndex;
    protected ColorSliderModel colorSliderModel;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener substanceRolloverListener;
    private PropertyChangeListener substancePropertyChangeListener;
    protected StateTransitionTracker stateTransitionTracker;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(36, 16);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(26, 100);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 16);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(26, 36);

    public ColorSliderUI(JSlider jSlider) {
        super(jSlider);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        this.thumbModel.setEnabled(jSlider.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(jSlider, this.thumbModel);
        jSlider.setLabelTable(new Hashtable());
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new ColorSliderUI((JSlider)jComponent);
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        this.focusInsets = new Insets(0, 0, 0, 0);
        jSlider.setOpaque(false);
        if (jSlider.getOrientation() == 0) {
            jSlider.setBorder(new VisualMargin(0, 1, -1, 1));
        } else {
            jSlider.setBorder(new VisualMargin(0, 0, 0, 1));
        }
        jSlider.setRequestFocusEnabled(true);
    }

    @Override
    protected void installListeners(final JSlider jSlider) {
        super.installListeners(jSlider);
        this.substanceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        jSlider.addMouseListener(this.substanceRolloverListener);
        jSlider.addMouseMotionListener(this.substanceRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    ColorSliderUI.this.thumbModel.setEnabled(jSlider.isEnabled());
                }
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jSlider.updateUI();
                        }
                    });
                }
            }
        };
        this.slider.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        super.uninstallListeners(jSlider);
        jSlider.removeMouseListener(this.substanceRolloverListener);
        jSlider.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        jSlider.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
    }

    @Override
    protected Dimension getThumbSize() {
        Icon icon = this.getThumbIcon();
        return new Dimension(icon.getIconWidth(), icon.getIconHeight());
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0) {
            --this.thumbRect.y;
        } else {
            --this.thumbRect.x;
        }
    }

    protected Icon getThumbIcon() {
        if (this.slider.getOrientation() == 0) {
            return UIManager.getIcon("Slider.upThumbSmall");
        }
        return UIManager.getIcon("Slider.leftThumbSmall");
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.thumbRect;
        this.getThumbIcon().paintIcon(this.slider, graphics, rectangle.x, rectangle.y);
    }

    @Override
    public void paintTrack(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int n5 = this.trackBuffer;
            n4 = rectangle.x - n5 + 1;
            n3 = rectangle.y;
            n2 = rectangle.width + n5 * 2 - 2;
            n = rectangle.height;
        } else {
            int n6 = this.trackBuffer;
            n4 = rectangle.x;
            n3 = this.contentRect.y + 2;
            n2 = rectangle.width - 1;
            n = rectangle.height + n6 * 2 - 5;
        }
        graphics.setColor(trackBackground);
        graphics.fillRect(n4, n3, n2, n);
        graphics.setColor(foreground);
        graphics.drawRect(n4, n3, n2 - 1, n - 1);
        this.paintColorTrack(graphics, n4 + 2, n3 + 2, n2 - 4, n - 4, this.trackBuffer);
    }

    @Override
    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        graphics.setColor(foreground);
        if (this.slider.getOrientation() == 0) {
            int n;
            int n2;
            graphics.translate(0, rectangle.y);
            if (this.slider.getMinorTickSpacing() > 0) {
                for (n2 = this.slider.getMinimum(); n2 <= this.slider.getMaximum(); n2 += this.slider.getMinorTickSpacing()) {
                    n = this.xPositionForValue(n2);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (n2 = this.slider.getMinimum(); n2 <= this.slider.getMaximum(); n2 += this.slider.getMajorTickSpacing()) {
                    n = this.xPositionForValue(n2);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n);
                }
            }
            graphics.translate(0, -rectangle.y);
        } else {
            int n;
            graphics.translate(rectangle.x, 0);
            int n3 = this.slider.getMinimum();
            if (this.slider.getMinorTickSpacing() > 0) {
                int n4 = 0;
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    n4 = rectangle.width - rectangle.width / 2;
                    graphics.translate(n4, 0);
                }
                while (n3 <= this.slider.getMaximum()) {
                    n = this.yPositionForValue(n3);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n);
                    n3 += this.slider.getMinorTickSpacing();
                }
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    graphics.translate(-n4, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n3 = this.slider.getMinimum();
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    graphics.translate(2, 0);
                }
                while (n3 <= this.slider.getMaximum()) {
                    n = this.yPositionForValue(n3);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n);
                    n3 += this.slider.getMajorTickSpacing();
                }
                if (!QuaquaUtilities.isLeftToRight(this.slider)) {
                    graphics.translate(-2, 0);
                }
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height - 1);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(n, 0, n, rectangle.height - 1);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(rectangle.width / 2, n, rectangle.width / 2 - 1, n);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        graphics.drawLine(0, n, rectangle.width - 1, n);
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    public void paintColorTrack(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n;
        int n7 = n2;
        if (this.slider.getOrientation() == 0) {
            n6 += n3;
        } else {
            n7 += n4;
        }
        if (this.componentIndex == null) {
            this.componentIndex = (Integer)this.slider.getClientProperty("ColorComponentIndex");
        }
        if (this.colorSliderModel == null) {
            this.colorSliderModel = (ColorSliderModel)this.slider.getClientProperty("ColorSliderModel");
        }
        float[] fArray = this.slider.getOrientation() == 0 ? new float[]{0.0f, 1.0f} : new float[]{1.0f, 0.0f};
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setPaint(new LinearGradientPaint(n, n2, n6, n7, new float[]{0.0f, 1.0f}, new Color[]{new Color(this.colorSliderModel.getInterpolatedRGB(this.componentIndex, fArray[0]), true), new Color(this.colorSliderModel.getInterpolatedRGB(this.componentIndex, fArray[1]))}));
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.dispose();
    }

    @Override
    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            int n = this.thumbRect.height;
            if (this.slider.getPaintTicks()) {
                n += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                n += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer + 1;
            this.trackRect.height = 13;
            this.trackRect.y = this.contentRect.y + this.contentRect.height - this.trackRect.height;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2 - 1;
        } else {
            this.trackRect.width = 14;
            this.trackRect.x = this.contentRect.x + this.contentRect.width - this.trackRect.width;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2 + 1;
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y - this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            this.tickRect.width = this.getTickLength();
            this.tickRect.x = this.contentRect.x;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    @Override
    protected int getTickLength() {
        return 4;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new CSUIPropertyChangeHandler();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new QuaquaTrackListener();
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        Rectangle rectangle = this.thumbRect;
        return rectangle != null && rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
    }

    public class CSUIPropertyChangeHandler
    extends BasicSliderUI.PropertyChangeHandler {
        public CSUIPropertyChangeHandler() {
            super(ColorSliderUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("Frame.active")) {
                ColorSliderUI.this.slider.repaint();
            } else if (string.equals("ColorSliderModel")) {
                ColorSliderUI.this.colorSliderModel = (ColorSliderModel)propertyChangeEvent.getNewValue();
                ColorSliderUI.this.slider.repaint();
            } else if (string.equals("snapToTicks")) {
                ColorSliderUI.this.slider.repaint();
            } else if (string.equals("ColorComponentIndex")) {
                ColorSliderUI.this.componentIndex = (Integer)propertyChangeEvent.getNewValue();
                ColorSliderUI.this.slider.repaint();
            } else if (string.equals("ColorComponentChange")) {
                ColorSliderUI.this.slider.repaint();
            } else if (string.equals("ColorComponentValue")) {
                ColorSliderUI.this.slider.repaint();
            } else if (string.equals("Orientation")) {
                if (ColorSliderUI.this.slider.getOrientation() == 0) {
                    ColorSliderUI.this.slider.setBorder(new VisualMargin(0, 1, -1, 1));
                } else {
                    ColorSliderUI.this.slider.setBorder(new VisualMargin(0, 0, 0, 1));
                }
            }
            super.propertyChange(propertyChangeEvent);
        }
    }

    public class QuaquaTrackListener
    extends BasicSliderUI.TrackListener {
        public QuaquaTrackListener() {
            super(ColorSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!ColorSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (ColorSliderUI.this.slider.isRequestFocusEnabled()) {
                ColorSliderUI.this.slider.requestFocus();
            }
            if (ColorSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                super.mousePressed(mouseEvent);
            } else {
                switch (ColorSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        ColorSliderUI.this.slider.setValue(ColorSliderUI.this.valueForYPosition(this.currentMouseY));
                        break;
                    }
                    case 0: {
                        ColorSliderUI.this.slider.setValue(ColorSliderUI.this.valueForXPosition(this.currentMouseX));
                    }
                }
            }
        }
    }
}

