/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorWheelImageProducer;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.HSBColorSliderModel;

public class ColorWheel
extends JPanel {
    private Image colorWheelImage;
    private ColorWheelImageProducer colorWheelProducer;
    private HSBColorSliderModel model = new HSBColorSliderModel();
    private MouseHandler mouseHandler;
    private ModelHandler modelHandler;

    public ColorWheel() {
        this.initComponents();
        this.colorWheelProducer = new ColorWheelImageProducer(0, 0);
        this.mouseHandler = new MouseHandler();
        this.modelHandler = new ModelHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.setOpaque(false);
    }

    public void setModel(HSBColorSliderModel hSBColorSliderModel) {
        if (this.model != null) {
            this.model.removeChangeListener(this.modelHandler);
        }
        this.model = hSBColorSliderModel;
        if (this.model != null) {
            this.model.addChangeListener(this.modelHandler);
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    public HSBColorSliderModel getModel() {
        return this.model;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.colorWheelImage == null || this.colorWheelImage.getWidth(this) != n || this.colorWheelImage.getHeight(this) != n2) {
            if (this.colorWheelImage != null) {
                this.colorWheelImage.flush();
            }
            this.colorWheelProducer = new ColorWheelImageProducer(n, n2);
            this.colorWheelImage = this.createImage(this.colorWheelProducer);
        }
        this.colorWheelProducer.setBrightness((float)this.model.getValue(2) / 100.0f);
        this.colorWheelProducer.regenerateColorWheel();
        graphics.drawImage(this.colorWheelImage, 0, 0, this);
        int n3 = n / 2 + (int)((double)(this.colorWheelProducer.getRadius() * this.model.getValue(1)) / 100.0 * Math.cos((double)this.model.getValue(0) * Math.PI / 180.0));
        int n4 = n2 / 2 - (int)((double)(this.colorWheelProducer.getRadius() * this.model.getValue(1)) / 100.0 * Math.sin((double)this.model.getValue(0) * Math.PI / 180.0));
        graphics.setColor(Color.white);
        graphics.fillRect(n3 - 1, n4 - 1, 2, 2);
        graphics.setColor(Color.black);
        graphics.drawRect(n3 - 2, n4 - 2, 3, 3);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.update(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.update(mouseEvent);
        }

        private void update(MouseEvent mouseEvent) {
            int n = mouseEvent.getX() - ColorWheel.this.getWidth() / 2;
            int n2 = mouseEvent.getY() - ColorWheel.this.getHeight() / 2;
            float f = (float)Math.sqrt(n * n + n2 * n2);
            float f2 = (float)Math.atan2(n2, -n);
            ColorWheel.this.model.setValue(0, 180 + (int)((double)f2 / Math.PI * 180.0));
            ColorWheel.this.model.setValue(1, (int)(Math.min(1.0f, f / (float)ColorWheel.this.colorWheelProducer.getRadius()) * 100.0f));
            ColorWheel.this.repaint();
        }
    }

    private class ModelHandler
    implements ChangeListener {
        private ModelHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ColorWheel.this.repaint();
        }
    }
}

