/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class ColorWheelImageProducer
extends MemoryImageSource {
    private int[] pixels;
    private int w;
    private int h;
    private float brightness = 1.0f;
    private boolean isDirty = true;
    private float[] hues;
    private float[] saturations;
    private int[] alphas;

    public ColorWheelImageProducer(int n, int n2) {
        super(n, n2, null, 0, n);
        this.pixels = new int[n * n2];
        this.w = n;
        this.h = n2;
        this.generateLookupTables();
        this.newPixels(this.pixels, ColorModel.getRGBdefault(), 0, n);
        this.setAnimated(true);
        this.generateColorWheel();
    }

    public int getRadius() {
        return Math.min(this.w, this.h) / 2 - 2;
    }

    private void generateLookupTables() {
        this.saturations = new float[this.w * this.h];
        this.hues = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float f = this.getRadius();
        float f2 = (f + 2.0f) / f - 1.0f;
        int n = this.w / 2;
        int n2 = this.h / 2;
        for (int i = 0; i < this.w; ++i) {
            int n3 = i - n;
            int n4 = n3 * n3;
            for (int j = 0; j < this.h; ++j) {
                int n5 = n2 - j;
                int n6 = i + j * this.w;
                this.saturations[n6] = (float)Math.sqrt(n4 + n5 * n5) / f;
                if (this.saturations[n6] <= 1.0f) {
                    this.alphas[n6] = -16777216;
                } else {
                    this.alphas[n6] = (int)((f2 - Math.min(f2, this.saturations[n6] - 1.0f)) * 255.0f / f2) << 24;
                    this.saturations[n6] = 1.0f;
                }
                if (this.alphas[n6] == 0) continue;
                this.hues[n6] = (float)(Math.atan2(n5, n3) / Math.PI / 2.0);
            }
        }
    }

    public void setBrightness(float f) {
        this.isDirty = this.isDirty || this.brightness != f;
        this.brightness = f;
    }

    public boolean needsGeneration() {
        return this.isDirty;
    }

    public void regenerateColorWheel() {
        if (this.isDirty) {
            this.generateColorWheel();
        }
    }

    public void generateColorWheel() {
        for (int i = 0; i < this.pixels.length; ++i) {
            if (this.alphas[i] == 0) continue;
            this.pixels[i] = this.alphas[i] | 0xFFFFFF & Color.HSBtoRGB(this.hues[i], this.saturations[i], this.brightness);
        }
        this.newPixels();
        this.isDirty = false;
    }
}

