/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.QuaquaUtilities;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.DefaultPalettes;

public class Crayons
extends JPanel {
    private Image crayonsImage;
    private static final int[] crayonXPoints = new int[]{10, 12, 20, 22, 22, 0, 0, 2};
    private static final int[] crayonYPoints = new int[]{0, 0, 21, 21, 104, 104, 21, 21};
    private Color color = Color.white;
    private Crayon selectedCrayon = null;
    private MouseHandler mouseHandler;
    private Crayon[] crayons;

    public Crayons() {
        this.initComponents();
        this.setForeground(new Color(0x808080));
        this.setPreferredSize(new Dimension(195, 208));
        this.setFont(UIManager.getFont("ColorChooser.crayonsFont"));
        this.crayonsImage = this.createCrayonsImage();
        this.crayons = this.createCrayons();
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
    }

    protected Image createCrayonsImage() {
        return (Image)UIManager.get("ColorChooser.crayonsImage");
    }

    protected Crayon[] createCrayons() {
        Color[] colorArray = DefaultPalettes.CRAYONS;
        this.crayons = new Crayon[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            this.crayons[i] = new Crayon(colorArray[i], UIManager.getString("ColorChooser.crayon." + Integer.toHexString(0xFF000000 | colorArray[i].getRGB()).substring(2)), new Polygon((int[])crayonXPoints.clone(), (int[])crayonYPoints.clone(), crayonXPoints.length));
            this.crayons[i].shape.translate(i % 8 * 22 + 4 + i / 8 % 2 * 11, i / 8 * 20 + 23);
        }
        return this.crayons;
    }

    public void setColor(Color color) {
        Color color2 = this.color;
        this.color = color;
        Crayon crayon = null;
        int n = color.getRGB() & 0xFFFFFF;
        for (int i = 0; i < this.crayons.length; ++i) {
            if ((this.crayons[i].color.getRGB() & 0xFFFFFF) != n) continue;
            crayon = this.crayons[i];
        }
        if (crayon != this.selectedCrayon) {
            this.selectedCrayon = crayon;
            this.repaint();
        }
        this.firePropertyChange("Color", color2, color);
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = QuaquaUtilities.beginGraphics(graphics2D);
        graphics2D.drawImage(this.crayonsImage, 0, 0, this);
        if (this.selectedCrayon != null) {
            graphics2D.setColor(this.getForeground());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(this.selectedCrayon.name);
            graphics2D.drawString(this.selectedCrayon.name, (this.crayonsImage.getWidth(this) - n) / 2, fontMetrics.getAscent() + 1);
        }
        QuaquaUtilities.endGraphics(graphics2D, object);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class Crayon {
        Polygon shape;
        Color color;
        String name;

        public Crayon(Color color, String string, Polygon polygon) {
            this.color = color;
            this.name = string;
            this.shape = polygon;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n > 0 && n < Crayons.this.crayonsImage.getWidth(Crayons.this) && n2 > 0 && n2 < Crayons.this.crayonsImage.getHeight(Crayons.this)) {
                for (int i = Crayons.this.crayons.length - 1; i >= 0; --i) {
                    if (!Crayons.this.crayons[i].shape.contains(n, n2)) continue;
                    Crayons.this.setColor(Crayons.this.crayons[i].color);
                    break;
                }
            }
        }
    }
}

