/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.RGBColorSliderModel;

public class HTMLColorSliderModel
extends RGBColorSliderModel {
    private boolean isWebSaveOnly = true;

    @Override
    public int getRGB() {
        return this.getRGB(this.components[0].getValue(), this.components[1].getValue(), this.components[2].getValue());
    }

    @Override
    public int getInterpolatedRGB(int n, float f) {
        if (this.isWebSaveOnly) {
            int n2 = this.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                this.values[i] = Math.round((float)this.components[i].getValue() / 51.0f) * 51;
            }
            this.values[n] = Math.round(f * (float)this.components[n].getMaximum() / 51.0f) * 51;
            return this.toRGB(this.values);
        }
        return super.getInterpolatedRGB(n, f);
    }

    @Override
    protected int getRGB(int n, int n2, int n3) {
        if (this.isWebSaveOnly) {
            return 0xFF000000 | Math.round((float)n / 51.0f) * 51 << 16 | Math.round((float)n2 / 51.0f) * 51 << 8 | Math.round((float)n3 / 51.0f) * 51;
        }
        return super.getRGB(n, n2, n3);
    }

    @Override
    public void setRGB(int n) {
        if (this.isWebSaveOnly) {
            this.components[0].setValue(Math.round((float)(n & 0xFF0000) / 51.0f) * 51 >> 16);
            this.components[1].setValue(Math.round((float)(n & 0xFF00) / 51.0f) * 51 >> 8);
            this.components[2].setValue(Math.round((float)(n & 0xFF) / 51.0f) * 51);
        } else {
            super.setRGB(n);
        }
    }

    @Override
    public int toRGB(int[] nArray) {
        if (this.isWebSaveOnly) {
            return 0xFF000000 | Math.round((float)nArray[0] / 51.0f) * 51 << 16 | Math.round((float)nArray[1] / 51.0f) * 51 << 8 | Math.round((float)nArray[2] / 51.0f) * 51;
        }
        return super.toRGB(nArray);
    }

    public void setWebSaveOnly(boolean bl) {
        this.isWebSaveOnly = bl;
        if (bl) {
            this.setRGB(this.getRGB());
        }
        this.fireColorChanged(-1);
    }

    public boolean isWebSaveOnly() {
        return this.isWebSaveOnly;
    }

    public static boolean isWebSave(int n) {
        return (n & 0xFFFFFF) == (HTMLColorSliderModel.toWebSave(n) & 0xFFFFFF);
    }

    public static int toWebSave(int n) {
        return n & 0xFF000000 | Math.round((float)((n & 0xFF0000) >> 16) / 51.0f) * 51 << 16 | Math.round((float)((n & 0xFF00) >> 8) / 51.0f) * 51 << 8 | Math.round((float)(n & 0xFF) / 51.0f) * 51;
    }
}

