/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.HTMLColorSliderModel;

public class HTMLSliderTextFieldHandler
implements DocumentListener,
ChangeListener {
    private JTextField textField;
    private HTMLColorSliderModel ccModel;
    private int component;

    public HTMLSliderTextFieldHandler(JTextField jTextField, HTMLColorSliderModel hTMLColorSliderModel, int n) {
        this.textField = jTextField;
        this.ccModel = hTMLColorSliderModel;
        this.component = n;
        jTextField.getDocument().addDocumentListener(this);
        hTMLColorSliderModel.getBoundedRangeModel(n).addChangeListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.docChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.docChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.docChanged();
    }

    private void docChanged() {
        if (this.textField.hasFocus()) {
            DefaultBoundedRangeModel defaultBoundedRangeModel = this.ccModel.getBoundedRangeModel(this.component);
            try {
                int n = Integer.decode("#" + this.textField.getText());
                if (defaultBoundedRangeModel.getMinimum() <= n && n <= defaultBoundedRangeModel.getMaximum()) {
                    defaultBoundedRangeModel.setValue(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.textField.hasFocus()) {
            String string;
            int n = this.ccModel.getBoundedRangeModel(2).getValue();
            if (this.ccModel.isWebSaveOnly()) {
                n = Math.round((float)n / 51.0f) * 51;
            }
            this.textField.setText((String)((string = Integer.toHexString(n).toUpperCase()).length() == 1 ? "0" + string : string));
        }
    }
}

