/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.UIManager;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.PaletteEntry;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.PaletteListModel;

public class PaletteEntryCellRenderer
extends DefaultListCellRenderer {
    private Color closestMarker1 = new Color(0xE6E6E6);
    private Color closestMarker2 = new Color(0xEDEDED);
    private Color closestMarker3 = new Color(0xF0F0F0);
    private ColorIcon icon = new ColorIcon();
    private boolean isClosestColor;

    public PaletteEntryCellRenderer() {
        this.setIcon(this.icon);
        this.setOpaque(false);
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Object object2;
        this.setComponentOrientation(jList.getComponentOrientation());
        if (bl) {
            this.setBackground(UIManager.getColor("ColorChooser.listSelectionBackground"));
            this.setForeground(UIManager.getColor("ColorChooser.listSelectionForeground"));
            this.isClosestColor = false;
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
            object2 = (PaletteListModel)jList.getModel();
            this.isClosestColor = ((PaletteListModel)object2).getClosestIndex() == n;
        }
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        object2 = (PaletteEntry)object;
        this.icon.setColor(((PaletteEntry)object2).getColor());
        this.setText(((PaletteEntry)object2).getName());
        return this;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        if (this.isClosestColor) {
            graphics.setColor(this.closestMarker1);
            graphics.fillRect(0, 0, n, 2);
            graphics.fillRect(0, n2 - 2, n, 2);
            graphics.setColor(this.closestMarker2);
            graphics.fillRect(0, 2, n, 1);
            graphics.fillRect(0, n2 - 3, n, 1);
            graphics.setColor(this.closestMarker3);
            graphics.fillRect(0, 3, n, 1);
            graphics.fillRect(0, n2 - 4, n, 1);
        }
        super.paintComponent(graphics);
    }

    static class ColorIcon
    implements Icon {
        private Color color = Color.black;

        ColorIcon() {
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }

        @Override
        public int getIconWidth() {
            return 25;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(this.getColor());
            graphics.fillRect(n + 1, n2 + 1, this.getIconWidth() - 2, this.getIconHeight() - 2);
            graphics.setColor(this.getColor().darker());
            graphics.drawRect(n, n2, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
    }
}

