/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class SwatchPanel
extends JPanel {
    protected Color[] colors;
    protected Dimension swatchSize = new Dimension();
    protected Dimension defaultSwatchSize;
    protected Dimension numSwatches;
    protected Dimension gap;

    public SwatchPanel() {
        this.initComponents();
        this.initValues();
        this.initColors();
        this.setToolTipText("");
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    protected void initValues() {
        this.defaultSwatchSize = UIManager.getDimension("ColorChooser.swatchesSwatchSize");
        this.swatchSize.width = this.defaultSwatchSize.width;
        this.swatchSize.height = this.defaultSwatchSize.height;
        this.gap = new Dimension(1, 1);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.swatchSize.width = n3 > this.getPreferredSize().width ? (n3 - this.numSwatches.width * this.gap.width) / this.numSwatches.width : this.defaultSwatchSize.width;
        this.swatchSize.height = n4 > this.getPreferredSize().height ? (n4 - this.numSwatches.height * this.gap.height) / this.numSwatches.height : this.defaultSwatchSize.height;
    }

    public void setColors(Color[] colorArray) {
        this.colors = colorArray;
    }

    public void setNumSwatches(int n, int n2) {
        this.numSwatches = new Dimension(n, n2);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSwatchesSize();
        int n = (this.getWidth() - dimension.width) / 2;
        int n2 = 0;
        for (int i = 0; i < this.numSwatches.height; ++i) {
            for (int j = 0; j < this.numSwatches.width; ++j) {
                Color color = this.getColorForCell(j, i);
                graphics.setColor(color);
                int n3 = n + j * (this.swatchSize.width + this.gap.width) + 1;
                int n4 = n2 + i * (this.swatchSize.height + this.gap.height) + 1;
                graphics.fillRect(n3, n4, this.swatchSize.width, this.swatchSize.height);
                graphics.setColor(color.darker());
                graphics.fillRect(n3 - 1, n4 - 1, this.swatchSize.width + 1, 1);
                graphics.fillRect(n3 - 1, n4, 1, this.swatchSize.height);
            }
        }
    }

    public Dimension getSwatchesSize() {
        int n = this.numSwatches.width * (this.swatchSize.width + this.gap.width);
        int n2 = this.numSwatches.height * (this.swatchSize.height + this.gap.height);
        return new Dimension(n, n2);
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.numSwatches.width * (this.defaultSwatchSize.width + this.gap.width);
        int n2 = this.numSwatches.height * (this.defaultSwatchSize.height + this.gap.height);
        return new Dimension(n, n2);
    }

    protected void initColors() {
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Color color = this.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
        return color == null ? null : color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
    }

    public Color getColorForLocation(int n, int n2) {
        Dimension dimension = this.getSwatchesSize();
        int n3 = !this.getComponentOrientation().isLeftToRight() ? this.numSwatches.width - n / (this.swatchSize.width + this.gap.width) - 1 : (n -= (this.getWidth() - dimension.width) / 2) / (this.swatchSize.width + this.gap.width);
        int n4 = n2 / (this.swatchSize.height + this.gap.height);
        return this.getColorForCell(n3, n4);
    }

    private Color getColorForCell(int n, int n2) {
        int n3 = n2 * this.numSwatches.width + n;
        return n3 < this.colors.length ? this.colors[n3] : null;
    }
}

