/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;

public class Images {
    private static GraphiteFilter graphiteFilter = new GraphiteFilter();
    private static Properties canGraphite;

    private Images() {
    }

    public static Image createImage(URL uRL) {
        Image image = Toolkit.getDefaultToolkit().createImage(uRL);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static boolean canGraphite(URL uRL) {
        int n;
        Object object;
        if (canGraphite == null) {
            object = Images.class;
            // MONITORENTER : org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.util.Images.class
            if (canGraphite == null) {
                Properties properties = new Properties();
                try {
                    properties.load(Images.class.getResourceAsStream("graphiteable.properties"));
                }
                catch (IOException iOException) {
                    System.err.println("Failed to load graphiteable.properties: " + String.valueOf(iOException));
                }
                canGraphite = properties;
            }
            // MONITOREXIT : object
        }
        if ((n = ((String)(object = uRL.getFile())).lastIndexOf(File.separatorChar)) == -1) return canGraphite.containsKey(object);
        object = ((String)object).substring(n + 1);
        return canGraphite.containsKey(object);
    }

    private static Image toGraphite(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), graphiteFilter));
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = null;
        if (System.getProperty("java.version").startsWith("1.4.1_")) {
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        } else {
            boolean bl;
            try {
                bl = Images.hasAlpha(image);
            }
            catch (IllegalAccessError illegalAccessError) {
                bl = true;
            }
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                int n = 1;
                if (bl) {
                    n = 3;
                }
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bufferedImage == null) {
                int n = 1;
                if (bl) {
                    n = 2;
                }
                bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
            }
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    public static BufferedImage[] split(Image image, int n, boolean bl) {
        BufferedImage bufferedImage = Images.toBufferedImage(image);
        if (n == 1) {
            return new BufferedImage[]{bufferedImage};
        }
        BufferedImage[] bufferedImageArray = new BufferedImage[n];
        for (int i = 0; i < n; ++i) {
            bufferedImageArray[i] = bl ? bufferedImage.getSubimage(bufferedImage.getWidth() / n * i, 0, bufferedImage.getWidth() / n, bufferedImage.getHeight()) : bufferedImage.getSubimage(0, bufferedImage.getHeight() / n * i, bufferedImage.getWidth(), bufferedImage.getHeight() / n);
        }
        return bufferedImageArray;
    }

    public static class GraphiteFilter
    extends RGBImageFilter {
        private static final float saturationAdjust = 0.179f;
        private static float hueAdjust = 0.0052f;
        private static float brightnessAdjust = 0.09f;
        private float[] hsb = new float[3];

        @Override
        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 & 0xFF000000;
            int n5 = n3 >> 16 & 0xFF;
            int n6 = n3 >> 8 & 0xFF;
            int n7 = n3 & 0xFF;
            float f = 0.273393f;
            float f2 = 0.273393f;
            float f3 = 0.273393f;
            float f4 = f + 0.179f;
            float f5 = f;
            float f6 = f;
            float f7 = f2;
            float f8 = f2 + 0.179f;
            float f9 = f2;
            float f10 = f3;
            float f11 = f3;
            float f12 = f3 + 0.179f;
            int n8 = (int)(f4 * (float)n5 + f7 * (float)n6 + f10 * (float)n7);
            int n9 = (int)(f5 * (float)n5 + f8 * (float)n6 + f11 * (float)n7);
            int n10 = (int)(f6 * (float)n5 + f9 * (float)n6 + f12 * (float)n7);
            return n4 | n8 << 16 | n9 << 8 | n10;
        }
    }
}

