/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.util;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class ResourceBundleUtil {
    private ResourceBundle resource;

    public ResourceBundleUtil(ResourceBundle resourceBundle) {
        this.resource = resourceBundle;
    }

    public String getString(String string) {
        try {
            return this.resource.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "-" + string + "-";
        }
    }

    public ImageIcon getImageIcon(String string, Class clazz) {
        try {
            String string2 = this.resource.getString(string);
            if (string2.equals("")) {
                return null;
            }
            URL uRL = clazz.getResource(string2);
            return uRL == null ? null : new ImageIcon(uRL);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public char getMnemonic(String string) {
        String string2 = this.resource.getString(string);
        return string2 == null || string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
    }

    public char getMnem(String string) {
        String string2 = this.resource.getString(string + "Mnem");
        return string2 == null || string2.length() == 0 ? (char)'\u0000' : string2.charAt(0);
    }

    public KeyStroke getKeyStroke(String string) {
        KeyStroke keyStroke = null;
        try {
            String string2 = this.resource.getString(string);
            keyStroke = string2 == null ? (KeyStroke)null : KeyStroke.getKeyStroke(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return keyStroke;
    }

    public KeyStroke getAcc(String string) {
        KeyStroke keyStroke = null;
        try {
            String string2 = this.resource.getString(string + "Acc");
            keyStroke = string2 == null ? (KeyStroke)null : KeyStroke.getKeyStroke(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return keyStroke;
    }

    public String getFormatted(String string, Object object) {
        return MessageFormat.format(this.resource.getString(string), object);
    }

    public String getFormatted(String string, Object[] objectArray) {
        return MessageFormat.format(this.resource.getString(string), objectArray);
    }

    public Locale getLocale() {
        return this.resource.getLocale();
    }

    public static ResourceBundleUtil getBundle(String string) throws MissingResourceException {
        return new ResourceBundleUtil(ResourceBundle.getBundle(string, Locale.getDefault()));
    }

    public static ResourceBundleUtil getLAFBundle(String string) throws MissingResourceException {
        return ResourceBundleUtil.getLAFBundle(string, Locale.getDefault());
    }

    public static ResourceBundleUtil getLAFBundle(String string, Locale locale) throws MissingResourceException {
        ResourceBundleUtil resourceBundleUtil;
        try {
            resourceBundleUtil = new ResourceBundleUtil(ResourceBundle.getBundle(string + "_" + UIManager.getLookAndFeel().getID(), locale));
        }
        catch (MissingResourceException missingResourceException) {
            resourceBundleUtil = new ResourceBundleUtil(ResourceBundle.getBundle(string, locale));
        }
        return resourceBundleUtil;
    }
}

