/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.xoetrope.editor.color;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pushingpixels.substance.internal.contrib.xoetrope.editor.color.ModelColor;

public class ColorWheelPanel
extends AbstractColorChooserPanel
implements ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
ChangeListener {
    public static final int MONOCHROMATIC_SCHEME = 0;
    public static final int CONTRASTING_SCHEME = 1;
    public static final int SOFT_CONTRAST_SCHEME = 2;
    public static final int DOUBLE_CONTRAST_SCHEME = 3;
    public static final int ANALOGIC_SCHEME = 4;
    public static final int CTRL_ADJUST = 0;
    public static final int ALWAYS_ADJUST = 1;
    public static final int NEVER_ADJUST = 2;
    protected JTextField hueEdit;
    protected JTextField satEdit;
    protected JTextField brightEdit;
    protected JTextField baseColorEdit;
    protected BufferedImage pickerImage;
    protected ColorWheel imagePicker;
    protected JPanel fixedPanel;
    protected JButton resetBtn;
    protected JSlider brightnessSlider;
    protected JSlider saturationSlider;
    protected JLabel baseColorLabel;
    protected Ellipse2D innerCircle;
    protected Ellipse2D outerCircle;
    protected Ellipse2D borderCircle;
    protected JCheckBox useWebColors;
    protected JCheckBox decimalRGB;
    protected Font font9pt;
    protected ModelColor chooserColor;
    protected ModelColor[] selectedIttenColours;
    private float[] values = new float[3];
    private double h;
    private double s;
    private double b;
    private int colorScheme = 0;
    private boolean busy = false;
    private boolean displayScheme = false;
    private boolean hasChooser = false;
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    private static double[] arcDelta = new double[]{-7.5, -7.5, -7.5, -7.5, -7.5, -1.0, 4.0, 7.5};
    private double ringThickness;
    private GeneralPath[] paths;
    private static ResourceBundle labelBundle;
    private GeneralPath rolloverPath;
    private GeneralPath selectedPath;
    private boolean showRollovers;
    private Color rolloverColor;
    private Color selectedColor;
    private Color systemColor;
    private String fontFamily;
    private int adjustWheel = 0;
    private boolean adjustRollover = true;
    private boolean ctrlKeyDown = false;
    private double saturationMultipler = 1.0;
    private double brightnessMultipler = 1.0;

    public ColorWheelPanel() {
        this.font9pt = UIManager.getFont("ColorChooser.smallFont");
        if (this.font9pt == null) {
            this.font9pt = new Font("Arial", 0, 9);
        }
        this.fontFamily = this.font9pt.getFamily();
        this.showRollovers = true;
        this.innerCircle = new Ellipse2D.Double(96.0, 96.0, 36.0, 36.0);
        this.outerCircle = new Ellipse2D.Double(6.0, 6.0, 214.0, 214.0);
        this.borderCircle = new Ellipse2D.Double(0.0, 0.0, 227.0, 227.0);
        this.fixedPanel = new JPanel();
        this.fixedPanel.setLayout(null);
        this.fixedPanel.setOpaque(false);
        this.fixedPanel.setBounds(0, 0, 255, 328);
        this.fixedPanel.setPreferredSize(new Dimension(255, 328));
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String string, Component component) {
            }

            @Override
            public void removeLayoutComponent(Component component) {
            }

            @Override
            public void layoutContainer(Container container) {
                Dimension dimension = ColorWheelPanel.this.fixedPanel.getPreferredSize();
                int n = (container.getWidth() - dimension.width) / 2;
                int n2 = (container.getHeight() - dimension.height) / 2;
                ColorWheelPanel.this.fixedPanel.setBounds(n, n2, dimension.width, dimension.height);
            }

            @Override
            public Dimension minimumLayoutSize(Container container) {
                return this.preferredLayoutSize(container);
            }

            @Override
            public Dimension preferredLayoutSize(Container container) {
                return ColorWheelPanel.this.fixedPanel.getPreferredSize();
            }
        });
        this.imagePicker = new ColorWheel();
        this.imagePicker.setBounds(0, 0, 228, 228);
        this.imagePicker.addMouseListener(this);
        this.imagePicker.addMouseMotionListener(this);
        this.imagePicker.setOpaque(false);
        this.imagePicker.addMouseWheelListener(this);
        this.fixedPanel.add(this.imagePicker);
        this.brightnessSlider = new JSlider(1);
        this.brightnessSlider.setBounds(230, 0, 25, 108);
        this.brightnessSlider.setMinimum(0);
        this.brightnessSlider.setMaximum(100);
        this.brightnessSlider.setValue(100);
        this.brightnessSlider.setOpaque(false);
        this.brightnessSlider.setPaintLabels(true);
        this.brightnessSlider.addChangeListener(this);
        this.brightnessSlider.addMouseWheelListener(this);
        this.brightnessSlider.addMouseMotionListener(this);
        this.brightnessSlider.setToolTipText(ColorWheelPanel.getLabel("Xoetrope.ctrlDrag", "CTRL+drag to adjust the color wheel"));
        this.fixedPanel.add(this.brightnessSlider);
        this.resetBtn = new JButton();
        this.resetBtn.setBounds(237, 109, 10, 10);
        this.resetBtn.setBackground(this.getBackground());
        this.resetBtn.addActionListener(this);
        this.resetBtn.setToolTipText(ColorWheelPanel.getLabel("Xoetrope.reset", "Reset the color wheel sauturation and brightness"));
        this.fixedPanel.add(this.resetBtn);
        this.saturationSlider = new JSlider(1);
        this.saturationSlider.setBounds(230, 120, 25, 110);
        this.saturationSlider.setMinimum(0);
        this.saturationSlider.setMaximum(100);
        this.saturationSlider.setValue(100);
        this.saturationSlider.setOpaque(false);
        this.saturationSlider.setInverted(true);
        this.saturationSlider.setPaintLabels(true);
        this.saturationSlider.addChangeListener(this);
        this.saturationSlider.addMouseWheelListener(this);
        this.saturationSlider.addMouseMotionListener(this);
        this.saturationSlider.setToolTipText(ColorWheelPanel.getLabel("Xoetrope.ctrlDrag", "CTRL+drag to adjust the color wheel"));
        this.fixedPanel.add(this.saturationSlider);
        this.useWebColors = new JCheckBox(ColorWheelPanel.getLabel("Xoetrope.webSafeColors", "Use web safe colors"));
        this.useWebColors.setBounds(8, 248, 160, 18);
        this.useWebColors.addActionListener(this);
        this.useWebColors.setOpaque(false);
        this.useWebColors.setFont(this.font9pt);
        this.fixedPanel.add(this.useWebColors);
        this.decimalRGB = new JCheckBox(ColorWheelPanel.getLabel("Xoetrope.decimalRGB", "Decimal RGB"));
        this.decimalRGB.setBounds(173, 248, 88, 18);
        this.decimalRGB.addActionListener(this);
        this.decimalRGB.setOpaque(false);
        this.decimalRGB.setFont(this.font9pt);
        this.fixedPanel.add(this.decimalRGB);
        this.baseColorLabel = new JLabel();
        this.baseColorLabel.setBounds(10, 268, 160, 18);
        this.baseColorLabel.setBackground(Color.red);
        this.baseColorLabel.setOpaque(true);
        this.baseColorLabel.setToolTipText(ColorWheelPanel.getLabel("Xoetrope.systemColorsTooltip", "Right click for system colours"));
        this.fixedPanel.add(this.baseColorLabel);
        this.baseColorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ColorWheelPanel.this.showSystemColorList(mouseEvent.getPoint());
            }
        });
        this.baseColorEdit = new JTextField();
        this.baseColorEdit.setBounds(180, 268, 75, 18);
        this.baseColorEdit.setOpaque(true);
        this.fixedPanel.add(this.baseColorEdit);
        this.baseColorEdit.addActionListener(this);
        this.hueEdit = new JTextField();
        this.hueEdit.setBounds(10, 288, 75, 20);
        this.fixedPanel.add(this.hueEdit);
        this.hueEdit.setText("0");
        this.hueEdit.getDocument().addDocumentListener(new ColorDocumentListener(this.hueEdit));
        JLabel jLabel = new JLabel(ColorWheelPanel.getLabel("Xoetrope.hue", "Hue") + " \u00b0");
        jLabel.setBounds(10, 308, 75, 20);
        jLabel.setFont(this.font9pt);
        this.fixedPanel.add(jLabel);
        this.satEdit = new JTextField();
        this.satEdit.setBounds(95, 288, 75, 20);
        this.fixedPanel.add(this.satEdit);
        this.satEdit.setText("0");
        this.satEdit.getDocument().addDocumentListener(new ColorDocumentListener(this.satEdit));
        JLabel jLabel2 = new JLabel(ColorWheelPanel.getLabel("Xoetrope.saturation", "Saturation") + " %");
        jLabel2.setBounds(95, 308, 75, 20);
        jLabel2.setFont(this.font9pt);
        this.fixedPanel.add(jLabel2);
        this.brightEdit = new JTextField();
        this.brightEdit.setBounds(180, 288, 75, 20);
        this.fixedPanel.add(this.brightEdit);
        this.brightEdit.setText("0");
        this.brightEdit.getDocument().addDocumentListener(new ColorDocumentListener(this.brightEdit));
        JLabel jLabel3 = new JLabel(ColorWheelPanel.getLabel("Xoetrope.brightness", "Brightness") + " %");
        jLabel3.setBounds(180, 308, 75, 20);
        jLabel3.setFont(this.font9pt);
        this.fixedPanel.add(jLabel3);
        this.add(this.fixedPanel);
    }

    public void setSelectedColors(ModelColor[] modelColorArray) {
        this.selectedIttenColours = modelColorArray;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    public boolean useDecimalRGB() {
        return this.decimalRGB.isSelected();
    }

    public boolean useWebColors() {
        return this.useWebColors.isSelected();
    }

    public void setDisplayScheme(boolean bl) {
        this.displayScheme = bl;
    }

    public int getHue() {
        try {
            return Integer.parseInt(this.hueEdit.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 128;
        }
    }

    public void setHue(int n) {
        try {
            if (n < 0) {
                n = 360 + n;
            }
            int n2 = Math.max(0, Math.min(n, 360));
            this.hueEdit.setText(Integer.toString(n2));
            this.resetColor();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public int getSaturation() {
        try {
            return Integer.parseInt(this.satEdit.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 128;
        }
    }

    public int getBrightness() {
        try {
            return Integer.parseInt(this.brightEdit.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 128;
        }
    }

    public void setColorScheme(int n) {
        this.colorScheme = n;
    }

    boolean moveHue(Point point) {
        if (this.borderCircle.contains(point) && !this.outerCircle.contains(point) || this.innerCircle.contains(point)) {
            int n = this.getAngle(point);
            this.hueEdit.setText(Integer.toString(n));
            this.selectedPath = null;
            this.resetColor();
            return true;
        }
        return false;
    }

    private int getAngle(Point point) {
        int n = point.x > 0 ? point.x : 96;
        int n2 = point.y > 0 ? point.y : 96;
        int n3 = n - 112;
        int n4 = n2 - 114;
        return (int)Math.round((Math.atan2(-n3, n4) * 180.0 / Math.PI + 180.0) % 360.0);
    }

    public void setColor(Color color) {
        int n;
        this.systemColor = null;
        if (color != null) {
            int n2 = color.getRed();
            int n3 = color.getGreen();
            n = color.getBlue();
            if (this.useWebColors.isSelected()) {
                n2 = Math.round(n2 / 51) * 51;
                n3 = Math.round(n3 / 51) * 51;
                n = Math.round(n / 51) * 51;
            }
            this.chooserColor = new ModelColor(n2, n3, n);
        }
        color = new Color(this.chooserColor.R, this.chooserColor.G, this.chooserColor.B);
        this.values = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.values);
        if (this.values[1] == 0.0f) {
            this.s = this.values[1];
            this.b = this.values[2];
        } else if (this.values[2] == 0.0f) {
            this.b = this.values[2];
        } else {
            this.h = this.values[0];
            this.s = this.values[1];
            this.b = this.values[2];
        }
        this.h = Math.min(Math.max(this.h, 0.0), 1.0);
        this.s = Math.min(Math.max(this.s, 0.0), 1.0);
        this.b = Math.min(Math.max(this.b, 0.0), 1.0);
        if (this.values[1] != 0.0f) {
            if (this.values[1] != 0.0f) {
                this.setHue();
            }
            this.setSaturation();
        }
        this.setBrightness();
        this.busy = true;
        this.brightnessSlider.setValue(Integer.parseInt(this.brightEdit.getText()));
        this.saturationSlider.setValue(Integer.parseInt(this.satEdit.getText()));
        this.busy = false;
        this.baseColorLabel.setBackground(new Color(this.chooserColor.R, this.chooserColor.G, this.chooserColor.B));
        if (0.5 * (double)color.getRed() + (double)color.getGreen() + 0.3 * (double)color.getBlue() < 220.0) {
            this.baseColorLabel.setForeground(Color.white);
        } else {
            this.baseColorLabel.setForeground(Color.black);
        }
        String string = this.decimalRGB.isSelected() ? " " + Integer.toString(color.getRed()) + "." + Integer.toString(color.getGreen()) + "." + Integer.toString(color.getBlue()) : " " + ModelColor.toHexString(color.getRed()) + ModelColor.toHexString(color.getGreen()) + ModelColor.toHexString(color.getBlue());
        this.baseColorLabel.setText(string);
        this.baseColorEdit.setText(string);
        ChangeEvent changeEvent = new ChangeEvent(this);
        n = this.changeListeners.size();
        for (int i = 0; i < n; ++i) {
            ChangeListener changeListener = this.changeListeners.get(i);
            changeListener.stateChanged(changeEvent);
        }
        if (this.hasChooser) {
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    public Color getColor() {
        return new Color(this.chooserColor.R, this.chooserColor.G, this.chooserColor.B);
    }

    public ModelColor getChooserColour() {
        return this.chooserColor;
    }

    private void setHue() {
        this.hueEdit.setText(Integer.toString(this.chooserColor.getHue()));
    }

    private void setSaturation() {
        this.satEdit.setText(Integer.toString((int)(100.0 * this.chooserColor.S)));
    }

    private void setBrightness() {
        this.brightEdit.setText(Integer.toString((int)(100.0 * this.chooserColor.V)));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.resetBtn) {
            this.resetColorWheel();
        } else {
            if (object instanceof JMenuItem) {
                Color color = this.getSystemColor(((JMenuItem)object).getText());
                if (color != null) {
                    this.setColor(color);
                }
                this.resetColor();
                this.systemColor = color;
                if (this.hasChooser) {
                    this.hasChooser = false;
                    this.getColorSelectionModel().setSelectedColor(this.systemColor);
                    this.hasChooser = true;
                }
                return;
            }
            if (object == this.useWebColors) {
                boolean bl = this.useWebColors.isSelected();
                this.chooserColor.setWebSnap(bl);
                if (bl) {
                    this.resetColor();
                } else {
                    object = this.baseColorEdit;
                }
            } else if (object == this.baseColorEdit) {
                Object object2 = this.baseColorEdit.getText().trim();
                if (((String)object2).length() == 0) {
                    this.resetColor();
                } else if (this.decimalRGB.isSelected()) {
                    int n = 0;
                    try {
                        int n2 = 255;
                        int n3 = 0;
                        int n4 = 0;
                        int n5 = ((String)object2).indexOf(46, n);
                        if (n5 > 0) {
                            n2 = Integer.parseInt(((String)object2).substring(n, n5));
                            ++n5;
                            n = n5;
                            if ((n5 = ((String)object2).indexOf(46, n)) > 0) {
                                n3 = Integer.parseInt(((String)object2).substring(n, n5));
                                n = ++n5;
                                if (n5 < ((String)object2).length()) {
                                    n4 = Integer.parseInt(((String)object2).substring(n));
                                }
                            }
                        }
                        this.setColor(new Color(n2, n3, n4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setColor(Color.red);
                        this.baseColorEdit.setText("255.0.0");
                    }
                } else {
                    for (int i = ((String)object2).length(); i < 6; ++i) {
                        object2 = (String)object2 + "0";
                    }
                    try {
                        this.setColor(new Color(ModelColor.hex2dec(((String)object2).substring(0, 2)), ModelColor.hex2dec(((String)object2).substring(2, 4)), ModelColor.hex2dec(((String)object2).substring(4, 6))));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setColor(Color.red);
                        this.baseColorEdit.setText("FF0000");
                    }
                }
            } else {
                this.resetColor();
            }
        }
    }

    private void resetColor() {
        if (this.chooserColor != null) {
            if (!this.busy) {
                this.busy = true;
                int n = 0;
                try {
                    n = Integer.parseInt(this.hueEdit.getText());
                    this.selectedPath = null;
                }
                catch (NumberFormatException numberFormatException) {
                    this.hueEdit.setText("0");
                }
                if (n >= 360) {
                    this.hueEdit.setText(Integer.toString(n %= 360));
                }
                if (n < 0) {
                    n = (int)(((double)n + (Math.floor(-n / 360) + 1.0) * 360.0) % 360.0);
                    this.hueEdit.setText(Integer.toString(n));
                }
                double d = 1.0;
                try {
                    d = (double)Integer.parseInt(this.satEdit.getText()) / 100.0;
                }
                catch (NumberFormatException numberFormatException) {
                    this.satEdit.setText("100");
                }
                if (d > 1.0 || d < 0.0) {
                    d = d < 0.0 ? 0.0 : 1.0;
                    this.satEdit.setText(Integer.toString((int)(d * 100.0)));
                }
                double d2 = 1.0;
                try {
                    d2 = (double)Integer.parseInt(this.brightEdit.getText()) / 100.0;
                }
                catch (NumberFormatException numberFormatException) {
                    this.brightEdit.setText("100");
                }
                if (d2 > 1.0 || d2 < 0.0) {
                    d2 = d2 < 0.0 ? 0.0 : 1.0;
                    this.brightEdit.setText(Integer.toString((int)(d2 * 100.0)));
                }
                if (this.shouldAdjustWheel()) {
                    this.saturationMultipler = d;
                    this.brightnessMultipler = d2;
                }
                if (this.selectedIttenColours != null) {
                    this.selectedIttenColours[0].setHSV(n, d, d2);
                }
                this.chooserColor.setHSV(n, d, d2);
                this.busy = false;
            }
            this.setColor(null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Point point;
        Object object = mouseEvent.getSource();
        if (object == this.imagePicker && this.borderCircle.contains(point = mouseEvent.getPoint())) {
            this.selectedColor = this.rolloverColor;
            this.selectedPath = this.rolloverPath;
            if (!this.moveHue(point) && this.outerCircle.contains(point)) {
                int n;
                int n2 = this.imagePicker.getWidth();
                int n3 = n2 / 2;
                int n4 = Math.abs(point.x - n3);
                int n5 = Math.abs(point.y - n3);
                double d = Math.pow(n4 * n4 + n5 * n5, 0.5);
                int n6 = (int)((d -= this.ringThickness * 1.5) / this.ringThickness);
                int n7 = 0;
                int n8 = n6 * 24;
                for (n = 0; n < 24; ++n) {
                    if (!this.paths[n8 + n].contains(point)) continue;
                    n7 = n * 15;
                }
                n = n7 / 15 % 2;
                ModelColor modelColor = new ModelColor((double)n7, ModelColor.SATURATION_BANDS[n6], ModelColor.BRIGHTNESS_BANDS[n6 + 1 - n]);
                modelColor = new ModelColor(modelColor.H, this.saturationMultipler * modelColor.S, this.brightnessMultipler * modelColor.V);
                Color color = new Color(modelColor.getRed(), modelColor.getGreen(), modelColor.getBlue());
                if (!color.equals(Color.white)) {
                    this.setColor(color);
                }
            }
        }
        if (this.displayScheme) {
            this.imagePicker.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.imagePicker.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.rolloverPath = null;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        GeneralPath generalPath = this.rolloverPath;
        this.rolloverPath = null;
        if (mouseEvent.getSource() == this.imagePicker) {
            Point point = mouseEvent.getPoint();
            if (this.paths != null) {
                int n = this.paths.length;
                for (int i = 0; i < n; ++i) {
                    if (!this.paths[i].contains(point.x, point.y)) continue;
                    this.rolloverPath = this.paths[i];
                    ModelColor[][] modelColorArray = ModelColor.getBaseColors();
                    int n2 = i / 24;
                    ModelColor modelColor = modelColorArray[i % 24][n2];
                    if (this.adjustRollover) {
                        modelColor = new ModelColor(modelColor.H, this.saturationMultipler * modelColor.S, this.brightnessMultipler * modelColor.V);
                    }
                    this.rolloverColor = new Color(modelColor.getRed(), modelColor.getGreen(), modelColor.getBlue());
                    if (n2 < 4) {
                        this.rolloverColor = this.rolloverColor.darker();
                        break;
                    }
                    this.rolloverColor = this.rolloverColor.brighter().brighter();
                    break;
                }
            }
        }
        if (this.rolloverPath != generalPath) {
            this.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        Object object = mouseWheelEvent.getSource();
        this.ctrlKeyDown = mouseWheelEvent.isControlDown();
        int n = mouseWheelEvent.getWheelRotation();
        if (object == this.brightnessSlider) {
            this.brightnessSlider.setValue(this.brightnessSlider.getValue() - 2 * n);
        } else if (object == this.saturationSlider) {
            this.saturationSlider.setValue(this.saturationSlider.getValue() + 2 * n);
        } else if (object == this.imagePicker) {
            this.setHue(this.getHue() + 2 * n);
        }
        this.ctrlKeyDown = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.ctrlKeyDown = mouseEvent.isControlDown();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.saturationSlider) {
            this.satEdit.setText(Integer.toString(this.saturationSlider.getValue()));
            this.resetColor();
        } else if (object == this.brightnessSlider) {
            this.brightEdit.setText(Integer.toString(this.brightnessSlider.getValue()));
            this.resetColor();
        }
        if (this.hasChooser) {
            this.getColorSelectionModel().setSelectedColor(new Color(this.chooserColor.getRed(), this.chooserColor.getGreen(), this.chooserColor.getBlue()));
        }
        this.ctrlKeyDown = false;
    }

    @Override
    protected void buildChooser() {
    }

    @Override
    public String getDisplayName() {
        return "Xoetrope Color Wheel";
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return UIManager.getIcon("ColorChooser.colorWheelIcon");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return this.getLargeDisplayIcon();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(255, 328);
    }

    @Override
    public void updateChooser() {
        if (this.hasChooser) {
            Color color = this.getColorFromModel();
            if (color == null) {
                this.setSelectedColors(new ModelColor[0]);
                this.setColor(null);
            } else {
                ModelColor modelColor = new ModelColor(color.getRed(), color.getGreen(), color.getBlue());
                this.setSelectedColors(new ModelColor[]{modelColor});
                this.setColor(color);
            }
        }
    }

    @Override
    public void installChooserPanel(JColorChooser jColorChooser) {
        this.hasChooser = jColorChooser != null;
        super.installChooserPanel(jColorChooser);
        this.setDisplayScheme(true);
    }

    public static void setLabelBundle(ResourceBundle resourceBundle) {
        labelBundle = resourceBundle;
    }

    private static String getLabel(String string, String string2) {
        if (labelBundle == null) {
            return string2;
        }
        try {
            return labelBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    private void showSystemColorList(Point point) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String[] stringArray = new String[]{"activeCaption", "desktop", "activeCaptionText", "activeCaptionBorder", "inactiveCaption", "inactiveCaptionText", "inactiveCaptionBorder", "window", "windowBorder", "windowText", "menu", "menuText", "text", "textText", "textHighlight", "textHighlightText", "textInactiveText", "control", "controlText", "controlHighlight", "controlLtHighlight", "controlShadow", "controlDkShadow", "scrollbar", "info", "infoText", "white", "lightGray", "gray", "darkGray", "black", "red", "pink", "orange", "yellow", "green", "magenta", "cyan", "blue"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("white")) {
                jPopupMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
            jMenuItem.addActionListener(this);
            BufferedImage bufferedImage = new BufferedImage(8, 8, 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(this.getSystemColor(stringArray[i]));
            graphics.fillRect(0, 0, 8, 8);
            graphics.setColor(SystemColor.windowBorder);
            graphics.drawRect(0, 0, 7, 7);
            graphics.dispose();
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            jMenuItem.setIcon(imageIcon);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(this, point.x, point.y);
    }

    public Color getSystemColor(String string) {
        Color color = null;
        if (string.equals("activeCaption")) {
            color = SystemColor.activeCaption;
        } else if (string.equals("desktop")) {
            color = SystemColor.desktop;
        } else if (string.equals("activeCaptionText")) {
            color = SystemColor.activeCaptionText;
        } else if (string.equals("activeCaptionBorder")) {
            color = SystemColor.activeCaptionBorder;
        } else if (string.equals("inactiveCaption")) {
            color = SystemColor.inactiveCaption;
        } else if (string.equals("inactiveCaptionText")) {
            color = SystemColor.inactiveCaptionText;
        } else if (string.equals("inactiveCaptionBorder")) {
            color = SystemColor.inactiveCaptionBorder;
        } else if (string.equals("window")) {
            color = SystemColor.window;
        } else if (string.equals("windowBorder")) {
            color = SystemColor.windowBorder;
        } else if (string.equals("windowText")) {
            color = SystemColor.windowText;
        } else if (string.equals("menu")) {
            color = SystemColor.menu;
        } else if (string.equals("menuText")) {
            color = SystemColor.menuText;
        } else if (string.equals("text")) {
            color = SystemColor.text;
        } else if (string.equals("textText")) {
            color = SystemColor.textText;
        } else if (string.equals("textHighlight")) {
            color = SystemColor.textHighlight;
        } else if (string.equals("textHighlightText")) {
            color = SystemColor.textHighlightText;
        } else if (string.equals("textInactiveText")) {
            color = SystemColor.textInactiveText;
        } else if (string.equals("control")) {
            color = SystemColor.control;
        } else if (string.equals("controlText")) {
            color = SystemColor.controlText;
        } else if (string.equals("controlHighlight")) {
            color = SystemColor.controlHighlight;
        } else if (string.equals("controlLtHighlight")) {
            color = SystemColor.controlLtHighlight;
        } else if (string.equals("controlShadow")) {
            color = SystemColor.controlShadow;
        } else if (string.equals("controlDkShadow")) {
            color = SystemColor.controlDkShadow;
        } else if (string.equals("scrollbar")) {
            color = SystemColor.scrollbar;
        } else if (string.equals("info")) {
            color = SystemColor.info;
        } else if (string.equals("infoText")) {
            color = SystemColor.infoText;
        } else if (string.equals("white")) {
            color = Color.white;
        } else if (string.equals("lightGray")) {
            color = Color.lightGray;
        } else if (string.equals("gray")) {
            color = Color.gray;
        } else if (string.equals("darkGray")) {
            color = Color.darkGray;
        } else if (string.equals("black")) {
            color = Color.black;
        } else if (string.equals("red")) {
            color = Color.red;
        } else if (string.equals("pink")) {
            color = Color.pink;
        } else if (string.equals("orange")) {
            color = Color.orange;
        } else if (string.equals("yellow")) {
            color = Color.yellow;
        } else if (string.equals("green")) {
            color = Color.green;
        } else if (string.equals("magenta")) {
            color = Color.magenta;
        } else if (string.equals("cyan")) {
            color = Color.green;
        } else if (string.equals("blue")) {
            color = Color.blue;
        }
        return color;
    }

    private boolean shouldAdjustWheel() {
        if (this.adjustWheel == 2) {
            return false;
        }
        if (this.adjustWheel == 1) {
            return true;
        }
        return this.ctrlKeyDown;
    }

    public int getAdjustWheel() {
        return this.adjustWheel;
    }

    public void setAdjustWheel(int n) {
        this.adjustWheel = n;
    }

    public boolean getRollover() {
        return this.adjustRollover;
    }

    public void setRollover(boolean bl) {
        this.adjustRollover = bl;
    }

    public void resetColorWheel() {
        this.brightnessMultipler = 1.0;
        this.saturationMultipler = 1.0;
        this.resetColor();
    }

    class ColorWheel
    extends JLabel {
        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.paintWheel((Graphics2D)graphics);
            if (ColorWheelPanel.this.displayScheme) {
                int n = ColorWheelPanel.this.colorScheme;
                int n2 = Math.min(n + 1, 4);
                for (int i = 0; i < n2; ++i) {
                    double d = (ColorWheelPanel.this.selectedIttenColours[i].H - 90.0) / 360.0 * 2.0 * Math.PI;
                    double d2 = Math.round(111.0 + 110.0 * Math.cos(d));
                    double d3 = Math.round(111.0 + 110.0 * Math.sin(d));
                    graphics.setColor(Color.gray);
                    graphics.fillOval((int)d2, (int)d3, 4, 4);
                    graphics.setColor(Color.darkGray);
                    graphics.drawOval((int)d2, (int)d3, 4, 4);
                }
            }
        }

        public void paintWheel(Graphics2D graphics2D) {
            double d;
            double d2;
            double d3;
            int n;
            if (ColorWheelPanel.this.paths == null) {
                ColorWheelPanel.this.paths = new GeneralPath[168];
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            ModelColor[][] modelColorArray = ModelColor.getBaseColors();
            int n2 = 0;
            double d4 = this.getWidth() - 1;
            double d5 = d4 / 2.0;
            ColorWheelPanel.this.ringThickness = d4 / 18.0;
            double d6 = ColorWheelPanel.this.ringThickness / 2.0;
            double d7 = ColorWheelPanel.this.ringThickness / 2.0;
            graphics2D.setColor(new Color(228, 228, 228));
            Arc2D.Double double_ = new Arc2D.Double(d7, d7, d4 - d7 - d7, d4 - d7 - d7, 0.0, 360.0, 0);
            Arc2D.Double double_2 = new Arc2D.Double(0.0, 0.0, d4, d4, 360.0, -360.0, 0);
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(double_, true);
            generalPath.append(double_2, true);
            generalPath.closePath();
            graphics2D.fill(generalPath);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(0.3f));
            graphics2D.draw(double_2);
            graphics2D.setColor(new Color(255, 253, 220));
            double_ = new Arc2D.Double(d5 - ColorWheelPanel.this.ringThickness / 2.0, d5 - ColorWheelPanel.this.ringThickness / 2.0, ColorWheelPanel.this.ringThickness, ColorWheelPanel.this.ringThickness, -30.0, 180.0, 0);
            double_2 = new Arc2D.Double(d5 - ColorWheelPanel.this.ringThickness, d5 - ColorWheelPanel.this.ringThickness, ColorWheelPanel.this.ringThickness * 2.0, ColorWheelPanel.this.ringThickness * 2.0, 150.0, -180.0, 0);
            generalPath = new GeneralPath();
            generalPath.append(double_, true);
            generalPath.append(double_2, true);
            generalPath.closePath();
            graphics2D.fill(generalPath);
            graphics2D.setColor(new Color(202, 230, 252));
            double_ = new Arc2D.Double(d5 - ColorWheelPanel.this.ringThickness / 2.0, d5 - ColorWheelPanel.this.ringThickness / 2.0, ColorWheelPanel.this.ringThickness, ColorWheelPanel.this.ringThickness, 150.0, 180.0, 0);
            double_2 = new Arc2D.Double(d5 - ColorWheelPanel.this.ringThickness, d5 - ColorWheelPanel.this.ringThickness, ColorWheelPanel.this.ringThickness * 2.0, ColorWheelPanel.this.ringThickness * 2.0, 330.0, -180.0, 0);
            generalPath = new GeneralPath();
            generalPath.append(double_, true);
            generalPath.append(double_2, true);
            generalPath.closePath();
            graphics2D.fill(generalPath);
            graphics2D.setColor(Color.black);
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
            affineTransform2.translate(d5, d5);
            affineTransform2.rotate(0.5235987755982988);
            graphics2D.setTransform(affineTransform2);
            generalPath = new GeneralPath();
            generalPath.moveTo((float)(-ColorWheelPanel.this.ringThickness / 2.0), 0.0f);
            generalPath.lineTo((float)(-ColorWheelPanel.this.ringThickness * 1.2), 0.0f);
            generalPath.lineTo((float)(-ColorWheelPanel.this.ringThickness * 1.2), (float)(-d6));
            generalPath.lineTo((float)(-ColorWheelPanel.this.ringThickness * 1.4), (float)(-d6 + ColorWheelPanel.this.ringThickness * 0.2));
            generalPath.moveTo((float)(-ColorWheelPanel.this.ringThickness * 1.2), (float)(-d6));
            generalPath.lineTo((float)(-ColorWheelPanel.this.ringThickness), (float)(-d6 + ColorWheelPanel.this.ringThickness * 0.2));
            graphics2D.draw(generalPath);
            generalPath = new GeneralPath();
            generalPath.moveTo((float)(ColorWheelPanel.this.ringThickness / 2.0), 0.0f);
            generalPath.lineTo((float)(ColorWheelPanel.this.ringThickness * 1.2), 0.0f);
            generalPath.lineTo((float)(ColorWheelPanel.this.ringThickness * 1.2), (float)d6);
            generalPath.lineTo((float)(ColorWheelPanel.this.ringThickness * 1.4), (float)(d6 - ColorWheelPanel.this.ringThickness * 0.2));
            generalPath.moveTo((float)(ColorWheelPanel.this.ringThickness * 1.2), (float)d6);
            generalPath.lineTo((float)ColorWheelPanel.this.ringThickness, (float)(d6 - ColorWheelPanel.this.ringThickness * 0.2));
            graphics2D.draw(generalPath);
            double d8 = d5;
            double d9 = d8 - d6;
            double d10 = d8 - ColorWheelPanel.this.ringThickness / 2.3;
            double d11 = d8 + ColorWheelPanel.this.ringThickness / 2.7;
            double d12 = 0.2617993877991494;
            graphics2D.setColor(Color.black);
            for (n = 0; n < 24; ++n) {
                d3 = (double)n * d12;
                d2 = Math.sin(d3);
                d = Math.cos(d3);
                generalPath = new GeneralPath();
                if (d4 > 200.0 && n % 2 == 0) {
                    AttributedString attributedString = new AttributedString((n * 15 + 90) % 360 + "\ufffd");
                    attributedString.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                    attributedString.addAttribute(TextAttribute.SIZE, Float.valueOf((float)d6));
                    attributedString.addAttribute(TextAttribute.FOREGROUND, Color.black);
                    affineTransform2 = (AffineTransform)affineTransform.clone();
                    affineTransform2.translate(d5 + d6 / 5.0 + d10 * d, d5 + d10 * d2);
                    affineTransform2.rotate(d3 + 1.5707963267948966);
                    graphics2D.setTransform(affineTransform2);
                    graphics2D.drawString(attributedString.getIterator(), 0.0f, 0.0f);
                    continue;
                }
                graphics2D.setTransform(affineTransform);
                generalPath.moveTo((float)(d5 + d8 * d), (float)(d5 + d8 * d2));
                generalPath.lineTo((float)(d5 + d9 * d), (float)(d5 + d9 * d2));
                graphics2D.draw(generalPath);
            }
            for (n = 0; n < 7; ++n) {
                d3 = d7 + (double)(7 - (n + 1)) * ColorWheelPanel.this.ringThickness;
                d2 = d4 - d3 - d3;
                d = d3 + ColorWheelPanel.this.ringThickness;
                double d13 = d2 - 2.0 * ColorWheelPanel.this.ringThickness;
                for (int i = 0; i < 24; ++i) {
                    ModelColor modelColor = modelColorArray[i][n];
                    modelColor = new ModelColor(modelColor.H, ColorWheelPanel.this.saturationMultipler * modelColor.S, ColorWheelPanel.this.brightnessMultipler * modelColor.V);
                    Color color = new Color(modelColor.getRed(), modelColor.getGreen(), modelColor.getBlue());
                    graphics2D.setColor(color);
                    double d14 = (82.5 - (double)i * 15.0 + 360.0) % 360.0;
                    double d15 = i % 2 == 0 ? arcDelta[n] : -arcDelta[n];
                    double d16 = i % 2 == 0 ? arcDelta[n + 1] : -arcDelta[n + 1];
                    double_ = new Arc2D.Double(d, d, d13, d13, d14 + d15, 15.0 - 2.0 * d15, 0);
                    double_2 = new Arc2D.Double(d3, d3, d2, d2, d14 + 15.0 - d16, -15.0 + 2.0 * d16, 0);
                    generalPath = new GeneralPath();
                    generalPath.append(double_, true);
                    generalPath.append(double_2, true);
                    generalPath.closePath();
                    graphics2D.fill(generalPath);
                    ColorWheelPanel.this.paths[n2++] = generalPath;
                }
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (d4 > 200.0) {
                double d17 = -1.0471975511965979;
                double d18 = d17 - 0.055;
                double d19 = Math.sin(d18);
                double d20 = Math.cos(d18);
                AttributedString attributedString = new AttributedString(ColorWheelPanel.getLabel("Xoetrope.warm", "WARM"));
                attributedString.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                attributedString.addAttribute(TextAttribute.SIZE, Float.valueOf((float)(ColorWheelPanel.this.ringThickness / 1.5)));
                attributedString.addAttribute(TextAttribute.FOREGROUND, new Color(92, 0, 0));
                affineTransform2 = (AffineTransform)affineTransform.clone();
                affineTransform2.translate(d5 + d6 / 5.0 + d11 * d20, d5 + d11 * d19);
                affineTransform2.rotate(d17 + 1.5707963267948966 + 0.05);
                graphics2D.setTransform(affineTransform2);
                graphics2D.drawString(attributedString.getIterator(), 0.0f, 0.0f);
                d19 = Math.sin(d17 += Math.PI);
                d20 = Math.cos(d17);
                attributedString = new AttributedString(ColorWheelPanel.getLabel("Xoetrope.cold", "COLD"));
                attributedString.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                attributedString.addAttribute(TextAttribute.SIZE, Float.valueOf((float)(ColorWheelPanel.this.ringThickness / 1.5)));
                attributedString.addAttribute(TextAttribute.FOREGROUND, new Color(0, 0, 92));
                affineTransform2 = (AffineTransform)affineTransform.clone();
                affineTransform2.translate(d5 + d6 / 5.0 + d11 * d20, d5 + d11 * d19);
                affineTransform2.rotate(d17 + 1.5707963267948966 + 0.05);
                graphics2D.setTransform(affineTransform2);
                graphics2D.drawString(attributedString.getIterator(), 0.0f, 0.0f);
                d17 = Math.PI;
                d19 = Math.sin(d17);
                d20 = Math.cos(d17);
                attributedString = new AttributedString(ColorWheelPanel.getLabel("Xoetrope.saturation", "Saturation"));
                attributedString.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                attributedString.addAttribute(TextAttribute.SIZE, Float.valueOf((float)(ColorWheelPanel.this.ringThickness / 1.3)));
                attributedString.addAttribute(TextAttribute.FOREGROUND, UIManager.getColor("Label.foreground"));
                affineTransform2 = (AffineTransform)affineTransform.clone();
                affineTransform2.translate(d4 - d6, d4);
                affineTransform2.rotate(d17 + 1.5707963267948966);
                graphics2D.setTransform(affineTransform2);
                graphics2D.drawString(attributedString.getIterator(), 0.0f, 0.0f);
                String string = ColorWheelPanel.getLabel("Xoetrope.brightness", "Brightness");
                attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.FAMILY, ColorWheelPanel.this.fontFamily);
                attributedString.addAttribute(TextAttribute.SIZE, Float.valueOf((float)(ColorWheelPanel.this.ringThickness / 1.3)));
                attributedString.addAttribute(TextAttribute.FOREGROUND, UIManager.getColor("Label.foreground"));
                affineTransform2 = (AffineTransform)affineTransform.clone();
                affineTransform2.translate(d4 - d6, ColorWheelPanel.this.ringThickness * (double)string.length() / 2.3);
                affineTransform2.rotate(d17 + 1.5707963267948966);
                graphics2D.setTransform(affineTransform2);
                graphics2D.drawString(attributedString.getIterator(), 0.0f, 0.0f);
            }
            graphics2D.setTransform(affineTransform);
            if (ColorWheelPanel.this.showRollovers) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (ColorWheelPanel.this.rolloverPath != null) {
                    graphics2D.setColor(ColorWheelPanel.this.rolloverColor);
                    graphics2D.setStroke(new BasicStroke(1.5f));
                    graphics2D.draw(ColorWheelPanel.this.rolloverPath);
                }
                if (ColorWheelPanel.this.selectedPath != null) {
                    graphics2D.setColor(ColorWheelPanel.this.selectedColor);
                    graphics2D.setStroke(new BasicStroke(1.0f));
                    graphics2D.draw(ColorWheelPanel.this.selectedPath);
                }
            }
        }
    }

    private class ColorDocumentListener
    implements DocumentListener {
        private JTextField originator;
        private static final String MARKER = "Xoetrope.XUI.ColorWheel.DocumentEvent";

        public ColorDocumentListener(JTextField jTextField) {
            this.originator = jTextField;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.synchronize(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.synchronize(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.synchronize(documentEvent);
        }

        public void synchronize(DocumentEvent documentEvent) {
            boolean bl = true;
            if (ColorWheelPanel.this.hueEdit.getText().length() == 0) {
                bl = false;
            }
            if (ColorWheelPanel.this.brightEdit.getText().length() == 0) {
                bl = false;
            }
            if (ColorWheelPanel.this.satEdit.getText().length() == 0) {
                bl = false;
            }
            final boolean bl2 = bl;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ColorWheelPanel.this.useWebColors.setEnabled(bl2);
                    ColorWheelPanel.this.decimalRGB.setEnabled(bl2);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bl2 && ColorDocumentListener.this.originator.hasFocus()) {
                        if (Boolean.TRUE.equals(ColorDocumentListener.this.originator.getClientProperty(ColorDocumentListener.MARKER))) {
                            ColorDocumentListener.this.originator.putClientProperty(ColorDocumentListener.MARKER, null);
                        } else {
                            ColorDocumentListener.this.originator.putClientProperty(ColorDocumentListener.MARKER, Boolean.TRUE);
                            ColorWheelPanel.this.resetColor();
                        }
                    }
                    if (ColorWheelPanel.this.displayScheme) {
                        ColorWheelPanel.this.imagePicker.repaint();
                    }
                }
            });
        }
    }
}

