/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.xoetrope.editor.color;

import java.awt.Color;

public class ModelColor {
    public static final int NUM_COLOR_RINGS = 7;
    public static final int NUM_SEGMENTS = 24;
    protected boolean webSnap = false;
    private static ModelColor[][] baseColors;
    protected int R;
    protected int G;
    protected int B;
    protected double H;
    protected double S;
    protected double V;
    protected double rgbMinValue;
    protected double rgbMaxValue;
    public static double[] SATURATION_BANDS;
    public static double[] BRIGHTNESS_BANDS;

    public ModelColor(int n, int n2, int n3) {
        this(n, n2, n3, -1);
    }

    public ModelColor(double d, double d2, double d3) {
        this.setHSV(d, d2, d3);
    }

    public ModelColor(int n, int n2, int n3, int n4) {
        ModelColor.initColorWheel();
        this.setRGB(n, n2, n3, n4);
    }

    public ModelColor(ModelColor modelColor) {
        ModelColor.initColorWheel();
        this.R = modelColor.R;
        this.G = modelColor.G;
        this.B = modelColor.B;
        this.H = modelColor.H;
        this.S = modelColor.S;
        this.V = modelColor.V;
        this.getRgbMinMaxValues();
    }

    public int getRed() {
        return this.R;
    }

    public int getGreen() {
        return this.G;
    }

    public int getBlue() {
        return this.B;
    }

    public int getHue() {
        return (int)Math.floor(this.H + 0.5);
    }

    public double getH() {
        return this.H;
    }

    public double getSaturation() {
        return this.S;
    }

    public double getBrightness() {
        return this.V;
    }

    public void setRGB(int n, int n2, int n3) {
        this.setRGB(n, n2, n3, -1);
    }

    public void setRGB(int n, int n2, int n3, int n4) {
        if (this.webSnap) {
            this.R = Math.round(n / 51) * 51;
            this.G = Math.round(n2 / 51) * 51;
            this.B = Math.round(n3 / 51) * 51;
        } else {
            this.R = n;
            this.G = n2;
            this.B = n3;
        }
        this.checkRange();
        this.getRgbMinMaxValues();
        if (n4 > -1) {
            this.H = n4;
            this.S = this.rgbMaxValue > 0.0 ? (this.rgbMaxValue - this.rgbMinValue) / this.rgbMaxValue : 0.0;
            this.V = this.rgbMaxValue / 255.0;
        } else if (this.R == this.G && this.G == this.B) {
            this.H = 0.0;
            this.S = 0.0;
            this.V = this.rgbMaxValue / 255.0;
        } else {
            this.calculateHSVfromRGB();
        }
    }

    public void setHSV(double d, double d2, double d3) {
        if (Math.abs(this.H - d) > 0.499999) {
            this.H = d;
        }
        if (Math.abs(this.S - d2) > 0.009999) {
            this.S = d2;
        }
        if (Math.abs(this.V - d3) > 0.009999) {
            this.V = d3;
        }
        if (this.S > 1.0 || this.S < 0.0) {
            double d4 = this.S = this.S < 0.0 ? 0.0 : 1.0;
        }
        if (this.V > 1.0 || this.V < 0.0) {
            this.V = this.V < 0.0 ? 0.0 : 1.0;
        }
        this.calculateRGBfromHSV();
    }

    private void checkRange() {
        if (this.R > 255) {
            this.R = 255;
        }
        if (this.G > 255) {
            this.G = 255;
        }
        if (this.B > 255) {
            this.B = 255;
        }
        if (this.webSnap) {
            this.R = Math.round(this.R / 51) * 51;
            this.G = Math.round(this.G / 51) * 51;
            this.B = Math.round(this.B / 51) * 51;
        }
    }

    private void getRgbMinMaxValues() {
        this.rgbMaxValue = Math.max(Math.max(this.R, this.G), this.B);
        this.rgbMinValue = Math.min(Math.min(this.R, this.G), this.B);
    }

    private void calculateHSVfromRGB() {
        boolean bl = false;
        block0: for (int i = 0; i < 7; ++i) {
            if (i == 6) {
                i = 6;
            }
            for (int j = 0; j < 360; j += 15) {
                ModelColor modelColor = baseColors[j / 15][i];
                if (this.R != modelColor.R || this.G != modelColor.G || this.B != modelColor.B) continue;
                bl = true;
                this.H = modelColor.H;
                this.S = this.rgbMaxValue > 0.0 ? 1.0 * (this.rgbMaxValue - this.rgbMinValue) / this.rgbMaxValue : 0.0;
                this.V = this.rgbMaxValue / 255.0;
                break block0;
            }
        }
        if (!bl) {
            float[] fArray = new float[3];
            fArray = Color.RGBtoHSB(this.R, this.G, this.B, fArray);
            float f = fArray[0];
            this.S = this.rgbMaxValue > 0.0 ? 1.0 * (this.rgbMaxValue - this.rgbMinValue) / this.rgbMaxValue : 0.0;
            this.V = this.rgbMaxValue / 255.0;
            if (f < 0.1666668f) {
                f *= 2.0f;
            } else if (f < 0.3333334f) {
                f += 0.1666667f;
            } else if (f < 0.6666668f) {
                f += 0.1666667f * ((0.6666667f - f) / 0.3333334f);
            }
            this.H = 360.0 * (double)f;
        }
    }

    private void calculateRGBfromHSV() {
        double d = this.H / 360.0;
        if (d < 0.3333334) {
            d /= 2.0;
        } else if (d < 0.5000001) {
            d -= 0.1666667;
        } else if (d < 0.6666668) {
            d = 2.0 * d - 0.6666667;
        }
        Color color = new Color(Color.HSBtoRGB((float)d, (float)this.S, (float)this.V));
        this.R = color.getRed();
        this.G = color.getGreen();
        this.B = color.getBlue();
        this.checkRange();
        this.getRgbMinMaxValues();
    }

    public void rotate(int n) {
        if (this.S > 0.0 && this.V > 0.0) {
            double d = (this.H + (double)n) % 360.0;
            this.setHSV(d, this.S, this.V);
        }
    }

    public void setWebSnap(boolean bl) {
        this.webSnap = bl;
    }

    public static String dec2hex(int n) {
        Object object = Integer.toHexString(n);
        if (((String)object).length() < 2) {
            object = "0" + (String)object;
        }
        return ((String)object).toUpperCase();
    }

    public static int hex2dec(String string) {
        if (string.length() == 0) {
            return 0;
        }
        return Integer.parseInt(string, 16);
    }

    public static String toHexString(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() < 2) {
            return "0" + string;
        }
        return string;
    }

    public static String col2Gray(double d, double d2, double d3) {
        double d4 = Math.round(d * 0.299 + d2 * 0.587 + d3 * 0.114);
        return ModelColor.dec2hex((int)d4) + ModelColor.dec2hex((int)d4) + ModelColor.dec2hex((int)d4);
    }

    public static ModelColor[][] getBaseColors() {
        ModelColor.initColorWheel();
        return baseColors;
    }

    private static void initColorWheel() {
        if (baseColors == null) {
            baseColors = new ModelColor[24][7];
            for (int i = 0; i < 7; ++i) {
                for (int j = 0; j < 24; ++j) {
                    ModelColor.baseColors[j][i] = new ModelColor(15.0 * (double)j, SATURATION_BANDS[i], BRIGHTNESS_BANDS[i + 1 - j % 2]);
                }
            }
        }
    }

    static {
        SATURATION_BANDS = new double[]{0.4, 0.6, 0.8, 1.0, 1.0, 1.0, 1.0};
        BRIGHTNESS_BANDS = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 0.85, 0.65, 0.45};
    }
}

