/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.OverlayPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class BackgroundPaintingUtils {
    public static void updateIfOpaque(Graphics graphics, Component component) {
        if (SubstanceCoreUtilities.isOpaque(component)) {
            BackgroundPaintingUtils.update(graphics, component, false);
        }
    }

    public static void update(Graphics graphics, Component component, boolean bl) {
        BackgroundPaintingUtils.update(graphics, component, bl, null);
    }

    public static void update(Graphics graphics, Component component, boolean bl, DecorationAreaType decorationAreaType) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        boolean bl2 = SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null;
        boolean bl3 = false;
        if (component instanceof JComponent) {
            bl3 = Boolean.TRUE.equals(((JComponent)component).getClientProperty("lafwidgets.internal.previewMode"));
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)component, (Graphics)graphics));
        if (decorationAreaType == null) {
            decorationAreaType = SubstanceLookAndFeel.getDecorationType(component);
        }
        SubstanceSkin substanceSkin = SubstanceCoreUtilities.getSkin(component);
        boolean bl4 = component.isShowing();
        if (bl4 && decorationAreaType != DecorationAreaType.NONE && substanceSkin.isRegisteredAsDecorationArea(decorationAreaType)) {
            DecorationPainterUtils.paintDecorationBackground(graphics2D, component, decorationAreaType, bl);
            OverlayPainterUtils.paintOverlays(graphics2D, component, substanceSkin, decorationAreaType);
        } else {
            Color color = SubstanceColorUtilities.getBackgroundFillColor((component instanceof JTextComponent || component instanceof JSpinner) && component.getParent() != null ? component.getParent() : component);
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, component.getWidth(), component.getHeight());
            if (bl4) {
                OverlayPainterUtils.paintOverlays(graphics2D, component, substanceSkin, decorationAreaType);
                SubstanceWatermark substanceWatermark = SubstanceCoreUtilities.getSkin(component).getWatermark();
                if (substanceWatermark != null && !bl3 && !bl2 && SubstanceCoreUtilities.toDrawWatermark(component)) {
                    substanceWatermark.drawWatermarkImage(graphics2D, component, 0, 0, component.getWidth(), component.getHeight());
                }
            }
        }
        graphics2D.dispose();
    }

    public static void fillAndWatermark(Graphics graphics, JComponent jComponent, Color color, Rectangle rectangle) {
        boolean bl;
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        boolean bl2 = bl = SwingUtilities.getAncestorOfClass(CellRendererPane.class, jComponent) != null;
        if (!jComponent.isShowing() && !bl) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jComponent, (Graphics)graphics));
        graphics2D.setColor(color);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jComponent, (float)1.0f, (Graphics)graphics));
        SubstanceWatermark substanceWatermark = SubstanceCoreUtilities.getSkin(jComponent).getWatermark();
        if (substanceWatermark != null && !bl && jComponent.isShowing() && SubstanceCoreUtilities.toDrawWatermark(jComponent)) {
            substanceWatermark.drawWatermarkImage(graphics2D, jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics2D.dispose();
    }
}

