/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.CellRendererPane;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.highlight.SubstanceHighlightPainter;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class HighlightPainterUtils {
    protected static final LazyResettableHashMap<BufferedImage> smallCache = new LazyResettableHashMap("SubstanceHighlightUtils");

    public static void paintHighlight(Graphics graphics, CellRendererPane cellRendererPane, Component component, Rectangle rectangle, float f, Set<SubstanceConstants.Side> set, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        Component component2 = cellRendererPane != null ? cellRendererPane : component;
        SubstanceHighlightPainter substanceHighlightPainter = SubstanceCoreUtilities.getSkin(component2).getHighlightPainter();
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getHighlightBorderPainter(component2);
        Graphics2D graphics2D = (Graphics2D)graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (set == null) {
            set = EnumSet.noneOf(SubstanceConstants.Side.class);
        }
        if (rectangle.width * rectangle.height < 100000) {
            Object object3;
            Object object2 = "";
            for (Object object3 : set) {
                object2 = (String)object2 + object3.name() + "-";
            }
            HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(substanceHighlightPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), rectangle.width, rectangle.height, substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), Float.valueOf(f), object2);
            object3 = smallCache.get(hashMapKey);
            if (object3 == null) {
                object3 = HighlightPainterUtils.createHighlighterImage(component, rectangle, f, set, substanceColorScheme, substanceColorScheme2, substanceHighlightPainter, substanceBorderPainter);
                smallCache.put(hashMapKey, (BufferedImage)object3);
            }
            graphics2D.drawImage((Image)object3, 0, 0, null);
        }
    }

    private static BufferedImage createHighlighterImage(Component component, Rectangle rectangle, float f, Set<SubstanceConstants.Side> set, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, SubstanceHighlightPainter substanceHighlightPainter, SubstanceBorderPainter substanceBorderPainter) {
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(rectangle.width, rectangle.height);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        substanceHighlightPainter.paintHighlight(graphics2D, component, rectangle.width, rectangle.height, substanceColorScheme);
        HighlightPainterUtils.paintHighlightBorder(graphics2D, component, rectangle.width, rectangle.height, f, set, substanceBorderPainter, substanceColorScheme2);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static void paintHighlightBorder(Graphics2D graphics2D, Component component, int n, int n2, float f, Set<SubstanceConstants.Side> set, SubstanceBorderPainter substanceBorderPainter, SubstanceColorScheme substanceColorScheme) {
        if (f <= 0.0f) {
            return;
        }
        int n3 = 3 + (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component)));
        int n4 = set.contains((Object)SubstanceConstants.Side.LEFT) ? n3 : 0;
        int n5 = set.contains((Object)SubstanceConstants.Side.RIGHT) ? n3 : 0;
        int n6 = set.contains((Object)SubstanceConstants.Side.TOP) ? n3 : 0;
        int n7 = set.contains((Object)SubstanceConstants.Side.BOTTOM) ? n3 : 0;
        int n8 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component)) / 2.0);
        Rectangle rectangle = new Rectangle(n8, n8, n + n4 + n5 - 2 * n8 - 1, n2 + n6 + n7 - 2 * n8 - 1);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate(-n4, -n6);
        graphics2D2.setComposite(LafWidgetUtilities.getAlphaComposite(null, (float)f, (Graphics)graphics2D));
        int n9 = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component));
        Rectangle rectangle2 = new Rectangle(n8 + n9, n8 + n9, n + n4 + n5 - 2 * n8 - 2 * n9 - 1, n2 + n6 + n7 - 2 * n8 - 2 * n9 - 1);
        substanceBorderPainter.paintBorder(graphics2D2, component, n + n4 + n5, n2 + n6 + n7, rectangle, rectangle2, substanceColorScheme);
        graphics2D2.dispose();
    }

    public static String getMemoryUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubstanceHighlightUtils: \n");
        stringBuffer.append("\t" + smallCache.size() + " smalls");
        return stringBuffer.toString();
    }
}

