/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.ui.SubstanceRadioButtonUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.RolloverButtonListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceCheckBoxUI
extends SubstanceRadioButtonUI {
    private static final String propertyPrefix = "CheckBox.";
    private static LazyResettableHashMap<Icon> icons = new LazyResettableHashMap("SubstanceCheckBoxUI");
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceCheckBoxUI((JToggleButton)jComponent);
    }

    public SubstanceCheckBoxUI(JToggleButton jToggleButton) {
        super(jToggleButton);
    }

    @Override
    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void installDefaultsInternal(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        this.button.setRolloverEnabled(true);
        Border border = abstractButton.getBorder();
        if (border == null || border instanceof UIResource) {
            abstractButton.setBorder(SubstanceSizeUtils.getCheckBoxBorder(SubstanceSizeUtils.getComponentFontSize(abstractButton), abstractButton.getComponentOrientation().isLeftToRight()));
        }
    }

    private static Icon getIcon(JToggleButton jToggleButton, StateTransitionTracker stateTransitionTracker) {
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        SubstanceFillPainter substanceFillPainter = SubstanceCoreUtilities.getFillPainter(jToggleButton);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jToggleButton);
        ComponentState componentState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.FILL, componentState);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.MARK, componentState);
        SubstanceColorScheme substanceColorScheme3 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.BORDER, componentState);
        float f = stateTransitionTracker.getFacetStrength(ComponentStateFacet.SELECTION);
        boolean bl = !componentState.isFacetActive(ComponentStateFacet.SELECTION);
        int n = SubstanceSizeUtils.getComponentFontSize(jToggleButton);
        int n2 = SubstanceSizeUtils.getCheckBoxMarkSize(n);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), substanceColorScheme3.getDisplayName(), Float.valueOf(f), bl);
        Icon icon = icons.get(hashMapKey);
        if (icon == null) {
            icon = new ImageIcon(SubstanceImageCreator.getCheckBox(jToggleButton, substanceFillPainter, substanceBorderPainter, n2, componentState, substanceColorScheme, substanceColorScheme2, substanceColorScheme3, f, bl));
            icons.put(hashMapKey, icon);
        }
        if (componentState.isDisabled() || map.size() == 1) {
            return icon;
        }
        BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(jToggleButton, graphics2D, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            float f2;
            ComponentState componentState2 = entry.getKey();
            if (componentState2 == componentState || !((f2 = entry.getValue().getContribution()) > 0.0f)) continue;
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f2));
            SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.FILL, componentState2);
            SubstanceColorScheme substanceColorScheme5 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.MARK, componentState2);
            SubstanceColorScheme substanceColorScheme6 = SubstanceColorSchemeUtilities.getColorScheme(jToggleButton, ColorSchemeAssociationKind.BORDER, componentState2);
            HashMapKey hashMapKey2 = SubstanceCoreUtilities.getHashKey(n, n2, substanceFillPainter.getDisplayName(), substanceBorderPainter.getDisplayName(), substanceColorScheme4.getDisplayName(), substanceColorScheme5.getDisplayName(), substanceColorScheme6.getDisplayName(), Float.valueOf(f));
            Icon icon2 = icons.get(hashMapKey2);
            if (icon2 == null) {
                icon2 = new ImageIcon(SubstanceImageCreator.getCheckBox(jToggleButton, substanceFillPainter, substanceBorderPainter, n2, componentState, substanceColorScheme4, substanceColorScheme5, substanceColorScheme6, f, bl));
                icons.put(hashMapKey2, icon2);
            }
            icon2.paintIcon(jToggleButton, graphics2D, 0, 0);
        }
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new RolloverButtonListener(abstractButton, this.stateTransitionTracker);
    }

    @Override
    public Icon getDefaultIcon() {
        return SubstanceCheckBoxUI.getIcon(this.button, this.stateTransitionTracker);
    }

    public static String getMemoryUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubstanceCheckBox: \n");
        stringBuffer.append("\t" + icons.size() + " icons");
        return stringBuffer.toString();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        this.installDefaultsInternal(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        super.uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

