/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.Quaqua14ColorChooserUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceColorChooserUI
extends Quaqua14ColorChooserUI {
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceColorChooserUI();
    }

    @Override
    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        String[] stringArray = (String[])UIManager.get("ColorChooser.defaultChoosers");
        LinkedList<AbstractColorChooserPanel> linkedList = new LinkedList<AbstractColorChooserPanel>();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            try {
                object = Class.forName(stringArray[i]).getMethod("setLabelBundle", ResourceBundle.class);
                ((Method)object).invoke(null, SubstanceCoreUtilities.getResourceBundle(null));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                object = (AbstractColorChooserPanel)Class.forName(stringArray[i]).newInstance();
                linkedList.add((AbstractColorChooserPanel)object);
                continue;
            }
            catch (AccessControlException accessControlException) {
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InternalError("Unable to instantiate " + stringArray[i]);
            }
        }
        return linkedList.toArray(new AbstractColorChooserPanel[0]);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

