/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultComboBoxRenderer;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceDropDownButton;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;
import org.pushingpixels.substance.internal.utils.combo.ComboBoxBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboBoxEditor;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboPopup;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class SubstanceComboBoxUI
extends BasicComboBoxUI
implements TransitionAwareUI {
    protected ComboBoxPropertyChangeHandler substanceChangeHandler;
    protected StateTransitionTracker stateTransitionTracker;
    protected ButtonModel transitionModel;
    protected RolloverTextControlListener substanceRolloverListener;
    protected ComboBoxBackgroundDelegate delegate;
    protected Icon uneditableArrowIcon;
    protected Insets layoutInsets;
    private AutoResizeDocumentHandler autoResizeDocumentHandler;
    protected Set lafWidgets;
    private int currentWidth;
    private int minimumWidth = 0;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        SubstanceComboBoxUI substanceComboBoxUI = new SubstanceComboBoxUI((JComboBox)jComponent);
        substanceComboBoxUI.comboBox = (JComboBox)jComponent;
        substanceComboBoxUI.comboBox.setOpaque(false);
        return substanceComboBoxUI;
    }

    public void installUIInternal(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.putClientProperty("substancelaf.internal.textComponentAware", new SubstanceCoreUtilities.TextComponentAware<JComboBox>(){

            @Override
            public JTextComponent getTextComponent(JComboBox jComboBox) {
                if (jComboBox.isEditable()) {
                    Component component = jComboBox.getEditor().getEditorComponent();
                    JTextComponent jTextComponent = SubstanceComboBoxUI.this.editorComponentToTextComponent(component);
                    if (jTextComponent != null) {
                        return jTextComponent;
                    }
                    if (component instanceof JTextComponent) {
                        return (JTextComponent)component;
                    }
                }
                return null;
            }
        });
    }

    public void uninstallUIInternal(JComponent jComponent) {
        jComponent.putClientProperty("substancelaf.internal.textComponentAware", null);
        super.uninstallUI(jComponent);
    }

    public SubstanceComboBoxUI(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(jComboBox.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.comboBox, this.transitionModel);
        this.delegate = new ComboBoxBackgroundDelegate();
    }

    @Override
    protected JButton createArrowButton() {
        SubstanceDropDownButton substanceDropDownButton = new SubstanceDropDownButton(this.comboBox);
        substanceDropDownButton.setFont(this.comboBox.getFont());
        substanceDropDownButton.setIcon(this.getCurrentIcon(substanceDropDownButton));
        return substanceDropDownButton;
    }

    private Icon getCurrentIcon(JButton jButton) {
        Icon icon = SubstanceCoreUtilities.getArrowIcon(jButton, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox));
        return icon;
    }

    protected ListCellRenderer createRenderer() {
        return new SubstanceDefaultComboBoxRenderer.SubstanceUIResource(this.comboBox);
    }

    protected void installListenersInternal() {
        super.installListeners();
        this.substanceChangeHandler = new ComboBoxPropertyChangeHandler();
        this.comboBox.addPropertyChangeListener(this.substanceChangeHandler);
        this.substanceRolloverListener = new RolloverTextControlListener(this.comboBox, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    protected void uninstallListenersInternal() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.comboBox.removePropertyChangeListener(this.substanceChangeHandler);
        this.substanceChangeHandler = null;
        this.substanceRolloverListener.unregisterListeners();
        this.substanceRolloverListener = null;
        super.uninstallListeners();
    }

    protected void installDefaultsInternal() {
        super.installDefaults();
        this.uneditableArrowIcon = SubstanceCoreUtilities.getArrowIcon(this.comboBox, new TransitionAwareIcon.TransitionAwareUIDelegate(){

            @Override
            public TransitionAwareUI getTransitionAwareUI() {
                return (TransitionAwareUI)((Object)SubstanceComboBoxUI.this.comboBox.getUI());
            }
        }, SubstanceCoreUtilities.getPopupFlyoutOrientation(this.comboBox));
        this.updateComboBoxBorder();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SubstanceComboBoxLayoutManager();
    }

    @Override
    protected Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.layoutInsets;
        int n3 = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.comboBox));
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, n - insets.left - insets.right - n3, n2 - insets.top - insets.bottom);
        }
        int n4 = insets.left + n3;
        return new Rectangle(n4, insets.top, n - n4 - insets.right, n2 - insets.top - insets.bottom);
    }

    @Override
    protected Dimension getDefaultSize() {
        Component component = new SubstanceDefaultComboBoxRenderer(this.comboBox).getListCellRendererComponent((JList<?>)this.listBox, " ", -1, false, false);
        component.setFont(this.comboBox.getFont());
        return component.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        SubstanceDropDownButton substanceDropDownButton = (SubstanceDropDownButton)this.arrowButton;
        Insets insets = substanceDropDownButton.getInsets();
        Insets insets2 = this.comboBox.getInsets();
        Dimension dimension = this.getDisplaySize();
        dimension.width += insets2.left + insets2.right;
        dimension.width += insets.left + insets.right;
        dimension.width = (int)((double)dimension.width + substanceDropDownButton.getMinimumSize().getWidth());
        dimension.height += insets2.top + insets2.bottom;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    protected ComboPopup createPopup() {
        final SubstanceComboPopup substanceComboPopup = new SubstanceComboPopup(this.comboBox);
        final ComponentOrientation componentOrientation = this.comboBox.getComponentOrientation();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComboBoxEditor comboBoxEditor;
                Object object;
                if (SubstanceComboBoxUI.this.comboBox == null) {
                    return;
                }
                if (substanceComboPopup instanceof Component) {
                    object = (Component)((Object)substanceComboPopup);
                    ((Component)object).applyComponentOrientation(componentOrientation);
                    ((Component)object).doLayout();
                }
                if ((object = SubstanceComboBoxUI.this.comboBox.getRenderer()) instanceof Component) {
                    ((Component)object).applyComponentOrientation(componentOrientation);
                }
                if ((comboBoxEditor = SubstanceComboBoxUI.this.comboBox.getEditor()) != null && comboBoxEditor.getEditorComponent() != null) {
                    comboBoxEditor.getEditorComponent().applyComponentOrientation(componentOrientation);
                }
                SubstanceComboBoxUI.this.comboBox.repaint();
            }
        });
        return substanceComboPopup;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n2 = this.comboBox.getWidth();
        int n3 = this.comboBox.getHeight();
        Insets insets = this.comboBox.getInsets();
        int n4 = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        if (this.comboBox.isEditable()) {
            int n5 = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(n4));
            object = SubstanceOutlineUtilities.getBaseOutline(n2, n3, Math.max(0.0f, 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius(n4) - (float)n5), null, n5);
            graphics2D.setColor(SubstanceTextUtilities.getTextBackgroundFillColor(this.comboBox));
            graphics2D.fill((Shape)object);
        } else {
            this.delegate.updateBackground(graphics2D, this.comboBox, this.transitionModel);
            Icon icon = this.uneditableArrowIcon;
            int n6 = icon.getIconWidth();
            int n7 = icon.getIconHeight();
            n = SubstanceSizeUtils.getScrollBarWidth(n4);
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                int n8 = n2 - n - insets.right / 2 + (n - n6) / 2;
                int n9 = insets.top + (n3 - insets.top - insets.bottom - n7) / 2;
                icon.paintIcon(this.comboBox, graphics2D, n8, n9);
            } else {
                int n10 = insets.left / 2 + (n - n6) / 2;
                int n11 = insets.top + (n3 - insets.top - insets.bottom - n7) / 2;
                icon.paintIcon(this.comboBox, graphics2D, n10, n11);
            }
        }
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            object = this.comboBox.getRenderer();
            Component component = this.hasFocus ? object.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, this.hasFocus) : object.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, this.hasFocus);
            component.setFont(this.comboBox.getFont());
            n = 0;
            if (component instanceof JPanel) {
                n = 1;
            }
            if (this.comboBox.getComponentOrientation().isLeftToRight()) {
                this.currentValuePane.paintComponent(graphics2D, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n != 0);
            } else {
                this.currentValuePane.paintComponent(graphics2D, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n != 0);
            }
        }
        if (!this.comboBox.isEditable()) {
            Rectangle rectangle = new Rectangle(insets.left, this.layoutInsets.top, n2 - insets.left - insets.right, n3 - this.layoutInsets.top - this.layoutInsets.bottom);
            this.paintFocus(graphics2D, rectangle);
        }
        graphics2D.dispose();
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle) {
        int n = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
        int n2 = SubstanceSizeUtils.getFocusRingPadding(n) / 2;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n3, n4);
        SubstanceCoreUtilities.paintFocus(graphics2D, this.comboBox, this.comboBox, this, SubstanceOutlineUtilities.getBaseOutline(rectangle.width, rectangle.height, SubstanceSizeUtils.getClassicButtonCornerRadius(n), null, 0), rectangle, 1.0f, n2);
        graphics2D.dispose();
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
        this.arrowButton.setFocusable(false);
        this.configureArrowButtonStraightSide();
    }

    protected void configureArrowButtonStraightSide() {
        this.arrowButton.putClientProperty("substancelaf.buttonside", (Object)(this.comboBox.getComponentOrientation().isLeftToRight() ? SubstanceConstants.Side.LEFT : SubstanceConstants.Side.RIGHT));
    }

    @Override
    public void unconfigureArrowButton() {
        super.unconfigureArrowButton();
    }

    @Override
    public void addEditor() {
        this.removeEditor();
        this.editor = this.comboBox.getEditor().getEditorComponent();
        if (this.editor != null) {
            this.configureEditor();
            this.comboBox.add(this.editor);
            if (this.comboBox.isFocusOwner()) {
                this.editor.requestFocusInWindow();
            }
        }
    }

    @Override
    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.comboBox.remove(this.editor);
            this.editor = null;
        }
    }

    @Override
    protected void configureEditor() {
        Serializable serializable;
        super.configureEditor();
        if (this.editor instanceof JComponent) {
            serializable = SubstanceSizeUtils.getComboTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.editor));
            ((JComponent)this.editor).setBorder(new EmptyBorder(((Insets)serializable).top, ((Insets)serializable).left, ((Insets)serializable).bottom, ((Insets)serializable).right));
        }
        if (!(this.editor instanceof JTextComponent)) {
            this.editor.setFocusable(false);
        }
        if ((serializable = this.editorComponentToTextComponent(this.editor)) == null) {
            return;
        }
        if (this.autoResizeDocumentHandler == null) {
            this.autoResizeDocumentHandler = new AutoResizeDocumentHandler();
        }
        ((JTextComponent)serializable).getDocument().addDocumentListener(this.autoResizeDocumentHandler);
        this.autoResizeDocumentHandler.documentUpdated(((JTextComponent)serializable).getDocument());
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.autoResizeDocumentHandler != null) {
            JTextComponent jTextComponent = this.editorComponentToTextComponent(this.editor);
            if (jTextComponent == null) {
                return;
            }
            jTextComponent.getDocument().removeDocumentListener(this.autoResizeDocumentHandler);
        }
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new SubstanceComboBoxEditor.UIResource();
    }

    private void updateComboBoxBorder() {
        Border border = this.comboBox.getBorder();
        if (border == null || border instanceof UIResource) {
            int n = SubstanceSizeUtils.getComponentFontSize(this.comboBox);
            Insets insets = SubstanceSizeUtils.getComboBorderInsets(n);
            if (this.comboBox.isEditable()) {
                if (!this.isFlat()) {
                    this.comboBox.setBorder(new SubstanceTextComponentBorder(insets));
                } else {
                    this.comboBox.setBorder(null);
                }
            } else {
                this.comboBox.setBorder(new BorderUIResource.EmptyBorderUIResource(insets));
                this.comboBox.setPrototypeDisplayValue(this.comboBox.getPrototypeDisplayValue());
            }
            this.layoutInsets = SubstanceSizeUtils.getComboLayoutInsets(n);
        } else {
            this.layoutInsets = new Insets(0, 0, 0, 0);
        }
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return false;
        }
        ClassicButtonShaper classicButtonShaper = ClassicButtonShaper.INSTANCE;
        if (classicButtonShaper == null) {
            return false;
        }
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(this.comboBox, SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.comboBox)), null);
        return generalPath.contains(mouseEvent.getPoint());
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.installUIInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallUIInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    private JTextComponent editorComponentToTextComponent(Component component) {
        if (!(component instanceof JTextComponent)) {
            Container container;
            if (component instanceof JScrollPane) {
                JScrollPane jScrollPane = (JScrollPane)component;
                component = jScrollPane.getViewport().getView();
            } else if (component instanceof Container && (container = (Container)component).getComponentCount() > 0) {
                component = container.getComponent(0);
            }
        }
        if (component instanceof JTextComponent) {
            return (JTextComponent)component;
        }
        return null;
    }

    @Override
    protected ListDataListener createListDataListener() {
        return new BasicComboBoxUI.ListDataHandler(){

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                if (listDataEvent.getIndex0() == -2) {
                    SubstanceComboBoxUI.this.comboBox.repaint();
                } else {
                    super.contentsChanged(listDataEvent);
                }
            }
        };
    }

    public Rectangle getArrowButtonBounds(int n, int n2) {
        int n3;
        if (this.arrowButton == null) {
            return new Rectangle();
        }
        Insets insets = this.getInsets();
        int n4 = n3 = n2 - (insets.top + insets.bottom);
        Insets insets2 = this.arrowButton.getInsets();
        n4 = this.squareButton ? n3 : this.arrowButton.getPreferredSize().width + insets2.left + insets2.right;
        return new Rectangle(n - (insets.right + n4), insets.top, n4, n3);
    }

    public JButton getArrowButton() {
        return this.arrowButton;
    }

    private boolean isFlat() {
        if (this.comboBox == null) {
            return false;
        }
        return Boolean.TRUE.equals(this.comboBox.getClientProperty("substancelaf.componentFlat"));
    }

    private boolean isAutoResize() {
        if (this.comboBox == null) {
            return false;
        }
        return Boolean.TRUE.equals(this.comboBox.getClientProperty("substancelaf.comboxautoresize"));
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        SubstanceDropDownButton substanceDropDownButton = (SubstanceDropDownButton)this.arrowButton;
        Insets insets = substanceDropDownButton.getInsets();
        Insets insets2 = this.comboBox.getInsets();
        Dimension dimension = this.getPreferredDisplaySize();
        dimension.width += insets2.left + insets2.right;
        dimension.width += insets.left + insets.right;
        dimension.width = (int)((double)dimension.width + substanceDropDownButton.getMinimumSize().getWidth());
        dimension.height += insets2.top + insets2.bottom;
        return dimension;
    }

    private Dimension getModelMinimumSize() {
        DefaultListCellRenderer defaultListCellRenderer = this.comboBox.getRenderer();
        if (defaultListCellRenderer == null) {
            defaultListCellRenderer = new DefaultListCellRenderer();
        }
        Dimension dimension = new Dimension(this.minimumWidth, 0);
        if (this.comboBox.getPrototypeDisplayValue() != null) {
            Dimension dimension2 = this.getSizeForComponent(defaultListCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getPrototypeDisplayValue(), -1, false, false));
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height = dimension2.height;
        } else {
            ComboBoxModel comboBoxModel = this.comboBox.getModel();
            int n = Math.min(comboBoxModel.getSize(), 1000);
            for (int i = 0; i < n; ++i) {
                Dimension dimension3 = this.getSizeForComponent(defaultListCellRenderer.getListCellRendererComponent(this.listBox, comboBoxModel.getElementAt(i), -1, false, false));
                dimension.width = Math.max(dimension.width, dimension3.width);
                dimension.height = Math.max(dimension.height, dimension3.height);
            }
        }
        return dimension;
    }

    @Override
    protected Dimension getDisplaySize() {
        Dimension dimension = new Dimension();
        int n = 0;
        Dimension dimension2 = this.getModelMinimumSize();
        dimension.height = dimension2.height;
        dimension.width = n;
        if (this.comboBox.isEditable()) {
            Dimension dimension3 = this.editor.getPreferredSize();
            dimension.height = Math.max(dimension.height, dimension3.height);
        }
        if (this.padding != null) {
            dimension.width += this.padding.left + this.padding.right;
            dimension.height += this.padding.top + this.padding.bottom;
        }
        return dimension;
    }

    private Dimension getPreferredDisplaySize() {
        Dimension dimension = new Dimension();
        int n = this.currentWidth;
        n = Math.max(n, this.minimumWidth);
        if (this.padding != null) {
            n += this.padding.left + this.padding.right;
        }
        Dimension dimension2 = this.getModelMinimumSize();
        dimension.width = this.comboBox.isEditable() && this.isAutoResize() ? n : Math.max(dimension2.width, n);
        dimension.height = dimension2.height;
        return dimension;
    }

    public class ComboBoxPropertyChangeHandler
    extends BasicComboBoxUI.PropertyChangeHandler {
        public ComboBoxPropertyChangeHandler() {
            super(SubstanceComboBoxUI.this);
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("componentOrientation")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SubstanceComboBoxUI.this.comboBox == null) {
                            return;
                        }
                        ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                        ListCellRenderer listCellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                        ComboBoxEditor comboBoxEditor = SubstanceComboBoxUI.this.comboBox.getEditor();
                        if (SubstanceComboBoxUI.this.popup instanceof Component) {
                            Component component = (Component)((Object)SubstanceComboBoxUI.this.popup);
                            component.applyComponentOrientation(componentOrientation);
                            component.doLayout();
                        }
                        if (listCellRenderer instanceof Component) {
                            ((Component)((Object)listCellRenderer)).applyComponentOrientation(componentOrientation);
                        }
                        if (comboBoxEditor != null && comboBoxEditor.getEditorComponent() != null) {
                            comboBoxEditor.getEditorComponent().applyComponentOrientation(componentOrientation);
                        }
                        if (SubstanceComboBoxUI.this.comboBox != null) {
                            SubstanceComboBoxUI.this.comboBox.repaint();
                        }
                        SubstanceComboBoxUI.this.configureArrowButtonStraightSide();
                    }
                });
            }
            if ("substancelaf.comboboxpopupFlyoutOrientation".equals(string)) {
                ((SubstanceDropDownButton)SubstanceComboBoxUI.this.arrowButton).setIcon(SubstanceCoreUtilities.getArrowIcon(SubstanceComboBoxUI.this.arrowButton, SubstanceCoreUtilities.getPopupFlyoutOrientation(SubstanceComboBoxUI.this.comboBox)));
            }
            if ("substancelaf.componentFlat".equals(string)) {
                SubstanceComboBoxUI.this.updateComboBoxBorder();
            }
            if ("font".equals(string)) {
                SubstanceComboBoxUI.this.updateComboBoxBorder();
            }
            if ("background".equals(string) && SubstanceComboBoxUI.this.comboBox.isEditable()) {
                SubstanceComboBoxUI.this.comboBox.getEditor().getEditorComponent().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
                SubstanceComboBoxUI.this.popup.getList().setBackground(SubstanceComboBoxUI.this.comboBox.getBackground());
            }
            if ("editable".equals(string)) {
                SubstanceComboBoxUI.this.updateComboBoxBorder();
                SubstanceComboBoxUI.this.isMinimumSizeDirty = true;
            }
            if ("enabled".equals(string)) {
                SubstanceComboBoxUI.this.transitionModel.setEnabled(SubstanceComboBoxUI.this.comboBox.isEnabled());
            }
        }
    }

    private class SubstanceComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        private SubstanceComboBoxLayoutManager() {
            super(SubstanceComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container container) {
            JComboBox jComboBox = (JComboBox)container;
            int n = jComboBox.getWidth();
            int n2 = jComboBox.getHeight();
            Insets insets = SubstanceComboBoxUI.this.layoutInsets;
            int n3 = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(SubstanceComboBoxUI.this.comboBox));
            if (SubstanceComboBoxUI.this.arrowButton != null) {
                if (!SubstanceComboBoxUI.this.comboBox.isEditable()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(0, 0, 0, 0);
                } else if (jComboBox.getComponentOrientation().isLeftToRight()) {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(n - n3 - insets.right, 0, n3 + insets.right, n2);
                } else {
                    SubstanceComboBoxUI.this.arrowButton.setBounds(0, 0, n3 + insets.left, n2);
                }
            }
            if (SubstanceComboBoxUI.this.editor != null) {
                Rectangle rectangle = SubstanceComboBoxUI.this.rectangleForCurrentValue();
                SubstanceComboBoxUI.this.editor.setBounds(rectangle);
            }
        }
    }

    private class AutoResizeDocumentHandler
    implements DocumentListener {
        private AutoResizeDocumentHandler() {
        }

        private void documentUpdated(Document document) {
            if (!SubstanceComboBoxUI.this.isAutoResize()) {
                return;
            }
            try {
                DefaultListCellRenderer defaultListCellRenderer = SubstanceComboBoxUI.this.comboBox.getRenderer();
                if (defaultListCellRenderer == null) {
                    defaultListCellRenderer = new DefaultListCellRenderer();
                }
                String string = document.getText(0, document.getLength());
                int n = ((SubstanceComboBoxUI)SubstanceComboBoxUI.this).getSizeForComponent((Component)defaultListCellRenderer.getListCellRendererComponent(((SubstanceComboBoxUI)SubstanceComboBoxUI.this).listBox, string, (int)-1, (boolean)false, (boolean)false)).width;
                if (n != SubstanceComboBoxUI.this.currentWidth) {
                    SubstanceComboBoxUI.this.currentWidth = n;
                    SubstanceComboBoxUI.this.isMinimumSizeDirty = true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentUpdated(documentEvent.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentUpdated(documentEvent.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.documentUpdated(documentEvent.getDocument());
        }
    }
}

