/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;

public class SubstanceDesktopIconUI
extends BasicDesktopIconUI {
    private MouseInputListener substanceLabelMouseInputListener;
    private int width;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceDesktopIconUI();
    }

    protected void installDefaultsInternal() {
        super.installDefaults();
        Font font = this.desktopIcon.getFont();
        if (font == null || font instanceof UIResource) {
            this.desktopIcon.setFont(UIManager.getFont("DesktopIcon.font"));
        }
        this.width = UIManager.getInt("DesktopIcon.width");
        this.desktopIcon.setBackground(SubstanceCoreUtilities.getSkin(this.desktopIcon.getInternalFrame()).getBackgroundColorScheme(DecorationAreaType.SECONDARY_TITLE_PANE).getBackgroundFillColor());
    }

    protected void installComponentsInternal() {
        this.frame = this.desktopIcon.getInternalFrame();
        this.iconPane = new SubstanceInternalFrameTitlePane(this.frame);
        this.iconPane.setOpaque(false);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    protected void uninstallComponentsInternal() {
        ((SubstanceInternalFrameTitlePane)this.iconPane).uninstall();
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconPane);
        this.frame = null;
    }

    protected void installListenersInternal() {
        super.installListeners();
        this.substanceLabelMouseInputListener = this.createMouseInputListener();
        this.iconPane.addMouseMotionListener(this.substanceLabelMouseInputListener);
        this.iconPane.addMouseListener(this.substanceLabelMouseInputListener);
    }

    protected void uninstallListenersInternal() {
        ((SubstanceInternalFrameTitlePane)this.iconPane).uninstallListeners();
        this.iconPane.removeMouseMotionListener(this.substanceLabelMouseInputListener);
        this.iconPane.removeMouseListener(this.substanceLabelMouseInputListener);
        this.substanceLabelMouseInputListener = null;
        super.uninstallListeners();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(this.width, this.desktopIcon.getLayout().minimumLayoutSize((Container)this.desktopIcon).height);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    private void installUIInternal(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
    }

    private void uninstallUIInternal(JComponent jComponent) {
        SubstanceInternalFrameTitlePane substanceInternalFrameTitlePane = (SubstanceInternalFrameTitlePane)this.iconPane;
        super.uninstallUI(jComponent);
        substanceInternalFrameTitlePane.uninstallListeners();
    }

    public JComponent getComponentForHover() {
        return this.iconPane;
    }

    public void installIfNecessary(JInternalFrame.JDesktopIcon jDesktopIcon) {
        if (this.desktopIcon == null) {
            this.installUI(jDesktopIcon);
        }
    }

    public void uninstallIfNecessary(JInternalFrame.JDesktopIcon jDesktopIcon) {
        if (this.desktopIcon == jDesktopIcon) {
            this.uninstallUI(jDesktopIcon);
        }
    }

    void setWindowModified(boolean bl) {
        ((SubstanceInternalFrameTitlePane)this.iconPane).getCloseButton().putClientProperty("windowModified", bl);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.installUIInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installComponents() {
        this.installComponentsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallUIInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallComponents() {
        this.uninstallComponentsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

