/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;

public class SubstanceEditorPaneUI
extends BasicEditorPaneUI
implements TransitionAwareUI {
    protected StateTransitionTracker stateTransitionTracker;
    protected JEditorPane editorPane;
    protected PropertyChangeListener substancePropertyChangeListener;
    private RolloverTextControlListener substanceRolloverListener;
    private ButtonModel transitionModel;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceEditorPaneUI(jComponent);
    }

    public SubstanceEditorPaneUI(JComponent jComponent) {
        this.editorPane = (JEditorPane)jComponent;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(this.editorPane.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.editorPane, this.transitionModel);
    }

    private void installListenersInternal() {
        super.installListeners();
        this.substanceRolloverListener = new RolloverTextControlListener(this.editorPane, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceEditorPaneUI.this.transitionModel.setEnabled(SubstanceEditorPaneUI.this.editorPane.isEnabled());
                }
            }
        };
        this.editorPane.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    private void uninstallListenersInternal() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.editorPane.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    private void installDefaultsInternal() {
        super.installDefaults();
        this.editorPane.putClientProperty("substancelaf.colorizationFactor", 1.0);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SubstanceEditorPaneUI.this.editorPane == null) {
                    return;
                }
                Color color = SubstanceEditorPaneUI.this.editorPane.getForeground();
                if (color == null || color instanceof UIResource) {
                    SubstanceEditorPaneUI.this.editorPane.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(SubstanceEditorPaneUI.this.editorPane).getEnabledColorScheme(SubstanceLookAndFeel.getDecorationType(SubstanceEditorPaneUI.this.editorPane))));
                }
            }
        });
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        SubstanceTextUtilities.paintTextCompBackground(graphics, this.editorPane);
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

