/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceFileChooserUI
extends MetalFileChooserUI {
    private final SubstanceFileView fileView = new SubstanceFileView();
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceFileChooserUI((JFileChooser)jComponent);
    }

    public SubstanceFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    @Override
    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults(JFileChooser jFileChooser) {
        super.installDefaults(jFileChooser);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    public void installComponents(JFileChooser jFileChooser) {
        super.installComponents(jFileChooser);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void installListeners(JFileChooser jFileChooser) {
        super.installListeners(jFileChooser);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults(JFileChooser jFileChooser) {
        super.uninstallDefaults(jFileChooser);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    public void uninstallComponents(JFileChooser jFileChooser) {
        super.uninstallComponents(jFileChooser);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners(JFileChooser jFileChooser) {
        super.uninstallListeners(jFileChooser);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    private class SubstanceFileView
    extends BasicFileChooserUI.BasicFileView {
        private final Map<String, Icon> pathIconCache;

        private SubstanceFileView() {
            super(SubstanceFileChooserUI.this);
            this.pathIconCache = new HashMap<String, Icon>();
        }

        @Override
        public Icon getCachedIcon(File file) {
            return this.pathIconCache.get(file.getPath());
        }

        @Override
        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = this.getDefaultIcon(file);
            if (icon == null && (icon = super.getIcon(file)) == null) {
                icon = new ImageIcon(SubstanceCoreUtilities.getBlankImage(8, 8));
            }
            this.cacheIcon(file, icon);
            return icon;
        }

        @Override
        public void cacheIcon(File file, Icon icon) {
            this.pathIconCache.put(file.getPath(), icon);
        }

        @Override
        public void clearIconCache() {
            this.pathIconCache.clear();
        }

        public Icon getDefaultIcon(File file) {
            JFileChooser jFileChooser = SubstanceFileChooserUI.this.getFileChooser();
            Icon icon = jFileChooser.getFileSystemView().getSystemIcon(file);
            if (SubstanceCoreUtilities.useThemedDefaultIcon(null)) {
                icon = SubstanceCoreUtilities.getThemedIcon(jFileChooser, icon);
            }
            return icon;
        }
    }
}

