/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceDesktopIconUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;

public class SubstanceInternalFrameUI
extends BasicInternalFrameUI {
    private SubstanceInternalFrameTitlePane titlePane;
    protected PropertyChangeListener substancePropertyListener;
    protected Set lafWidgets;

    public SubstanceInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceInternalFrameUI((JInternalFrame)jComponent);
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new SubstanceInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    private void installComponentsInternal() {
        if (SubstanceCoreUtilities.isRoundedCorners(this.frame)) {
            this.frame.setOpaque(false);
        }
        super.installComponents();
    }

    private void uninstallComponentsInternal() {
        this.titlePane.uninstall();
        super.uninstallComponents();
    }

    private void installListenersInternal() {
        super.installListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if ("closed".equals(string)) {
                    SubstanceInternalFrameUI.this.titlePane.uninstall();
                    JInternalFrame.JDesktopIcon jDesktopIcon = SubstanceInternalFrameUI.this.frame.getDesktopIcon();
                    SubstanceDesktopIconUI substanceDesktopIconUI = (SubstanceDesktopIconUI)jDesktopIcon.getUI();
                    substanceDesktopIconUI.uninstallIfNecessary(jDesktopIcon);
                } else if ("background".equals(string)) {
                    Color color = (Color)propertyChangeEvent.getNewValue();
                    if (!(color instanceof UIResource)) {
                        SubstanceInternalFrameUI.this.getTitlePane().setBackground(color);
                        SubstanceInternalFrameUI.this.frame.getDesktopIcon().setBackground(color);
                    }
                } else if ("ancestor".equals(string)) {
                    JInternalFrame.JDesktopIcon jDesktopIcon = SubstanceInternalFrameUI.this.frame.getDesktopIcon();
                    SubstanceDesktopIconUI substanceDesktopIconUI = (SubstanceDesktopIconUI)jDesktopIcon.getUI();
                    substanceDesktopIconUI.installIfNecessary(jDesktopIcon);
                } else if ("selected".equals(string)) {
                    SubstanceInternalFrameUI.this.titlePane.setActive((Boolean)propertyChangeEvent.getNewValue());
                } else if (("windowRoundedCorners".equals(string) || "maximum".equals(string)) && SubstanceCoreUtilities.isRoundedCorners(SubstanceInternalFrameUI.this.frame)) {
                    SubstanceInternalFrameUI.this.frame.setOpaque(false);
                }
            }
        };
        this.frame.addPropertyChangeListener(this.substancePropertyListener);
    }

    private void uninstallListenersInternal() {
        this.frame.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners();
    }

    public SubstanceInternalFrameTitlePane getTitlePane() {
        return this.titlePane;
    }

    void setWindowModified(boolean bl) {
        this.titlePane.getCloseButton().putClientProperty("windowModified", bl);
        SubstanceDesktopIconUI substanceDesktopIconUI = (SubstanceDesktopIconUI)this.frame.getDesktopIcon().getUI();
        substanceDesktopIconUI.setWindowModified(bl);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installComponents() {
        this.installComponentsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallComponents() {
        this.uninstallComponentsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

