/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.IconGlowTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;

public class SubstanceOptionPaneUI
extends BasicOptionPaneUI {
    private OptionPaneLabel substanceIconLabel;
    private IconGlowTracker iconGlowTracker;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceOptionPaneUI();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        BackgroundPaintingUtils.updateIfOpaque(graphics, jComponent);
    }

    @Override
    protected void addIcon(Container container) {
        Icon icon;
        Icon icon2 = icon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (icon == null && this.optionPane != null) {
            icon = super.getIconForType(this.optionPane.getMessageType());
        }
        if (icon != null) {
            if (!SubstanceLookAndFeel.isToUseConstantThemesOnDialogs()) {
                icon = SubstanceCoreUtilities.getThemedIcon(null, icon);
            }
            this.substanceIconLabel = new OptionPaneLabel();
            this.iconGlowTracker = new IconGlowTracker(this.substanceIconLabel);
            this.substanceIconLabel.setIcon(new GlowingIcon(icon, this.iconGlowTracker));
            this.substanceIconLabel.setName("OptionPane.iconLabel");
            this.substanceIconLabel.setVerticalAlignment(1);
            container.add((Component)this.substanceIconLabel, "Before");
        }
    }

    @Override
    protected Icon getIconForType(int n) {
        switch (n) {
            case 0: {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-error.png");
            }
            case 1: {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-information.png");
            }
            case 2: {
                return SubstanceCoreUtilities.getIcon("resource/32/dialog-warning.png");
            }
            case 3: {
                return SubstanceCoreUtilities.getIcon("resource/32/help-browser.png");
            }
        }
        return null;
    }

    private void installComponentsInternal() {
        super.installComponents();
        if (this.substanceIconLabel != null && !this.iconGlowTracker.isPlaying()) {
            this.iconGlowTracker.play(3);
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installComponents() {
        this.installComponentsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallComponents() {
        super.uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    static {
        AnimationConfigurationManager.getInstance().allowAnimations(AnimationFacet.ICON_GLOW, OptionPaneLabel.class);
    }

    protected static class OptionPaneLabel
    extends JLabel {
        protected OptionPaneLabel() {
        }
    }
}

