/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenuBackgroundDelegate;

public class SubstancePopupMenuSeparatorUI
extends BasicPopupMenuSeparatorUI {
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstancePopupMenuSeparatorUI();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        JSeparator jSeparator = (JSeparator)jComponent;
        int n = MenuUtilities.getTextOffset(jSeparator, jSeparator.getParent());
        SubstanceMenuBackgroundDelegate.paintBackground(graphics2D, jComponent, n);
        Dimension dimension = jComponent.getSize();
        int n2 = 0;
        int n3 = dimension.width;
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            n2 = n - 2;
            n3 = dimension.width - n2;
        } else {
            n2 = 0;
            n3 = n > 0 ? n - 4 : dimension.width;
        }
        graphics2D.translate(n2, 0);
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jSeparator));
        SeparatorPainterUtils.paintSeparator(jSeparator, graphics2D, n3, dimension.height, jSeparator.getOrientation(), true, 2);
        graphics2D.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jComponent));
        int n = (int)Math.ceil(2.0 * (double)f);
        return new Dimension(0, n);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults(JSeparator jSeparator) {
        super.installDefaults(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners(JSeparator jSeparator) {
        super.installListeners(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults(JSeparator jSeparator) {
        super.uninstallDefaults(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners(JSeparator jSeparator) {
        super.uninstallListeners(jSeparator);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

