/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.menu.MenuUtilities;

public class SubstancePopupMenuUI
extends BasicPopupMenuUI {
    protected ContainerListener substanceContainerListener;
    protected PopupMenuListener substancePopupMenuListener;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstancePopupMenuUI();
    }

    private void installListenersInternal() {
        super.installListeners();
        this.substanceContainerListener = new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                MenuUtilities.cleanPopupLayoutMetrics(SubstancePopupMenuUI.this.popupMenu);
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                MenuUtilities.cleanPopupLayoutMetrics(SubstancePopupMenuUI.this.popupMenu);
            }
        };
        this.popupMenu.addContainerListener(this.substanceContainerListener);
        this.substancePopupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                for (int i = 0; i < SubstancePopupMenuUI.this.popupMenu.getComponentCount(); ++i) {
                    JMenuItem jMenuItem;
                    Component component = SubstancePopupMenuUI.this.popupMenu.getComponent(i);
                    if (!(component instanceof JMenuItem) || !(jMenuItem = (JMenuItem)component).isEnabled() || !jMenuItem.getModel().isArmed()) continue;
                    jMenuItem.getModel().setArmed(false);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                for (int i = 0; i < SubstancePopupMenuUI.this.popupMenu.getComponentCount(); ++i) {
                    JMenuItem jMenuItem;
                    Component component = SubstancePopupMenuUI.this.popupMenu.getComponent(i);
                    if (!(component instanceof JMenuItem) || !(jMenuItem = (JMenuItem)component).isEnabled() || !jMenuItem.getModel().isArmed()) continue;
                    jMenuItem.getModel().setArmed(false);
                }
            }
        };
        this.popupMenu.addPopupMenuListener(this.substancePopupMenuListener);
    }

    private void uninstallListenersInternal() {
        this.popupMenu.removeContainerListener(this.substanceContainerListener);
        this.substanceContainerListener = null;
        this.popupMenu.removePopupMenuListener(this.substancePopupMenuListener);
        this.substancePopupMenuListener = null;
        super.uninstallListeners();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }
}

