/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.internal.animation.RootPaneDefaultButtonTracker;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceInternalFrameUI;
import org.pushingpixels.substance.internal.utils.MemoryAnalyzer;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceTitlePane;

public class SubstanceRootPaneUI
extends BasicRootPaneUI {
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window window;
    private JComponent titlePane;
    private MouseInputListener substanceMouseInputListener;
    private MouseInputListener substanceTitleMouseInputListener;
    private LayoutManager layoutManager;
    private LayoutManager savedOldLayout;
    protected JRootPane root;
    protected WindowListener substanceWindowListener;
    protected Window substanceCurrentWindow;
    protected HierarchyListener substanceHierarchyListener;
    protected ComponentListener substanceWindowComponentListener;
    protected GraphicsConfiguration currentRootPaneGC;
    protected PropertyChangeListener substancePropertyChangeListener;
    private Cursor lastCursor = Cursor.getPredefinedCursor(0);
    private static int rootPanesWithCustomSkin = 0;
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};
    public static ComponentListener WINDOW_ROUNDER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Window window;
            if (componentEvent.getComponent() instanceof Window && ((window = (Window)componentEvent.getComponent()) instanceof Frame && !((Frame)window).isUndecorated() || window instanceof Dialog && !((Dialog)window).isUndecorated())) {
                return;
            }
        }
    };
    static HierarchyListener RESIZE_LOADER = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (!(hierarchyEvent.getChangedParent() instanceof Dialog) && !(hierarchyEvent.getChangedParent() instanceof Frame)) {
                hierarchyEvent.getChanged().removeHierarchyListener(this);
                return;
            }
            if (hierarchyEvent.getID() != 1400 || !(hierarchyEvent.getChanged() instanceof JRootPane)) {
                return;
            }
            Window window = (Window)hierarchyEvent.getChangedParent();
            if (window != null) {
                if (!Arrays.asList(window.getComponentListeners()).contains(WINDOW_ROUNDER)) {
                    window.addComponentListener(WINDOW_ROUNDER);
                }
                hierarchyEvent.getChanged().removeHierarchyListener(this);
            }
        }
    };
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceRootPaneUI();
    }

    private void installUIInternal(JComponent jComponent) {
        super.installUI(jComponent);
        if (SubstanceCoreUtilities.isRoundedCorners(jComponent)) {
            jComponent.addHierarchyListener(RESIZE_LOADER);
        }
        this.root = (JRootPane)jComponent;
        int n = this.root.getWindowDecorationStyle();
        if (n != 0) {
            this.installClientDecorations(this.root);
        }
        if (SubstanceCoreUtilities.isRootPaneModified(this.root)) {
            this.propagateModificationState();
        }
        if (this.root.getClientProperty("substancelaf.skin") instanceof SubstanceSkin) {
            ++rootPanesWithCustomSkin;
        }
    }

    private void uninstallUIInternal(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallClientDecorations(this.root);
        this.layoutManager = null;
        this.substanceMouseInputListener = null;
        if (this.root.getClientProperty("substancelaf.skin") instanceof SubstanceSkin) {
            --rootPanesWithCustomSkin;
        }
        this.root = null;
    }

    public void installBorder(JRootPane jRootPane) {
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            LookAndFeel.uninstallBorder(jRootPane);
        } else {
            LookAndFeel.installBorder(jRootPane, "RootPane.border");
        }
    }

    private void uninstallBorder(JRootPane jRootPane) {
        LookAndFeel.uninstallBorder(jRootPane);
    }

    private void installDefaultsInternal(JRootPane jRootPane) {
        Color color;
        super.installDefaults(jRootPane);
        Color color2 = jRootPane.getBackground();
        if ((color2 == null || color2 instanceof UIResource) && (color = SubstanceColorUtilities.getBackgroundFillColor(jRootPane)) != null) {
            jRootPane.setBackground(new ColorUIResource(color));
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.updateInternal(graphics2D, jComponent);
        graphics2D.dispose();
    }

    private void updateInternal(Graphics graphics, JComponent jComponent) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        if (SubstanceCoreUtilities.isOpaque(jComponent)) {
            BackgroundPaintingUtils.update(graphics, jComponent, false);
        }
        super.paint(graphics, jComponent);
    }

    private void installWindowListeners(JRootPane jRootPane, Component component) {
        this.window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        if (this.window != null) {
            if (this.substanceMouseInputListener == null) {
                this.substanceMouseInputListener = this.createWindowMouseInputListener(jRootPane);
            }
            this.window.addMouseListener(this.substanceMouseInputListener);
            this.window.addMouseMotionListener(this.substanceMouseInputListener);
            if (this.titlePane != null) {
                if (this.substanceTitleMouseInputListener == null) {
                    this.substanceTitleMouseInputListener = new TitleMouseInputHandler();
                }
                this.titlePane.addMouseMotionListener(this.substanceTitleMouseInputListener);
                this.titlePane.addMouseListener(this.substanceTitleMouseInputListener);
            }
            this.setMaximized();
        }
    }

    private void uninstallWindowListeners(JRootPane jRootPane) {
        if (this.window != null) {
            this.window.removeMouseListener(this.substanceMouseInputListener);
            this.window.removeMouseMotionListener(this.substanceMouseInputListener);
        }
        if (this.titlePane != null) {
            this.titlePane.removeMouseListener(this.substanceTitleMouseInputListener);
            this.titlePane.removeMouseMotionListener(this.substanceTitleMouseInputListener);
        }
    }

    private void installLayout(JRootPane jRootPane) {
        if (this.layoutManager == null) {
            this.layoutManager = this.createLayoutManager();
        }
        this.savedOldLayout = jRootPane.getLayout();
        jRootPane.setLayout(this.layoutManager);
    }

    private void installListenersInternal(final JRootPane jRootPane) {
        super.installListeners(jRootPane);
        this.substanceHierarchyListener = new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                Container container = jRootPane.getParent();
                if (container == null) {
                    return;
                }
                if (MemoryAnalyzer.isRunning()) {
                    MemoryAnalyzer.enqueueUsage("Root pane @" + jRootPane.hashCode() + "\n" + SubstanceCoreUtilities.getHierarchy(container));
                }
                if (container.getClass().getName().startsWith("org.jdesktop.jdic.tray") || container.getClass().getName().compareTo("javax.swing.Popup$HeavyWeightWindow") == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jRootPane.removeHierarchyListener(SubstanceRootPaneUI.this.substanceHierarchyListener);
                            SubstanceRootPaneUI.this.substanceHierarchyListener = null;
                        }
                    });
                }
                Window window = container instanceof Window ? (Window)container : SwingUtilities.getWindowAncestor(container);
                if (SubstanceRootPaneUI.this.substanceWindowListener != null) {
                    SubstanceRootPaneUI.this.substanceCurrentWindow.removeWindowListener(SubstanceRootPaneUI.this.substanceWindowListener);
                    SubstanceRootPaneUI.this.substanceWindowListener = null;
                }
                if (SubstanceRootPaneUI.this.substanceWindowComponentListener != null) {
                    SubstanceRootPaneUI.this.substanceCurrentWindow.removeComponentListener(SubstanceRootPaneUI.this.substanceWindowComponentListener);
                    SubstanceRootPaneUI.this.substanceWindowComponentListener = null;
                }
                if (window != null) {
                    SubstanceRootPaneUI.this.substanceWindowListener = new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                            SubstanceCoreUtilities.testWindowCloseThreadingViolation(windowEvent.getWindow());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Frame[] frameArray;
                                    for (Frame frame : frameArray = Frame.getFrames()) {
                                        if (!frame.isDisplayable()) continue;
                                        return;
                                    }
                                    SubstanceCoreUtilities.stopThreads();
                                }
                            });
                        }
                    };
                    if (!(container instanceof JInternalFrame)) {
                        window.addWindowListener(SubstanceRootPaneUI.this.substanceWindowListener);
                    }
                    SubstanceRootPaneUI.this.substanceWindowComponentListener = new ComponentAdapter(){

                        @Override
                        public void componentMoved(ComponentEvent componentEvent) {
                            this.processNewPosition();
                        }

                        @Override
                        public void componentResized(ComponentEvent componentEvent) {
                            this.processNewPosition();
                        }

                        protected void processNewPosition() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (SubstanceRootPaneUI.this.window == null) {
                                        return;
                                    }
                                    if (!SubstanceRootPaneUI.this.window.isShowing() || !SubstanceRootPaneUI.this.window.isDisplayable()) {
                                        SubstanceRootPaneUI.this.currentRootPaneGC = null;
                                        return;
                                    }
                                    GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                                    GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
                                    if (graphicsDeviceArray.length == 1) {
                                        return;
                                    }
                                    Point point = new Point(SubstanceRootPaneUI.this.window.getLocationOnScreen().x + SubstanceRootPaneUI.this.window.getWidth() / 2, SubstanceRootPaneUI.this.window.getLocationOnScreen().y + SubstanceRootPaneUI.this.window.getHeight() / 2);
                                    for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
                                        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                                        Rectangle rectangle = graphicsConfiguration.getBounds();
                                        if (!rectangle.contains(point)) continue;
                                        if (graphicsConfiguration == SubstanceRootPaneUI.this.currentRootPaneGC) break;
                                        SubstanceRootPaneUI.this.currentRootPaneGC = graphicsConfiguration;
                                        SubstanceRootPaneUI.this.setMaximized();
                                        break;
                                    }
                                }
                            });
                        }
                    };
                    if (container instanceof JFrame) {
                        window.addComponentListener(SubstanceRootPaneUI.this.substanceWindowComponentListener);
                    }
                    SubstanceRootPaneUI.this.window = window;
                }
                SubstanceRootPaneUI.this.substanceCurrentWindow = window;
            }
        };
        jRootPane.addHierarchyListener(this.substanceHierarchyListener);
        JButton jButton = jRootPane.getDefaultButton();
        if (jButton != null) {
            RootPaneDefaultButtonTracker.update(jButton);
        }
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("defaultButton".equals(propertyChangeEvent.getPropertyName())) {
                    JButton jButton = (JButton)propertyChangeEvent.getOldValue();
                    JButton jButton2 = (JButton)propertyChangeEvent.getNewValue();
                    RootPaneDefaultButtonTracker.update(jButton);
                    RootPaneDefaultButtonTracker.update(jButton2);
                }
                if ("windowModified".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceRootPaneUI.this.propagateModificationState();
                }
            }
        };
        jRootPane.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    private void uninstallListenersInternal(JRootPane jRootPane) {
        if (this.window != null) {
            this.window.removeWindowListener(this.substanceWindowListener);
            this.substanceWindowListener = null;
            this.window.removeComponentListener(this.substanceWindowComponentListener);
            this.substanceWindowComponentListener = null;
        }
        jRootPane.removeHierarchyListener(this.substanceHierarchyListener);
        this.substanceHierarchyListener = null;
        jRootPane.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners(jRootPane);
    }

    private void uninstallLayout(JRootPane jRootPane) {
        if (this.savedOldLayout != null) {
            jRootPane.setLayout(this.savedOldLayout);
            this.savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane jRootPane) {
        this.installBorder(jRootPane);
        JComponent jComponent = this.createTitlePane(jRootPane);
        this.setTitlePane(jRootPane, jComponent);
        this.installWindowListeners(jRootPane, jRootPane.getParent());
        this.installLayout(jRootPane);
        if (this.window != null) {
            jRootPane.revalidate();
            jRootPane.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane jRootPane) {
        this.uninstallBorder(jRootPane);
        this.uninstallWindowListeners(jRootPane);
        this.setTitlePane(jRootPane, null);
        this.uninstallLayout(jRootPane);
        int n = jRootPane.getWindowDecorationStyle();
        if (n == 0) {
            jRootPane.repaint();
            jRootPane.revalidate();
        }
        if (this.window != null) {
            this.window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.window = null;
    }

    protected JComponent createTitlePane(JRootPane jRootPane) {
        return new SubstanceTitlePane(jRootPane, this);
    }

    private MouseInputListener createWindowMouseInputListener(JRootPane jRootPane) {
        return new MouseInputHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new SubstanceRootLayout();
    }

    private void setTitlePane(JRootPane jRootPane, JComponent jComponent) {
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        JComponent jComponent2 = this.getTitlePane();
        if (jComponent2 != null) {
            if (jComponent2 instanceof SubstanceTitlePane) {
                ((SubstanceTitlePane)jComponent2).uninstall();
            }
            jLayeredPane.remove(jComponent2);
        }
        if (jComponent != null) {
            jLayeredPane.add((Component)jComponent, JLayeredPane.FRAME_CONTENT_LAYER);
            jComponent.setVisible(true);
        }
        this.titlePane = jComponent;
    }

    public void setMaximized() {
        GraphicsDevice[] graphicsDeviceArray;
        Container container = this.root.getTopLevelAncestor();
        GraphicsConfiguration graphicsConfiguration = this.currentRootPaneGC != null ? this.currentRootPaneGC : container.getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle2 = new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        int n = 0;
        int n2 = 0;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle3 = graphicsConfiguration2.getBounds();
            int n3 = (int)(rectangle3.getWidth() * graphicsConfiguration2.getDefaultTransform().getScaleX());
            int n4 = (int)(rectangle3.getHeight() * graphicsConfiguration2.getDefaultTransform().getScaleY());
            n = n3 > n ? n3 : n;
            n2 = n4 > n2 ? n4 : n2;
        }
        rectangle2.width = n;
        rectangle2.height = n2;
        if (container instanceof JFrame) {
            ((JFrame)container).setMaximizedBounds(rectangle2);
        }
        if (MemoryAnalyzer.isRunning()) {
            MemoryAnalyzer.enqueueUsage("Frame set to bounds " + String.valueOf(rectangle2));
        }
    }

    public JComponent getTitlePane() {
        return this.titlePane;
    }

    protected JRootPane getRootPane() {
        return this.root;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (string.equals("windowDecorationStyle")) {
            object = (JRootPane)propertyChangeEvent.getSource();
            int n = ((JRootPane)object).getWindowDecorationStyle();
            this.uninstallClientDecorations((JRootPane)object);
            if (n != 0) {
                this.installClientDecorations((JRootPane)object);
            }
        }
        if (string.equals("ancestor")) {
            this.uninstallWindowListeners(this.root);
            if (((JRootPane)propertyChangeEvent.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this.root, this.root.getParent());
            }
        }
        if (string.equals("background")) {
            SubstanceLookAndFeel.getTitlePaneComponent(this.window).setBackground((Color)propertyChangeEvent.getNewValue());
        }
        if (string.equals("substancelaf.skin")) {
            object = (SubstanceSkin)propertyChangeEvent.getOldValue();
            SubstanceSkin substanceSkin = (SubstanceSkin)propertyChangeEvent.getNewValue();
            if (object == null && substanceSkin != null) {
                ++rootPanesWithCustomSkin;
            }
            if (object != null && substanceSkin == null) {
                --rootPanesWithCustomSkin;
            }
        }
    }

    private void propagateModificationState() {
        JComponent jComponent = this.getTitlePane();
        if (jComponent instanceof SubstanceTitlePane) {
            ((SubstanceTitlePane)jComponent).getCloseButton().putClientProperty("windowModified", this.root.getClientProperty("windowModified"));
            return;
        }
        JInternalFrame jInternalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, this.root);
        if (jInternalFrame != null) {
            SubstanceInternalFrameUI substanceInternalFrameUI = (SubstanceInternalFrameUI)jInternalFrame.getUI();
            substanceInternalFrameUI.setWindowModified(Boolean.TRUE.equals(this.root.getClientProperty("windowModified")));
        }
    }

    public static boolean hasCustomSkinOnAtLeastOneRootPane() {
        return rootPanesWithCustomSkin > 0;
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.installUIInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults(JRootPane jRootPane) {
        this.installDefaultsInternal(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installComponents(JRootPane jRootPane) {
        super.installComponents(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void installListeners(JRootPane jRootPane) {
        this.installListenersInternal(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallUIInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults(JRootPane jRootPane) {
        super.uninstallDefaults(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallComponents(JRootPane jRootPane) {
        super.uninstallComponents(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners(JRootPane jRootPane) {
        this.uninstallListenersInternal(jRootPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    private class TitleMouseInputHandler
    extends MouseInputAdapter {
        private Point dragOffset = new Point(0, 0);

        private TitleMouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JRootPane jRootPane = SubstanceRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Component component = (Component)mouseEvent.getSource();
            Point point2 = SwingUtilities.convertPoint(component, point, SubstanceRootPaneUI.this.getTitlePane());
            point = SwingUtilities.convertPoint(component, point, SubstanceRootPaneUI.this.window);
            if (SubstanceRootPaneUI.this.getTitlePane() != null && SubstanceRootPaneUI.this.getTitlePane().contains(point2) && SubstanceRootPaneUI.this.window != null) {
                SubstanceRootPaneUI.this.window.toFront();
                this.dragOffset = point;
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = mouseEvent.getLocationOnScreen();
            if (point == null) {
                point = new Point(mouseEvent.getX() + component.getLocationOnScreen().x, mouseEvent.getY() + component.getLocationOnScreen().y);
            }
            if (SubstanceRootPaneUI.this.window instanceof Frame) {
                int n;
                Frame frame = (Frame)SubstanceRootPaneUI.this.window;
                int n2 = n = frame != null ? frame.getExtendedState() : 0;
                if (frame != null && (n & 6) == 0) {
                    SubstanceRootPaneUI.this.window.setLocation(point.x - this.dragOffset.x, point.y - this.dragOffset.y);
                }
            } else {
                SubstanceRootPaneUI.this.window.setLocation(point.x - this.dragOffset.x, point.y - this.dragOffset.y);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!(SubstanceRootPaneUI.this.window instanceof Frame)) {
                return;
            }
            Frame frame = (Frame)SubstanceRootPaneUI.this.window;
            Point point = SwingUtilities.convertPoint(SubstanceRootPaneUI.this.window, mouseEvent.getPoint(), SubstanceRootPaneUI.this.getTitlePane());
            int n = frame.getExtendedState();
            if (SubstanceRootPaneUI.this.getTitlePane() != null && SubstanceRootPaneUI.this.getTitlePane().contains(point) && mouseEvent.getClickCount() % 2 == 0 && (mouseEvent.getModifiers() & 0x10) != 0 && frame.isResizable()) {
                if ((n & 6) != 0) {
                    SubstanceRootPaneUI.this.setMaximized();
                    frame.setExtendedState(n & 0xFFFFFFF9);
                } else {
                    SubstanceRootPaneUI.this.setMaximized();
                    frame.setExtendedState(n | 6);
                }
            }
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;
        private final PrivilegedExceptionAction getLocationAction = new PrivilegedExceptionAction(){

            public Object run() throws HeadlessException {
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                return pointerInfo == null ? null : pointerInfo.getLocation();
            }
        };
        private CursorState cursorState = CursorState.NIL;

        private MouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            JRootPane jRootPane = SubstanceRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point point = mouseEvent.getPoint();
            Window window = (Window)mouseEvent.getSource();
            if (window != null) {
                window.toFront();
            }
            Point point2 = SwingUtilities.convertPoint(window, point, SubstanceRootPaneUI.this.getTitlePane());
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n2 = n = frame != null ? frame.getExtendedState() : 0;
            if (SubstanceRootPaneUI.this.getTitlePane() != null && SubstanceRootPaneUI.this.getTitlePane().contains(point2)) {
                if ((frame != null && (n & 6) == 0 || dialog != null) && point.y >= 5 && point.x >= 5 && point.x < window.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = point.x;
                    this.dragOffsetY = point.y;
                }
            } else if (frame != null && frame.isResizable() && (n & 6) == 0 || dialog != null && dialog.isResizable()) {
                this.dragOffsetX = point.x;
                this.dragOffsetY = point.y;
                this.dragWidth = window.getWidth();
                this.dragHeight = window.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(window, point.x, point.y));
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.dragCursor != 0 && SubstanceRootPaneUI.this.window != null && !SubstanceRootPaneUI.this.window.isValid()) {
                SubstanceRootPaneUI.this.window.validate();
                SubstanceRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JRootPane jRootPane = SubstanceRootPaneUI.this.getRootPane();
            if (jRootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Window window = (Window)mouseEvent.getSource();
            Frame frame = null;
            Dialog dialog = null;
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
            int n = this.getCursor(this.calculateCorner(window, mouseEvent.getX(), mouseEvent.getY()));
            if (n != 0 && (frame != null && frame.isResizable() && (frame.getExtendedState() & 6) == 0 || dialog != null && dialog.isResizable())) {
                window.setCursor(Cursor.getPredefinedCursor(n));
            } else {
                window.setCursor(SubstanceRootPaneUI.this.lastCursor);
            }
        }

        private void adjust(Rectangle rectangle, Dimension dimension, int n, int n2, int n3, int n4) {
            rectangle.x += n;
            rectangle.y += n2;
            rectangle.width += n3;
            rectangle.height += n4;
            if (dimension != null) {
                int n5;
                if (rectangle.width < dimension.width) {
                    n5 = dimension.width - rectangle.width;
                    if (n != 0) {
                        rectangle.x -= n5;
                    }
                    rectangle.width = dimension.width;
                }
                if (rectangle.height < dimension.height) {
                    n5 = dimension.height - rectangle.height;
                    if (n2 != 0) {
                        rectangle.y -= n5;
                    }
                    rectangle.height = dimension.height;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            if (this.isMovingWindow) {
                try {
                    Point point2 = (Point)AccessController.doPrivileged(this.getLocationAction);
                    if (point2 != null) {
                        point2.x -= this.dragOffsetX;
                        point2.y -= this.dragOffsetY;
                        window.setLocation(point2);
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {}
            } else if (this.dragCursor != 0) {
                Rectangle rectangle = window.getBounds();
                Rectangle rectangle2 = new Rectangle(rectangle);
                Dimension dimension = window.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(rectangle, dimension, 0, 0, 0, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 8: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, 0, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(rectangle, dimension, 0, point.y - this.dragOffsetY, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(rectangle, dimension, 0, 0, point.x + (this.dragWidth - this.dragOffsetX) - rectangle.width, point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                    case 6: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, point.y - this.dragOffsetY, -(point.x - this.dragOffsetX), -(point.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(rectangle, dimension, point.x - this.dragOffsetX, 0, -(point.x - this.dragOffsetX), point.y + (this.dragHeight - this.dragOffsetY) - rectangle.height);
                        break;
                    }
                }
                if (!rectangle.equals(rectangle2)) {
                    window.setBounds(rectangle);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        window.validate();
                        SubstanceRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            if (this.cursorState == CursorState.EXITED || this.cursorState == CursorState.NIL) {
                SubstanceRootPaneUI.this.lastCursor = window.getCursor();
            }
            this.cursorState = CursorState.ENTERED;
            this.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            window.setCursor(SubstanceRootPaneUI.this.lastCursor);
            this.cursorState = CursorState.EXITED;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Window window = (Window)mouseEvent.getSource();
            if (!(window instanceof Frame)) {
                return;
            }
            Frame frame = (Frame)window;
            JComponent jComponent = SubstanceRootPaneUI.this.getTitlePane();
            if (jComponent == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint(window, mouseEvent.getPoint(), jComponent);
            int n = frame.getExtendedState();
            if (jComponent != null && jComponent.contains(point) && mouseEvent.getClickCount() % 2 == 0 && (mouseEvent.getModifiers() & 0x10) != 0 && frame.isResizable()) {
                if ((n & 6) != 0) {
                    SubstanceRootPaneUI.this.setMaximized();
                    frame.setExtendedState(n & 0xFFFFFFF9);
                } else {
                    SubstanceRootPaneUI.this.setMaximized();
                    frame.setExtendedState(n | 6);
                }
            }
        }

        private int calculateCorner(Window window, int n, int n2) {
            Insets insets = window.getInsets();
            int n3 = this.calculatePosition(n - insets.left, window.getWidth() - insets.left - insets.right);
            int n4 = this.calculatePosition(n2 - insets.top, window.getHeight() - insets.top - insets.bottom);
            if (n3 == -1 || n4 == -1) {
                return -1;
            }
            return n4 * 5 + n3;
        }

        private int getCursor(int n) {
            if (n == -1) {
                return 0;
            }
            return cursorMapping[n];
        }

        private int calculatePosition(int n, int n2) {
            if (n < 5) {
                return 0;
            }
            if (n < 16) {
                return 1;
            }
            if (n >= n2 - 5) {
                return 4;
            }
            if (n >= n2 - 16) {
                return 3;
            }
            return 2;
        }
    }

    protected class SubstanceRootLayout
    implements LayoutManager2 {
        protected SubstanceRootLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getPreferredSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getPreferredSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof SubstanceRootPaneUI && (jComponent = ((SubstanceRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getPreferredSize()) != null) {
                n5 = dimension.width;
                n6 = dimension.height;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n6 + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            Dimension dimension3 = jRootPane.getContentPane() != null ? jRootPane.getContentPane().getMinimumSize() : jRootPane.getSize();
            if (dimension3 != null) {
                n = dimension3.width;
                n2 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getMinimumSize()) != null) {
                n3 = dimension2.width;
                n4 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof SubstanceRootPaneUI && (jComponent = ((SubstanceRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMinimumSize()) != null) {
                n5 = dimension.width;
                n6 = dimension.height;
            }
            return new Dimension(Math.max(Math.max(n, n3), n5) + insets.left + insets.right, n2 + n4 + n6 + insets.top + insets.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            int n;
            int n2;
            Dimension dimension;
            JComponent jComponent;
            Dimension dimension2;
            Dimension dimension3;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MAX_VALUE;
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MAX_VALUE;
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MAX_VALUE;
            Insets insets = container.getInsets();
            JRootPane jRootPane = (JRootPane)container;
            if (jRootPane.getContentPane() != null && (dimension3 = jRootPane.getContentPane().getMaximumSize()) != null) {
                n3 = dimension3.width;
                n4 = dimension3.height;
            }
            if (jRootPane.getJMenuBar() != null && (dimension2 = jRootPane.getJMenuBar().getMaximumSize()) != null) {
                n5 = dimension2.width;
                n6 = dimension2.height;
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof SubstanceRootPaneUI && (jComponent = ((SubstanceRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = jComponent.getMaximumSize()) != null) {
                n7 = dimension.width;
                n8 = dimension.height;
            }
            if ((n2 = Math.max(Math.max(n4, n6), n8)) != Integer.MAX_VALUE) {
                n2 = n4 + n6 + n8 + insets.top + insets.bottom;
            }
            if ((n = Math.max(Math.max(n3, n5), n7)) != Integer.MAX_VALUE) {
                n += insets.left + insets.right;
            }
            return new Dimension(n, n2);
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension dimension;
            Serializable serializable;
            JRootPane jRootPane = (JRootPane)container;
            Rectangle rectangle = jRootPane.getBounds();
            Insets insets = jRootPane.getInsets();
            int n = 0;
            int n2 = rectangle.width - insets.right - insets.left;
            int n3 = rectangle.height - insets.top - insets.bottom;
            if (jRootPane.getLayeredPane() != null) {
                jRootPane.getLayeredPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getGlassPane() != null) {
                jRootPane.getGlassPane().setBounds(insets.left, insets.top, n2, n3);
            }
            if (jRootPane.getWindowDecorationStyle() != 0 && jRootPane.getUI() instanceof SubstanceRootPaneUI && (serializable = ((SubstanceRootPaneUI)jRootPane.getUI()).getTitlePane()) != null && (dimension = ((JComponent)serializable).getPreferredSize()) != null) {
                int n4 = dimension.height;
                ((Component)serializable).setBounds(0, 0, n2, n4);
                n += n4;
            }
            if (jRootPane.getJMenuBar() != null) {
                serializable = jRootPane.getJMenuBar().getPreferredSize();
                jRootPane.getJMenuBar().setBounds(0, n, n2, ((Dimension)serializable).height);
                n += ((Dimension)serializable).height;
            }
            if (jRootPane.getContentPane() != null) {
                jRootPane.getContentPane().setBounds(0, n, n2, n3 < n ? 0 : n3 - n);
            }
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container container) {
        }
    }

    private static enum CursorState {
        EXITED,
        ENTERED,
        NIL;

    }
}

