/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeelEx;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.MatteFillPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.ArrowButtonTransitionAwareIcon;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollButton;

public class SubstanceScrollBarUI
extends BasicScrollBarUI
implements TransitionAwareUI {
    protected JButton mySecondDecreaseButton;
    protected JButton mySecondIncreaseButton;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private static LazyResettableHashMap<BufferedImage> thumbVerticalMap = new LazyResettableHashMap("SubstanceScrollBarUI.thumbVertical");
    private static LazyResettableHashMap<BufferedImage> thumbHorizontalMap = new LazyResettableHashMap("SubstanceScrollBarUI.thumbHorizontal");
    private MouseListener substanceMouseListener;
    private RolloverControlListener substanceThumbRolloverListener;
    protected StateTransitionTracker compositeStateTransitionTracker;
    private PropertyChangeListener substancePropertyListener;
    protected int scrollBarWidth;
    private static LazyResettableHashMap<BufferedImage> trackHorizontalMap = new LazyResettableHashMap("SubstanceScrollBarUI.trackHorizontal");
    private static LazyResettableHashMap<BufferedImage> trackVerticalMap = new LazyResettableHashMap("SubstanceScrollBarUI.trackVertical");
    protected AdjustmentListener substanceAdjustmentListener;
    protected CompositeButtonModel compositeScrollTrackModel;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceScrollBarUI(jComponent);
    }

    protected SubstanceScrollBarUI(JComponent jComponent) {
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        jComponent.setOpaque(false);
    }

    protected JButton createGeneralDecreaseButton(int n, boolean bl) {
        SubstanceScrollButton substanceScrollButton = new SubstanceScrollButton(n);
        substanceScrollButton.setName("Decrease " + (bl ? "regular" : "additional"));
        substanceScrollButton.setFont(this.scrollbar.getFont());
        ArrowButtonTransitionAwareIcon arrowButtonTransitionAwareIcon = new ArrowButtonTransitionAwareIcon(substanceScrollButton, n);
        substanceScrollButton.setIcon(arrowButtonTransitionAwareIcon);
        substanceScrollButton.setFont(this.scrollbar.getFont());
        substanceScrollButton.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        EnumSet<SubstanceConstants.Side> enumSet = EnumSet.noneOf(SubstanceConstants.Side.class);
        EnumSet<SubstanceConstants.Side> enumSet2 = EnumSet.noneOf(SubstanceConstants.Side.class);
        switch (n) {
            case 1: {
                enumSet.add(SubstanceConstants.Side.BOTTOM);
                if (!bl) {
                    enumSet.add(SubstanceConstants.Side.TOP);
                }
                if (!bl) break;
                enumSet2.add(SubstanceConstants.Side.TOP);
                break;
            }
            case 3: {
                enumSet.add(SubstanceConstants.Side.LEFT);
                if (!bl) {
                    enumSet.add(SubstanceConstants.Side.RIGHT);
                }
                if (!bl) break;
                enumSet2.add(SubstanceConstants.Side.RIGHT);
                break;
            }
            case 7: {
                enumSet.add(SubstanceConstants.Side.RIGHT);
                if (!bl) {
                    enumSet.add(SubstanceConstants.Side.LEFT);
                }
                if (!bl) break;
                enumSet2.add(SubstanceConstants.Side.LEFT);
            }
        }
        substanceScrollButton.putClientProperty("substancelaf.buttonopenSide", enumSet);
        substanceScrollButton.putClientProperty("substancelaf.buttonside", enumSet2);
        return substanceScrollButton;
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        return this.createGeneralDecreaseButton(n, true);
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        return this.createGeneralIncreaseButton(n, true);
    }

    protected JButton createGeneralIncreaseButton(int n, boolean bl) {
        SubstanceScrollButton substanceScrollButton = new SubstanceScrollButton(n);
        substanceScrollButton.setName("Increase " + (bl ? "regular" : "additional"));
        substanceScrollButton.setFont(this.scrollbar.getFont());
        ArrowButtonTransitionAwareIcon arrowButtonTransitionAwareIcon = new ArrowButtonTransitionAwareIcon(substanceScrollButton, n);
        substanceScrollButton.setIcon(arrowButtonTransitionAwareIcon);
        substanceScrollButton.setFont(this.scrollbar.getFont());
        substanceScrollButton.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        EnumSet<SubstanceConstants.Side> enumSet = EnumSet.noneOf(SubstanceConstants.Side.class);
        EnumSet<SubstanceConstants.Side> enumSet2 = EnumSet.noneOf(SubstanceConstants.Side.class);
        switch (n) {
            case 5: {
                enumSet.add(SubstanceConstants.Side.TOP);
                if (!bl) {
                    enumSet.add(SubstanceConstants.Side.BOTTOM);
                }
                if (!bl) break;
                enumSet2.add(SubstanceConstants.Side.BOTTOM);
                break;
            }
            case 3: {
                enumSet.add(SubstanceConstants.Side.LEFT);
                if (!bl) {
                    enumSet.add(SubstanceConstants.Side.RIGHT);
                }
                if (!bl) break;
                enumSet2.add(SubstanceConstants.Side.RIGHT);
                break;
            }
            case 7: {
                enumSet.add(SubstanceConstants.Side.RIGHT);
                if (!bl) {
                    enumSet.add(SubstanceConstants.Side.LEFT);
                }
                if (!bl) break;
                enumSet2.add(SubstanceConstants.Side.LEFT);
            }
        }
        substanceScrollButton.putClientProperty("substancelaf.buttonopenSide", enumSet);
        substanceScrollButton.putClientProperty("substancelaf.buttonside", enumSet2);
        return substanceScrollButton;
    }

    private void paintTrackHorizontal(Graphics graphics, Rectangle rectangle, SubstanceScrollButton substanceScrollButton, SubstanceScrollButton substanceScrollButton2) {
        int n = Math.max(1, rectangle.width);
        int n2 = Math.max(1, rectangle.height);
        BufferedImage bufferedImage = SubstanceScrollBarUI.getTrackHorizontal(this.scrollbar, n, n2);
        graphics.drawImage(bufferedImage, 0, 0, null);
    }

    private static BufferedImage getTrackHorizontal(JScrollBar jScrollBar, int n, int n2) {
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(jScrollBar);
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jScrollBar, jScrollBar.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jScrollBar, ColorSchemeAssociationKind.BORDER, jScrollBar.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), n, n2, substanceButtonShaper.getDisplayName());
        float f = 0.0f;
        int n3 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jScrollBar)) / 2.0);
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n, n2, f, null, n3);
        BufferedImage bufferedImage = trackHorizontalMap.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
            SubstanceLookAndFeelEx.SIMPLE_FILL_PAINTER.paintContourBackground(bufferedImage.createGraphics(), jScrollBar, n, n2, generalPath, false, substanceColorScheme, true);
            SubstanceLookAndFeelEx.SIMPLE_BORDER_PAINTER.paintBorder(bufferedImage.getGraphics(), jScrollBar, n, n2, generalPath, null, substanceColorScheme2);
            trackHorizontalMap.put(hashMapKey, bufferedImage);
        }
        return bufferedImage;
    }

    private static void paintTrackBackHorizontal(Graphics graphics, JScrollBar jScrollBar, AbstractButton abstractButton, AbstractButton abstractButton2, int n, int n2) {
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(jScrollBar);
        int n3 = n2 / 2;
        if (substanceButtonShaper instanceof ClassicButtonShaper) {
            n3 = 2;
        }
        SubstanceImageCreator.paintCompositeRoundedBackground(jScrollBar, graphics, n, n2, n3, abstractButton, abstractButton2, false);
    }

    private void paintTrackVertical(Graphics graphics, Rectangle rectangle, SubstanceScrollButton substanceScrollButton, SubstanceScrollButton substanceScrollButton2) {
        int n = Math.max(1, rectangle.width);
        int n2 = Math.max(1, rectangle.height);
        BufferedImage bufferedImage = SubstanceScrollBarUI.getTrackVertical(this.scrollbar, n, n2);
        graphics.drawImage(bufferedImage, 0, 0, null);
    }

    private static BufferedImage getTrackVertical(JScrollBar jScrollBar, int n, int n2) {
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(jScrollBar);
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jScrollBar, jScrollBar.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(jScrollBar, ColorSchemeAssociationKind.BORDER, jScrollBar.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), n, n2, substanceButtonShaper.getDisplayName());
        BufferedImage bufferedImage = trackVerticalMap.get(hashMapKey);
        if (bufferedImage == null) {
            float f = 0.0f;
            int n3 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jScrollBar)) / 2.0);
            GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n2, n, f, null, n3);
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n2, n);
            SubstanceLookAndFeelEx.SIMPLE_FILL_PAINTER.paintContourBackground(bufferedImage.createGraphics(), jScrollBar, n2, n, generalPath, false, substanceColorScheme, true);
            SubstanceLookAndFeelEx.SIMPLE_BORDER_PAINTER.paintBorder(bufferedImage.getGraphics(), jScrollBar, n, n2, generalPath, null, substanceColorScheme2);
            bufferedImage = SubstanceImageCreator.getRotated(bufferedImage, 3);
            trackVerticalMap.put(hashMapKey, bufferedImage);
        }
        return bufferedImage;
    }

    private static void paintTrackBackVertical(Graphics graphics, JScrollBar jScrollBar, AbstractButton abstractButton, AbstractButton abstractButton2, int n, int n2) {
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(jScrollBar);
        int n3 = n / 2;
        if (substanceButtonShaper instanceof ClassicButtonShaper) {
            n3 = 2;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(0.0, n2);
        affineTransform.rotate(-1.5707963267948966);
        graphics2D.transform(affineTransform);
        SubstanceImageCreator.paintCompositeRoundedBackground(jScrollBar, graphics2D, n2, n, n3, abstractButton, abstractButton2, true);
        graphics2D.dispose();
    }

    private BufferedImage getThumbVertical(Rectangle rectangle) {
        int n = Math.max(1, rectangle.width);
        int n2 = Math.max(1, rectangle.height);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.compositeStateTransitionTracker.getModelStateInfo();
        ComponentState componentState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, componentState);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, componentState);
        BufferedImage bufferedImage = SubstanceScrollBarUI.getThumbVertical(this.scrollbar, n, n2, substanceColorScheme, substanceColorScheme2);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        if (componentState.isDisabled() || map.size() == 1) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = SubstanceCoreUtilities.getBlankImage(bufferedImage.getWidth(), bufferedImage.getHeight());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            float f;
            ComponentState componentState2 = entry.getKey();
            if (componentState2 == modelStateInfo.getCurrModelState() || (f = entry.getValue().getContribution()) == 0.0f) continue;
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f));
            SubstanceColorScheme substanceColorScheme3 = componentState2 != ComponentState.ENABLED ? SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, componentState2) : SubstanceColorSchemeUtilities.getActiveColorScheme(this.scrollbar, componentState2);
            SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, componentState2);
            BufferedImage bufferedImage3 = SubstanceScrollBarUI.getThumbVertical(this.scrollbar, n, n2, substanceColorScheme3, substanceColorScheme4);
            graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static BufferedImage getThumbVertical(JScrollBar jScrollBar, int n, int n2, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        MatteFillPainter matteFillPainter = MatteFillPainter.INSTANCE;
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(jScrollBar);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jScrollBar);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), matteFillPainter.getDisplayName(), substanceButtonShaper.getDisplayName(), substanceBorderPainter.getDisplayName());
        BufferedImage bufferedImage = thumbVerticalMap.get(hashMapKey);
        if (bufferedImage == null) {
            float f = n / 2;
            if (substanceButtonShaper instanceof ClassicButtonShaper) {
                f = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(jScrollBar));
            }
            int n3 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jScrollBar)) / 2.0);
            GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n2, n, f, null, n3);
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n2, n);
            matteFillPainter.paintContourBackground(bufferedImage.createGraphics(), jScrollBar, n2, n, generalPath, false, substanceColorScheme, true);
            substanceBorderPainter.paintBorder(bufferedImage.getGraphics(), jScrollBar, n2, n, generalPath, null, substanceColorScheme2);
            bufferedImage = SubstanceImageCreator.getRotated(bufferedImage, 3);
            thumbVerticalMap.put(hashMapKey, bufferedImage);
        }
        return bufferedImage;
    }

    private BufferedImage getThumbHorizontal(Rectangle rectangle) {
        int n = Math.max(1, rectangle.width);
        int n2 = Math.max(1, rectangle.height);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.compositeStateTransitionTracker.getModelStateInfo();
        ComponentState componentState = modelStateInfo.getCurrModelState();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, componentState);
        SubstanceColorScheme substanceColorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, componentState);
        BufferedImage bufferedImage = SubstanceScrollBarUI.getThumbHorizontal(this.scrollbar, n, n2, substanceColorScheme, substanceColorScheme2);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> map = modelStateInfo.getStateContributionMap();
        if (componentState.isDisabled() || map.size() == 1) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = SubstanceCoreUtilities.getBlankImage(bufferedImage.getWidth(), bufferedImage.getHeight());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> entry : map.entrySet()) {
            float f;
            ComponentState componentState2 = entry.getKey();
            if (componentState2 == modelStateInfo.getCurrModelState() || (f = entry.getValue().getContribution()) == 0.0f) continue;
            graphics2D.setComposite(AlphaComposite.SrcOver.derive(f));
            SubstanceColorScheme substanceColorScheme3 = componentState2 != ComponentState.ENABLED ? SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, componentState2) : SubstanceColorSchemeUtilities.getActiveColorScheme(this.scrollbar, componentState2);
            SubstanceColorScheme substanceColorScheme4 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, componentState2);
            BufferedImage bufferedImage3 = SubstanceScrollBarUI.getThumbHorizontal(this.scrollbar, n, n2, substanceColorScheme3, substanceColorScheme4);
            graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    private static BufferedImage getThumbHorizontal(JScrollBar jScrollBar, int n, int n2, SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2) {
        MatteFillPainter matteFillPainter = MatteFillPainter.INSTANCE;
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(jScrollBar);
        SubstanceBorderPainter substanceBorderPainter = SubstanceCoreUtilities.getBorderPainter(jScrollBar);
        HashMapKey hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, substanceColorScheme.getDisplayName(), substanceColorScheme2.getDisplayName(), matteFillPainter.getDisplayName(), substanceButtonShaper.getDisplayName(), substanceBorderPainter.getDisplayName());
        float f = n2 / 2;
        if (substanceButtonShaper instanceof ClassicButtonShaper) {
            f = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(jScrollBar));
        }
        int n3 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jScrollBar)) / 2.0);
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(n, n2, f, null, n3);
        BufferedImage bufferedImage = thumbHorizontalMap.get(hashMapKey);
        if (bufferedImage == null) {
            bufferedImage = SubstanceCoreUtilities.getBlankImage(n, n2);
            matteFillPainter.paintContourBackground(bufferedImage.createGraphics(), jScrollBar, n, n2, generalPath, false, substanceColorScheme, true);
            substanceBorderPainter.paintBorder(bufferedImage.getGraphics(), jScrollBar, n, n2, generalPath, null, substanceColorScheme2);
            thumbHorizontalMap.put(hashMapKey, bufferedImage);
        }
        return bufferedImage;
    }

    protected ComponentState getState(JButton jButton) {
        if (jButton == null) {
            return null;
        }
        ComponentState componentState = ((TransitionAwareUI)((Object)jButton.getUI())).getTransitionTracker().getModelStateInfo().getCurrModelState();
        if (componentState == ComponentState.ENABLED && SubstanceCoreUtilities.hasFlatAppearance(this.scrollbar, false)) {
            componentState = null;
        }
        if (SubstanceCoreUtilities.isButtonNeverPainted(jButton)) {
            componentState = null;
        }
        return componentState;
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        SubstanceConstants.ScrollPaneButtonPolicyKind scrollPaneButtonPolicyKind = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(this.scrollbar);
        SubstanceScrollButton substanceScrollButton = null;
        SubstanceScrollButton substanceScrollButton2 = null;
        if (this.decrButton.isShowing() && this.incrButton.isShowing() && this.mySecondDecreaseButton.isShowing() && this.mySecondIncreaseButton.isShowing()) {
            switch (scrollPaneButtonPolicyKind) {
                case OPPOSITE: {
                    substanceScrollButton = (SubstanceScrollButton)this.decrButton;
                    substanceScrollButton2 = (SubstanceScrollButton)this.incrButton;
                    break;
                }
                case ADJACENT: {
                    substanceScrollButton2 = (SubstanceScrollButton)this.mySecondDecreaseButton;
                    break;
                }
                case MULTIPLE: {
                    substanceScrollButton = (SubstanceScrollButton)this.decrButton;
                    substanceScrollButton2 = (SubstanceScrollButton)this.mySecondDecreaseButton;
                    break;
                }
                case MULTIPLE_BOTH: {
                    substanceScrollButton = (SubstanceScrollButton)this.mySecondIncreaseButton;
                    substanceScrollButton2 = (SubstanceScrollButton)this.mySecondDecreaseButton;
                    break;
                }
            }
        }
        graphics2D.translate(rectangle.x, rectangle.y);
        if (this.scrollbar.getOrientation() == 1) {
            this.paintTrackVertical(graphics2D, rectangle, substanceScrollButton, substanceScrollButton2);
        } else if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
            this.paintTrackHorizontal(graphics2D, rectangle, substanceScrollButton, substanceScrollButton2);
        } else {
            this.paintTrackHorizontal(graphics2D, rectangle, substanceScrollButton2, substanceScrollButton);
        }
        graphics2D.dispose();
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.thumbModel.setSelected(this.thumbModel.isSelected() || this.isDragging);
        this.thumbModel.setEnabled(jComponent.isEnabled());
        boolean bl2 = bl = this.scrollbar.getOrientation() == 1;
        if (bl) {
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            BufferedImage bufferedImage = this.getThumbVertical(rectangle2);
            graphics2D.drawImage((Image)bufferedImage, rectangle2.x, rectangle2.y, null);
        } else {
            Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            BufferedImage bufferedImage = this.getThumbHorizontal(rectangle3);
            graphics2D.drawImage((Image)bufferedImage, rectangle3.x, rectangle3.y, null);
        }
        graphics2D.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        BackgroundPaintingUtils.update(graphics2D, jComponent, false);
        float f = SubstanceColorSchemeUtilities.getAlpha(this.scrollbar, ComponentState.getState(this.thumbModel, this.scrollbar));
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jComponent, (float)f, (Graphics)graphics));
        super.paint(graphics2D, jComponent);
        graphics2D.dispose();
    }

    private void updateScrollBarWidth() {
        this.scrollBarWidth = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.scrollbar));
    }

    private void installDefaultsInternal() {
        super.installDefaults();
        this.updateScrollBarWidth();
    }

    private void installComponentsInternal() {
        super.installComponents();
        this.scrollbar.putClientProperty("substancelaf.colorizationFactor", 0.0);
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                this.mySecondDecreaseButton = this.createGeneralDecreaseButton(1, false);
                this.mySecondIncreaseButton = this.createGeneralIncreaseButton(5, false);
                break;
            }
            case 0: {
                if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    this.mySecondDecreaseButton = this.createGeneralDecreaseButton(7, false);
                    this.mySecondIncreaseButton = this.createGeneralIncreaseButton(3, false);
                    break;
                }
                this.mySecondDecreaseButton = this.createGeneralDecreaseButton(3, false);
                this.mySecondIncreaseButton = this.createGeneralIncreaseButton(7, false);
            }
        }
        this.scrollbar.add(this.mySecondDecreaseButton);
        this.scrollbar.add(this.mySecondIncreaseButton);
        this.compositeScrollTrackModel = new CompositeButtonModel(this.thumbModel, this.incrButton, this.decrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
        this.compositeScrollTrackModel.registerListeners();
        this.compositeStateTransitionTracker = new StateTransitionTracker(this.scrollbar, this.compositeScrollTrackModel);
        this.compositeStateTransitionTracker.registerModelListeners();
    }

    private void uninstallComponentsInternal() {
        this.compositeScrollTrackModel.unregisterListeners();
        this.compositeStateTransitionTracker.unregisterModelListeners();
        this.scrollbar.remove(this.mySecondDecreaseButton);
        this.scrollbar.remove(this.mySecondIncreaseButton);
        super.uninstallComponents();
    }

    private void installListenersInternal() {
        super.installListeners();
        this.substanceMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }
        };
        this.incrButton.addMouseListener(this.substanceMouseListener);
        this.decrButton.addMouseListener(this.substanceMouseListener);
        this.mySecondDecreaseButton.addMouseListener(this.substanceMouseListener);
        this.mySecondIncreaseButton.addMouseListener(this.substanceMouseListener);
        this.substanceThumbRolloverListener = new RolloverControlListener(this, this.thumbModel);
        this.scrollbar.addMouseListener(this.substanceThumbRolloverListener);
        this.scrollbar.addMouseMotionListener(this.substanceThumbRolloverListener);
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Color color;
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceScrollBarUI.this.updateScrollBarWidth();
                }
                if ("background".equals(propertyChangeEvent.getPropertyName()) && !((color = (Color)propertyChangeEvent.getNewValue()) instanceof UIResource)) {
                    if (SubstanceScrollBarUI.this.mySecondDecreaseButton != null && SubstanceScrollBarUI.this.mySecondDecreaseButton.getBackground() instanceof UIResource) {
                        SubstanceScrollBarUI.this.mySecondDecreaseButton.setBackground(color);
                    }
                    if (SubstanceScrollBarUI.this.mySecondIncreaseButton != null && SubstanceScrollBarUI.this.mySecondIncreaseButton.getBackground() instanceof UIResource) {
                        SubstanceScrollBarUI.this.mySecondIncreaseButton.setBackground(color);
                    }
                    if (SubstanceScrollBarUI.this.incrButton != null && SubstanceScrollBarUI.this.incrButton.getBackground() instanceof UIResource) {
                        SubstanceScrollBarUI.this.incrButton.setBackground(color);
                    }
                    if (SubstanceScrollBarUI.this.decrButton != null && SubstanceScrollBarUI.this.decrButton.getBackground() instanceof UIResource) {
                        SubstanceScrollBarUI.this.decrButton.setBackground(color);
                    }
                }
            }
        };
        this.scrollbar.addPropertyChangeListener(this.substancePropertyListener);
        this.mySecondDecreaseButton.addMouseListener(this.buttonListener);
        this.mySecondIncreaseButton.addMouseListener(this.buttonListener);
        this.substanceAdjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                SubstanceCoreUtilities.testComponentStateChangeThreadingViolation(SubstanceScrollBarUI.this.scrollbar);
                Container container = SubstanceScrollBarUI.this.scrollbar.getParent();
                if (container instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)container;
                    JScrollBar jScrollBar = jScrollPane.getHorizontalScrollBar();
                    JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
                    JScrollBar jScrollBar3 = null;
                    if (SubstanceScrollBarUI.this.scrollbar == jScrollBar) {
                        jScrollBar3 = jScrollBar2;
                    }
                    if (SubstanceScrollBarUI.this.scrollbar == jScrollBar2) {
                        jScrollBar3 = jScrollBar;
                    }
                    if (jScrollBar3 != null && jScrollBar3.isVisible()) {
                        jScrollBar3.repaint();
                    }
                    SubstanceScrollBarUI.this.scrollbar.repaint();
                }
            }
        };
        this.scrollbar.addAdjustmentListener(this.substanceAdjustmentListener);
    }

    private void uninstallListenersInternal() {
        this.incrButton.removeMouseListener(this.substanceMouseListener);
        this.decrButton.removeMouseListener(this.substanceMouseListener);
        this.mySecondDecreaseButton.removeMouseListener(this.substanceMouseListener);
        this.mySecondIncreaseButton.removeMouseListener(this.substanceMouseListener);
        this.substanceMouseListener = null;
        this.scrollbar.removeMouseListener(this.substanceThumbRolloverListener);
        this.scrollbar.removeMouseMotionListener(this.substanceThumbRolloverListener);
        this.substanceThumbRolloverListener = null;
        this.scrollbar.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.mySecondDecreaseButton.removeMouseListener(this.buttonListener);
        this.mySecondIncreaseButton.removeMouseListener(this.buttonListener);
        this.scrollbar.removeAdjustmentListener(this.substanceAdjustmentListener);
        this.substanceAdjustmentListener = null;
        super.uninstallListeners();
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        Rectangle rectangle = this.getTrackBounds();
        if (rectangle == null) {
            return false;
        }
        return rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.compositeStateTransitionTracker;
    }

    @Override
    public void scrollByBlock(int n) {
        int n2 = this.scrollbar.getValue();
        int n3 = this.scrollbar.getBlockIncrement(n);
        int n4 = n3 * (n > 0 ? 1 : -1);
        int n5 = n2 + n4;
        if (n4 > 0 && n5 < n2) {
            n5 = this.scrollbar.getMaximum();
        } else if (n4 < 0 && n5 > n2) {
            n5 = this.scrollbar.getMinimum();
        }
        this.scrollbar.setValue(n5);
    }

    public void scrollByUnits(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = n > 0 ? this.scrollbar.getUnitIncrement(n) : -this.scrollbar.getUnitIncrement(n);
            int n4 = this.scrollbar.getValue();
            int n5 = n4 + n3;
            if (n3 > 0 && n5 < n4) {
                n5 = this.scrollbar.getMaximum();
            } else if (n3 < 0 && n5 > n4) {
                n5 = this.scrollbar.getMinimum();
            }
            if (n4 == n5) break;
            this.scrollbar.setValue(n5);
        }
    }

    @Override
    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        SubstanceConstants.ScrollPaneButtonPolicyKind scrollPaneButtonPolicyKind = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(this.scrollbar);
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        switch (scrollPaneButtonPolicyKind) {
            case OPPOSITE: {
                super.layoutVScrollbar(jScrollBar);
                break;
            }
            case NONE: {
                this.layoutVScrollbarNone(jScrollBar);
                break;
            }
            case ADJACENT: {
                this.layoutVScrollbarAdjacent(jScrollBar);
                break;
            }
            case MULTIPLE: {
                this.layoutVScrollbarMultiple(jScrollBar);
                break;
            }
            case MULTIPLE_BOTH: {
                this.layoutVScrollbarMultipleBoth(jScrollBar);
            }
        }
    }

    @Override
    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        SubstanceConstants.ScrollPaneButtonPolicyKind scrollPaneButtonPolicyKind = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(this.scrollbar);
        switch (scrollPaneButtonPolicyKind) {
            case OPPOSITE: {
                super.layoutHScrollbar(jScrollBar);
                break;
            }
            case NONE: {
                this.layoutHScrollbarNone(jScrollBar);
                break;
            }
            case ADJACENT: {
                this.layoutHScrollbarAdjacent(jScrollBar);
                break;
            }
            case MULTIPLE: {
                this.layoutHScrollbarMultiple(jScrollBar);
                break;
            }
            case MULTIPLE_BOTH: {
                this.layoutHScrollbarMultipleBoth(jScrollBar);
            }
        }
    }

    protected void layoutVScrollbarAdjacent(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = insets.left;
        int n4 = n2;
        int n5 = dimension.height - (insets.bottom + n4);
        int n6 = n2;
        int n7 = n5 - n6;
        int n8 = insets.top + insets.bottom;
        int n9 = n6 + n4;
        float f = dimension.height - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n10 = f4 <= 0.0f ? this.getMaximumThumbSize().height : (int)(f * (f3 / f4));
        n10 = Math.max(n10, this.getMinimumThumbSize().height);
        n10 = Math.min(n10, this.getMaximumThumbSize().height);
        int n11 = n7 - n10;
        if (f5 < (float)(jScrollBar.getMaximum() - jScrollBar.getVisibleAmount())) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
        }
        if ((n = dimension.height - n8) < n9) {
            n4 = n6 = n / 2;
            n5 = dimension.height - (insets.bottom + n4);
        }
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondDecreaseButton.setBounds(n3, n5 - n6, n2, n6);
        this.incrButton.setBounds(n3, n5 - 1, n2, n4 + 1);
        int n12 = 0;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n3, n12, n2, n13);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n11 + n10 > n7) {
                n11 = n7 - n10;
            }
            if (n11 < 0) {
                n11 = 0;
            }
            this.setThumbBounds(n3, n11, n2, n10);
        }
    }

    protected void layoutVScrollbarNone(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = insets.left;
        int n4 = 0;
        int n5 = dimension.height - (insets.bottom + n4);
        int n6 = 0;
        int n7 = n5 - n6;
        int n8 = insets.top + insets.bottom;
        int n9 = n6 + n4;
        float f = dimension.height - (n8 + n9);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n10 = f4 <= 0.0f ? this.getMaximumThumbSize().height : (int)(f * (f3 / f4));
        n10 = Math.max(n10, this.getMinimumThumbSize().height);
        n10 = Math.min(n10, this.getMaximumThumbSize().height);
        int n11 = n7 - n10;
        if (f5 < (float)(jScrollBar.getMaximum() - jScrollBar.getVisibleAmount())) {
            float f6 = f - (float)n10;
            n11 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
        }
        if ((n = dimension.height - n8) < n9) {
            n4 = 0;
        }
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        this.incrButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        int n12 = 0;
        int n13 = n7 - n12;
        this.trackRect.setBounds(n3, n12, n2, n13);
        if (n10 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n11 + n10 > n7) {
                n11 = n7 - n10;
            }
            if (n11 < 0) {
                n11 = 0;
            }
            this.setThumbBounds(n3, n11, n2, n10);
        }
    }

    protected void layoutVScrollbarMultiple(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = insets.left;
        int n4 = n2;
        int n5 = dimension.height - (insets.bottom + n4);
        int n6 = n2;
        int n7 = n5 - n6;
        int n8 = n2;
        int n9 = insets.top;
        int n10 = insets.top + insets.bottom;
        int n11 = n6 + n4 + n8;
        float f = dimension.height - (n10 + n11);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n12 = f4 <= 0.0f ? this.getMaximumThumbSize().height : (int)(f * (f3 / f4));
        n12 = Math.max(n12, this.getMinimumThumbSize().height);
        n12 = Math.min(n12, this.getMaximumThumbSize().height);
        int n13 = n7 - n12;
        if (f5 < (float)(jScrollBar.getMaximum() - jScrollBar.getVisibleAmount())) {
            float f6 = f - (float)n12;
            n13 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
            n13 += n9 + n8;
        }
        if ((n = dimension.height - n10) < n11) {
            n6 = n8 = n / 2;
            n4 = n8;
            n5 = dimension.height - (insets.bottom + n4);
        }
        this.decrButton.setBounds(n3, n9, n2, n8);
        this.mySecondDecreaseButton.setBounds(n3, n5 - n6, n2, n6);
        this.incrButton.setBounds(n3, n5 - 1, n2, n4 + 1);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        int n14 = n9 + n8;
        int n15 = n7 - n14;
        this.trackRect.setBounds(n3, n14, n2, n15);
        if (n12 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n13 + n12 > n7) {
                n13 = n7 - n12;
            }
            if (n13 < n9 + n8) {
                n13 = n9 + n8 + 1;
            }
            this.setThumbBounds(n3, n13, n2, n12);
        }
    }

    protected void layoutVScrollbarMultipleBoth(JScrollBar jScrollBar) {
        int n;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n2 = dimension.width - (insets.left + insets.right);
        int n3 = insets.left;
        int n4 = n2;
        int n5 = dimension.height - (insets.bottom + n4);
        int n6 = n2;
        int n7 = n5 - n6;
        int n8 = n2;
        int n9 = insets.top;
        int n10 = n2;
        int n11 = n9 + n8;
        int n12 = insets.top + insets.bottom;
        int n13 = n6 + n4 + n8 + n10;
        float f = dimension.height - (n12 + n13);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getVisibleAmount();
        float f4 = (float)jScrollBar.getMaximum() - f2;
        float f5 = jScrollBar.getValue();
        int n14 = f4 <= 0.0f ? this.getMaximumThumbSize().height : (int)(f * (f3 / f4));
        n14 = Math.max(n14, this.getMinimumThumbSize().height);
        n14 = Math.min(n14, this.getMaximumThumbSize().height);
        int n15 = n7 - n14;
        if (f5 < (float)(jScrollBar.getMaximum() - jScrollBar.getVisibleAmount())) {
            float f6 = f - (float)n14;
            n15 = (int)(0.5f + f6 * ((f5 - f2) / (f4 - f3)));
            n15 += n11 + n10;
        }
        if ((n = dimension.height - n12) < n13) {
            n8 = n10 = n / 4;
            n6 = n10;
            n4 = n10;
            n5 = dimension.height - (insets.bottom + n4);
        }
        this.decrButton.setBounds(n3, n9, n2, n8);
        this.mySecondDecreaseButton.setBounds(n3, n5 - n6, n2, n6);
        this.incrButton.setBounds(n3, n5 - 1, n2, n4 + 1);
        this.mySecondIncreaseButton.setBounds(n3, n9 + n8 - 1, n2, n10 + 1);
        int n16 = n11 + n10;
        int n17 = n7 - n16;
        this.trackRect.setBounds(n3, n16, n2, n17);
        if (n14 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n15 + n14 > n7) {
                n15 = n7 - n14;
            }
            if (n15 < n11 + n10) {
                n15 = n11 + n10 + 1;
            }
            this.setThumbBounds(n3, n15, n2, n14);
        }
    }

    protected void layoutHScrollbarAdjacent(JScrollBar jScrollBar) {
        int n;
        int n2;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n3 = dimension.height - (insets.top + insets.bottom);
        int n4 = insets.top;
        boolean bl = jScrollBar.getComponentOrientation().isLeftToRight();
        int n5 = n3;
        int n6 = n3;
        int n7 = bl ? dimension.width - (insets.right + n6) : insets.left;
        int n8 = bl ? n7 - n5 : n7 + n5;
        int n9 = insets.left + insets.right;
        int n10 = n5 + n6;
        float f = dimension.width - (n9 + n10);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getMaximum();
        float f4 = jScrollBar.getVisibleAmount();
        float f5 = f3 - f2;
        float f6 = jScrollBar.getValue();
        int n11 = f5 <= 0.0f ? this.getMaximumThumbSize().width : (int)(f * (f4 / f5));
        n11 = Math.max(n11, this.getMinimumThumbSize().width);
        n11 = Math.min(n11, this.getMaximumThumbSize().width);
        int n12 = n2 = bl ? n8 - n11 : insets.left;
        if (f6 < f3 - (float)jScrollBar.getVisibleAmount()) {
            float f7 = f - (float)n11;
            if (bl) {
                n2 = (int)(0.5f + f7 * ((f6 - f2) / (f5 - f4)));
            } else {
                n2 = (int)(0.5f + f7 * ((f3 - f4 - f6) / (f5 - f4)));
                n2 += n8 + n5;
            }
        }
        if ((n = dimension.width - n9) < n10) {
            n6 = n5 = n / 2;
            n7 = bl ? dimension.width - (insets.right + n6) : insets.left;
        }
        this.mySecondDecreaseButton.setBounds(n8 + (bl ? 0 : -1), n4, n5 + 1, n3);
        this.incrButton.setBounds(n7, n4, n6, n3);
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        if (bl) {
            int n13 = insets.left;
            int n14 = n8 - n13;
            this.trackRect.setBounds(n13, n4, n14, n3);
        } else {
            int n15 = n8 + n5;
            int n16 = dimension.width - n15;
            this.trackRect.setBounds(n15, n4, n16, n3);
        }
        if (n11 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (bl) {
                if (n2 + n11 > n8) {
                    n2 = n8 - n11;
                }
                if (n2 < 0) {
                    n2 = 1;
                }
            } else {
                if (n2 + n11 > dimension.width - insets.left) {
                    n2 = dimension.width - insets.left - n11;
                }
                if (n2 < n8 + n5) {
                    n2 = n8 + n5 + 1;
                }
            }
            this.setThumbBounds(n2, n4, n11, n3);
        }
    }

    protected void layoutHScrollbarNone(JScrollBar jScrollBar) {
        int n;
        int n2;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n3 = dimension.height - (insets.top + insets.bottom);
        int n4 = insets.top;
        boolean bl = jScrollBar.getComponentOrientation().isLeftToRight();
        int n5 = 0;
        int n6 = 0;
        int n7 = bl ? dimension.width - (insets.right + n6) : insets.left;
        int n8 = bl ? n7 - n5 : n7 + n5;
        int n9 = insets.left + insets.right;
        int n10 = n5 + n6;
        float f = dimension.width - (n9 + n10);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getMaximum();
        float f4 = jScrollBar.getVisibleAmount();
        float f5 = f3 - f2;
        float f6 = jScrollBar.getValue();
        int n11 = f5 <= 0.0f ? this.getMaximumThumbSize().width : (int)(f * (f4 / f5));
        n11 = Math.max(n11, this.getMinimumThumbSize().width);
        n11 = Math.min(n11, this.getMaximumThumbSize().width);
        int n12 = n2 = bl ? n8 - n11 : insets.left;
        if (f6 < f3 - (float)jScrollBar.getVisibleAmount()) {
            float f7 = f - (float)n11;
            if (bl) {
                n2 = (int)(0.5f + f7 * ((f6 - f2) / (f5 - f4)));
            } else {
                n2 = (int)(0.5f + f7 * ((f3 - f4 - f6) / (f5 - f4)));
                n2 += n8 + n5;
            }
        }
        if ((n = dimension.width - n9) < n10) {
            n5 = 0;
            n6 = 0;
        }
        this.incrButton.setBounds(0, 0, 0, 0);
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        if (bl) {
            int n13 = insets.left;
            int n14 = n8 - n13;
            this.trackRect.setBounds(n13, n4, n14, n3);
        } else {
            int n15 = n8 + n5;
            int n16 = dimension.width - n15;
            this.trackRect.setBounds(n15, n4, n16, n3);
        }
        if (n11 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (bl) {
                if (n2 + n11 > n8) {
                    n2 = n8 - n11;
                }
                if (n2 < 0) {
                    n2 = 1;
                }
            } else {
                if (n2 + n11 > dimension.width - insets.left) {
                    n2 = dimension.width - insets.left - n11;
                }
                if (n2 < n8 + n5) {
                    n2 = n8 + n5 + 1;
                }
            }
            this.setThumbBounds(n2, n4, n11, n3);
        }
    }

    protected void layoutHScrollbarMultiple(JScrollBar jScrollBar) {
        int n;
        int n2;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n3 = dimension.height - (insets.top + insets.bottom);
        int n4 = insets.top;
        boolean bl = jScrollBar.getComponentOrientation().isLeftToRight();
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        int n8 = bl ? dimension.width - (insets.right + n7) : insets.left;
        int n9 = bl ? n8 - n5 : n8 + n5;
        int n10 = bl ? insets.left : dimension.width - insets.right - n6;
        int n11 = insets.left + insets.right;
        int n12 = n5 + n7 + n6;
        float f = dimension.width - (n11 + n12);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getMaximum();
        float f4 = jScrollBar.getVisibleAmount();
        float f5 = f3 - f2;
        float f6 = jScrollBar.getValue();
        int n13 = f5 <= 0.0f ? this.getMaximumThumbSize().width : (int)(f * (f4 / f5));
        n13 = Math.max(n13, this.getMinimumThumbSize().width);
        n13 = Math.min(n13, this.getMaximumThumbSize().width);
        int n14 = n2 = bl ? n9 - n13 : insets.left;
        if (f6 < f3 - (float)jScrollBar.getVisibleAmount()) {
            float f7 = f - (float)n13;
            if (bl) {
                n2 = (int)(0.5f + f7 * ((f6 - f2) / (f5 - f4)));
                n2 += n10 + n6;
            } else {
                n2 = (int)(0.5f + f7 * ((f3 - f4 - f6) / (f5 - f4)));
                n2 += n9 + n5;
            }
        }
        if ((n = dimension.width - n11) < n12) {
            n5 = n6 = n / 2;
            n7 = n6;
            n8 = bl ? dimension.width - (insets.right + n7) : insets.left;
        }
        this.mySecondDecreaseButton.setBounds(n9 + (bl ? 0 : -1), n4, n5 + 1, n3);
        this.incrButton.setBounds(n8, n4, n7, n3);
        this.decrButton.setBounds(n10, n4, n6, n3);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        if (bl) {
            int n15 = n10 + n6;
            int n16 = n9 - n15;
            this.trackRect.setBounds(n15, n4, n16, n3);
        } else {
            int n17 = n9 + n5;
            int n18 = n10 - n17;
            this.trackRect.setBounds(n17, n4, n18, n3);
        }
        if (n13 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (bl) {
                if (n2 + n13 > n9) {
                    n2 = n9 - n13;
                }
                if (n2 < n10 + n6) {
                    n2 = n10 + n6 + 1;
                }
            } else {
                if (n2 + n13 > n10) {
                    n2 = n10 - n13;
                }
                if (n2 < n9 + n5) {
                    n2 = n9 + n5 + 1;
                }
            }
            this.setThumbBounds(n2, n4, n13, n3);
        }
    }

    protected void layoutHScrollbarMultipleBoth(JScrollBar jScrollBar) {
        int n;
        int n2;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n3 = dimension.height - (insets.top + insets.bottom);
        int n4 = insets.top;
        boolean bl = jScrollBar.getComponentOrientation().isLeftToRight();
        int n5 = n3;
        int n6 = n3;
        int n7 = n3;
        int n8 = n3;
        int n9 = bl ? dimension.width - (insets.right + n8) : insets.left;
        int n10 = bl ? n9 - n5 : n9 + n5;
        int n11 = bl ? insets.left : dimension.width - insets.right - n7;
        int n12 = bl ? n11 + n7 : n11 - n6;
        int n13 = insets.left + insets.right;
        int n14 = n5 + n8 + n7 + n6;
        float f = dimension.width - (n13 + n14);
        float f2 = jScrollBar.getMinimum();
        float f3 = jScrollBar.getMaximum();
        float f4 = jScrollBar.getVisibleAmount();
        float f5 = f3 - f2;
        float f6 = jScrollBar.getValue();
        int n15 = f5 <= 0.0f ? this.getMaximumThumbSize().width : (int)(f * (f4 / f5));
        n15 = Math.max(n15, this.getMinimumThumbSize().width);
        n15 = Math.min(n15, this.getMaximumThumbSize().width);
        int n16 = n2 = bl ? n10 - n15 : insets.left;
        if (f6 < f3 - (float)jScrollBar.getVisibleAmount()) {
            float f7 = f - (float)n15;
            if (bl) {
                n2 = (int)(0.5f + f7 * ((f6 - f2) / (f5 - f4)));
                n2 += n12 + n6;
            } else {
                n2 = (int)(0.5f + f7 * ((f3 - f4 - f6) / (f5 - f4)));
                n2 += n10 + n5;
            }
        }
        if ((n = dimension.width - n13) < n14) {
            n7 = n6 = n / 4;
            n5 = n6;
            n8 = n6;
            n9 = bl ? dimension.width - (insets.right + n8) : insets.left;
        }
        this.mySecondDecreaseButton.setBounds(n10 + (bl ? 0 : -1), n4, n5 + 1, n3);
        this.mySecondIncreaseButton.setBounds(n12 + (bl ? -1 : 0), n4, n6 + 1, n3);
        this.incrButton.setBounds(n9, n4, n8, n3);
        this.decrButton.setBounds(n11, n4, n7, n3);
        if (bl) {
            int n17 = n12 + n6;
            int n18 = n10 - n17;
            this.trackRect.setBounds(n17, n4, n18, n3);
        } else {
            int n19 = n10 + n5;
            int n20 = n12 - n19;
            this.trackRect.setBounds(n19, n4, n20, n3);
        }
        if (n15 >= (int)f) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (bl) {
                if (n2 + n15 > n10) {
                    n2 = n10 - n15;
                }
                if (n2 < n12 + n6) {
                    n2 = n12 + n6 + 1;
                }
            } else {
                if (n2 + n15 > n12) {
                    n2 = n12 - n15;
                }
                if (n2 < n10 + n5) {
                    n2 = n10 + n5 + 1;
                }
            }
            this.setThumbBounds(n2, n4, n15, n3);
        }
    }

    public static String getMemoryUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubstanceScrollBarUI: \n");
        stringBuffer.append("\t" + thumbHorizontalMap.size() + " thumb horizontal, " + thumbVerticalMap.size() + " thumb vertical");
        stringBuffer.append("\t" + trackHorizontalMap.size() + " track horizontal, " + trackVerticalMap.size() + " track vertical");
        return stringBuffer.toString();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new SubstanceTrackListener();
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new SubstanceArrowButtonListener();
    }

    private void updateThumbState(int n, int n2) {
        Rectangle rectangle = this.getThumbBounds();
        this.setThumbRollover(rectangle.contains(n, n2));
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, Math.max(48, 5 * this.scrollBarWidth));
        }
        return new Dimension(Math.max(48, 5 * this.scrollBarWidth), this.scrollBarWidth);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        super.update(graphics2D, jComponent);
        graphics2D.dispose();
        GhostPaintingUtils.paintGhostImages((Component)jComponent, (Graphics)graphics);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.installDefaultsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installComponents() {
        this.installComponentsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    protected void installListeners() {
        this.installListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallComponents() {
        this.uninstallComponentsInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.uninstallListenersInternal();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    private class CompositeButtonModel
    extends DefaultButtonModel {
        protected ButtonModel primaryModel;
        protected ButtonModel[] secondaryModels;
        protected ChangeListener listener;

        public CompositeButtonModel(ButtonModel buttonModel, AbstractButton ... abstractButtonArray) {
            this.primaryModel = buttonModel;
            LinkedList<ButtonModel> linkedList = new LinkedList<ButtonModel>();
            for (AbstractButton abstractButton : abstractButtonArray) {
                if (abstractButton == null) continue;
                linkedList.add(abstractButton.getModel());
            }
            this.secondaryModels = linkedList.toArray(new ButtonModel[0]);
            this.listener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    CompositeButtonModel.this.syncModels();
                }
            };
            this.syncModels();
        }

        private void syncModels() {
            this.setEnabled(this.primaryModel.isEnabled());
            this.setSelected(this.primaryModel.isSelected());
            boolean bl = this.primaryModel.isArmed();
            for (ButtonModel buttonModel : this.secondaryModels) {
                bl = bl || buttonModel.isArmed();
            }
            this.setArmed(bl);
            boolean bl2 = this.primaryModel.isPressed();
            for (ButtonModel buttonModel : this.secondaryModels) {
                bl2 = bl2 || buttonModel.isPressed();
            }
            this.setPressed(bl2);
            boolean bl3 = this.primaryModel.isRollover();
            for (ButtonModel buttonModel : this.secondaryModels) {
                bl3 = bl3 || buttonModel.isRollover();
            }
            this.setRollover(bl3);
        }

        public void registerListeners() {
            this.primaryModel.addChangeListener(this.listener);
            for (ButtonModel buttonModel : this.secondaryModels) {
                buttonModel.addChangeListener(this.listener);
            }
        }

        public void unregisterListeners() {
            this.primaryModel.removeChangeListener(this.listener);
            for (ButtonModel buttonModel : this.secondaryModels) {
                buttonModel.removeChangeListener(this.listener);
            }
            this.listener = null;
        }
    }

    protected class SubstanceTrackListener
    extends BasicScrollBarUI.TrackListener {
        private transient int direction;

        protected SubstanceTrackListener() {
            super(SubstanceScrollBarUI.this);
            this.direction = 1;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            Rectangle rectangle = SubstanceScrollBarUI.this.getTrackBounds();
            SubstanceScrollBarUI.this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            SubstanceScrollBarUI.this.trackHighlight = 0;
            SubstanceScrollBarUI.this.isDragging = false;
            this.offset = 0;
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.hasFocus() && SubstanceScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SubstanceScrollBarUI.this.scrollbar.requestFocus();
            }
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (SubstanceScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x;
                    }
                }
                SubstanceScrollBarUI.this.isDragging = true;
                return;
            }
            if (SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().height / 2;
                        break;
                    }
                    case 0: {
                        this.offset = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().width / 2;
                    }
                }
                SubstanceScrollBarUI.this.isDragging = true;
                this.setValueFrom(mouseEvent);
                return;
            }
            SubstanceScrollBarUI.this.isDragging = false;
            Dimension dimension = SubstanceScrollBarUI.this.scrollbar.getSize();
            this.direction = 1;
            switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int n = dimension.height / 2;
                        this.direction = this.currentMouseY < n ? -1 : 1;
                        break;
                    }
                    int n = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y;
                    this.direction = this.currentMouseY < n ? -1 : 1;
                    break;
                }
                case 0: {
                    if (SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int n = dimension.width / 2;
                        this.direction = this.currentMouseX < n ? -1 : 1;
                    } else {
                        int n = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x;
                        int n2 = this.direction = this.currentMouseX < n ? -1 : 1;
                    }
                    if (SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) break;
                    this.direction = -this.direction;
                }
            }
            SubstanceScrollBarUI.this.scrollByBlock(this.direction);
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollListener.setDirection(this.direction);
            SubstanceScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled() || SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            if (SubstanceScrollBarUI.this.isDragging) {
                this.setValueFrom(mouseEvent);
            } else {
                this.currentMouseX = mouseEvent.getX();
                this.currentMouseY = mouseEvent.getY();
                SubstanceScrollBarUI.this.updateThumbState(this.currentMouseX, this.currentMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        private void setValueFrom(MouseEvent mouseEvent) {
            int n;
            boolean bl = SubstanceScrollBarUI.this.isThumbRollover();
            BoundedRangeModel boundedRangeModel = SubstanceScrollBarUI.this.scrollbar.getModel();
            Rectangle rectangle = SubstanceScrollBarUI.this.getThumbBounds();
            int n2 = 0;
            int n3 = 0;
            SubstanceConstants.ScrollPaneButtonPolicyKind scrollPaneButtonPolicyKind = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(SubstanceScrollBarUI.this.scrollbar);
            if (SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1) {
                switch (scrollPaneButtonPolicyKind) {
                    case OPPOSITE: {
                        n2 = SubstanceScrollBarUI.this.decrButton.getY() + SubstanceScrollBarUI.this.decrButton.getHeight();
                        n3 = SubstanceScrollBarUI.this.incrButton.getY() - rectangle.height;
                        break;
                    }
                    case ADJACENT: {
                        n2 = 0;
                        n3 = SubstanceScrollBarUI.this.mySecondDecreaseButton.getY() - rectangle.height;
                        break;
                    }
                    case NONE: {
                        n2 = 0;
                        n3 = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().height - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().bottom - rectangle.height;
                        break;
                    }
                    case MULTIPLE: {
                        n2 = SubstanceScrollBarUI.this.decrButton.getY() + SubstanceScrollBarUI.this.decrButton.getHeight();
                        n3 = SubstanceScrollBarUI.this.mySecondDecreaseButton.getY() - rectangle.height;
                        break;
                    }
                    case MULTIPLE_BOTH: {
                        n2 = SubstanceScrollBarUI.this.mySecondIncreaseButton.getY() + SubstanceScrollBarUI.this.mySecondIncreaseButton.getHeight();
                        n3 = SubstanceScrollBarUI.this.mySecondDecreaseButton.getY() - rectangle.height;
                    }
                }
                n = Math.min(n3, Math.max(n2, mouseEvent.getY() - this.offset));
                SubstanceScrollBarUI.this.setThumbBounds(rectangle.x, n, rectangle.width, rectangle.height);
            } else {
                if (SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    switch (scrollPaneButtonPolicyKind) {
                        case OPPOSITE: {
                            n2 = SubstanceScrollBarUI.this.decrButton.getX() + SubstanceScrollBarUI.this.decrButton.getWidth();
                            n3 = SubstanceScrollBarUI.this.incrButton.getX() - rectangle.width;
                            break;
                        }
                        case ADJACENT: {
                            n2 = 0;
                            n3 = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() - rectangle.width;
                            break;
                        }
                        case MULTIPLE: {
                            n2 = SubstanceScrollBarUI.this.decrButton.getX() + SubstanceScrollBarUI.this.decrButton.getWidth();
                            n3 = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() - rectangle.width;
                            break;
                        }
                        case MULTIPLE_BOTH: {
                            n2 = SubstanceScrollBarUI.this.mySecondIncreaseButton.getX() + SubstanceScrollBarUI.this.mySecondIncreaseButton.getWidth();
                            n3 = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() - rectangle.width;
                            break;
                        }
                        case NONE: {
                            n2 = 0;
                            n3 = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - rectangle.width;
                        }
                    }
                } else {
                    switch (scrollPaneButtonPolicyKind) {
                        case OPPOSITE: {
                            n2 = SubstanceScrollBarUI.this.incrButton.getX() + SubstanceScrollBarUI.this.incrButton.getWidth();
                            n3 = SubstanceScrollBarUI.this.decrButton.getX() - rectangle.width;
                            break;
                        }
                        case ADJACENT: {
                            n2 = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() + SubstanceScrollBarUI.this.mySecondDecreaseButton.getWidth();
                            n3 = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - rectangle.width;
                            break;
                        }
                        case MULTIPLE: {
                            n2 = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() + SubstanceScrollBarUI.this.mySecondDecreaseButton.getWidth();
                            n3 = SubstanceScrollBarUI.this.decrButton.getX() - rectangle.width;
                            break;
                        }
                        case MULTIPLE_BOTH: {
                            n2 = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() + SubstanceScrollBarUI.this.mySecondDecreaseButton.getWidth();
                            n3 = SubstanceScrollBarUI.this.mySecondIncreaseButton.getX() - rectangle.width;
                            break;
                        }
                        case NONE: {
                            n2 = 0;
                            n3 = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - rectangle.width;
                        }
                    }
                }
                n = Math.min(n3, Math.max(n2, mouseEvent.getX() - this.offset));
                SubstanceScrollBarUI.this.setThumbBounds(n, rectangle.y, rectangle.width, rectangle.height);
            }
            if (n == n3) {
                if (SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1 || SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    SubstanceScrollBarUI.this.scrollbar.setValue(boundedRangeModel.getMaximum() - boundedRangeModel.getExtent());
                } else {
                    SubstanceScrollBarUI.this.scrollbar.setValue(boundedRangeModel.getMinimum());
                }
            } else {
                float f = boundedRangeModel.getMaximum() - boundedRangeModel.getExtent();
                float f2 = f - (float)boundedRangeModel.getMinimum();
                float f3 = n - n2;
                float f4 = n3 - n2;
                int n4 = SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1 || SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(f3 / f4 * f2)) : (int)(0.5 + (double)((float)(n3 - n) / f4 * f2));
                SubstanceScrollBarUI.this.scrollbar.setValue(n4 + boundedRangeModel.getMinimum());
            }
            SubstanceScrollBarUI.this.setThumbRollover(bl);
        }

        private void startScrollTimerIfNecessary() {
            if (SubstanceScrollBarUI.this.scrollTimer.isRunning()) {
                return;
            }
            switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (this.direction > 0) {
                        if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y + ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().height >= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseY) break;
                        SubstanceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y <= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseY) break;
                    SubstanceScrollBarUI.this.scrollTimer.start();
                    break;
                }
                case 0: {
                    if (this.direction > 0) {
                        if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x + ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().width >= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseX) break;
                        SubstanceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x <= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseX) break;
                    SubstanceScrollBarUI.this.scrollTimer.start();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.setThumbRollover(false);
            }
        }
    }

    protected class SubstanceArrowButtonListener
    extends BasicScrollBarUI.ArrowButtonListener {
        boolean handledEvent;

        protected SubstanceArrowButtonListener() {
            super(SubstanceScrollBarUI.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n = mouseEvent.getSource() == SubstanceScrollBarUI.this.incrButton || mouseEvent.getSource() == SubstanceScrollBarUI.this.mySecondIncreaseButton ? 1 : -1;
            SubstanceScrollBarUI.this.scrollByUnit(n);
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollListener.setDirection(n);
            SubstanceScrollBarUI.this.scrollListener.setScrollByBlock(false);
            SubstanceScrollBarUI.this.scrollTimer.start();
            this.handledEvent = true;
            if (!SubstanceScrollBarUI.this.scrollbar.hasFocus() && SubstanceScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SubstanceScrollBarUI.this.scrollbar.requestFocus();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            SubstanceScrollBarUI.this.scrollTimer.stop();
            this.handledEvent = false;
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }
    }
}

