/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.table.JTableHeader;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceTableHeaderUI;
import org.pushingpixels.substance.internal.ui.SubstanceTreeUI;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollPaneBorder;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.callback.UIThreadTimelineCallbackAdapter;
import org.pushingpixels.trident.ease.TimelineEase;

public class SubstanceScrollPaneUI
extends BasicScrollPaneUI {
    protected PropertyChangeListener substancePropertyChangeListener;
    protected ChangeListener substanceVerticalScrollbarChangeListener;
    protected Timeline horizontalScrollTimeline;
    protected Set lafWidgets;

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceScrollPaneUI();
    }

    private void installDefaultsInternal(final JScrollPane jScrollPane) {
        super.installDefaults(jScrollPane);
        if (SubstanceCoreUtilities.toDrawWatermark(jScrollPane) && SubstanceLookAndFeel.getCurrentSkin(jScrollPane).getWatermark() != null) {
            jScrollPane.setOpaque(false);
            jScrollPane.getViewport().setOpaque(false);
        }
        jScrollPane.setLayout(new AdjustedLayout((ScrollPaneLayout)jScrollPane.getLayout()));
        jScrollPane.setBorder(new LineBorder(new Color(216, 216, 216), (int)SubstanceSizeUtils.getBorderStrokeWidth(1)));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SubstanceScrollPaneUI.installTableHeaderCornerFiller(jScrollPane);
            }
        });
    }

    private void uninstallDefaultsInternal(JScrollPane jScrollPane) {
        LayoutManager layoutManager;
        Component component;
        Component component2 = jScrollPane.getCorner("UPPER_RIGHT_CORNER");
        if (component2 instanceof UIResource) {
            jScrollPane.setCorner("UPPER_RIGHT_CORNER", null);
        }
        if ((component = jScrollPane.getCorner("UPPER_LEFT_CORNER")) instanceof UIResource) {
            jScrollPane.setCorner("UPPER_LEFT_CORNER", null);
        }
        if ((layoutManager = this.scrollpane.getLayout()) instanceof AdjustedLayout) {
            jScrollPane.setLayout(((AdjustedLayout)layoutManager).delegate);
        }
        super.uninstallDefaults(jScrollPane);
    }

    private void installListenersInternal(final JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Color color;
                ScrollPaneLayout scrollPaneLayout;
                Component component;
                if ("substancelaf.scrollPaneButtonsPolicy".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jScrollPane.getHorizontalScrollBar().doLayout();
                            jScrollPane.getVerticalScrollBar().doLayout();
                        }
                    });
                }
                if ("substancelaf.watermark.visible".equals(propertyChangeEvent.getPropertyName())) {
                    boolean bl = SubstanceCoreUtilities.toDrawWatermark(jScrollPane);
                    jScrollPane.setOpaque(!bl);
                    jScrollPane.getViewport().setOpaque(!bl);
                    component = jScrollPane.getViewport().getView();
                    if (component instanceof JComponent) {
                        ((JComponent)component).setOpaque(!bl);
                    }
                }
                if ("layoutManager".equals(propertyChangeEvent.getPropertyName()) && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue() && !((scrollPaneLayout = (ScrollPaneLayout)jScrollPane.getLayout()) instanceof AdjustedLayout)) {
                    jScrollPane.setLayout(new AdjustedLayout((ScrollPaneLayout)jScrollPane.getLayout()));
                }
                if ("background".equals(propertyChangeEvent.getPropertyName()) && !((color = (Color)propertyChangeEvent.getNewValue()) instanceof UIResource)) {
                    JScrollBar jScrollBar;
                    component = SubstanceScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                    if (component != null && component.getBackground() instanceof UIResource) {
                        ((JComponent)component).setBackground(color);
                    }
                    if ((jScrollBar = SubstanceScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && jScrollBar.getBackground() instanceof UIResource) {
                        jScrollBar.setBackground(color);
                    }
                }
                if ("columnHeader".equals(propertyChangeEvent.getPropertyName()) || "componentOrientation".equals(propertyChangeEvent.getPropertyName()) || "ancestor".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (SubstanceScrollPaneUI.this.scrollpane != null) {
                                SubstanceScrollPaneUI.installTableHeaderCornerFiller(SubstanceScrollPaneUI.this.scrollpane);
                            }
                        }
                    });
                }
            }
        };
        jScrollPane.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceVerticalScrollbarChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (jScrollPane.getHorizontalScrollBar() != null && jScrollPane.getHorizontalScrollBar().isVisible() && jScrollPane.getViewport().getView() instanceof JTree) {
                    JTree jTree = (JTree)jScrollPane.getViewport().getView();
                    if (AnimationConfigurationManager.getInstance().isAnimationAllowed(SubstanceLookAndFeel.TREE_SMART_SCROLL_ANIMATION_KIND, (Component)jTree)) {
                        int n;
                        int n2;
                        Rectangle rectangle;
                        SubstanceTreeUI substanceTreeUI = (SubstanceTreeUI)jTree.getUI();
                        int n3 = substanceTreeUI.getPivotRendererX(rectangle = jScrollPane.getViewport().getViewRect());
                        int n4 = n3 - (n2 = rectangle.x);
                        int n5 = rectangle.x + n4;
                        if (n5 < 0) {
                            n4 -= n5;
                        }
                        if (Math.abs(n = n4) > rectangle.width / 6) {
                            if (SubstanceScrollPaneUI.this.horizontalScrollTimeline != null) {
                                SubstanceScrollPaneUI.this.horizontalScrollTimeline.abort();
                            }
                            SubstanceScrollPaneUI.this.horizontalScrollTimeline = new Timeline((Object)jTree);
                            SubstanceScrollPaneUI.this.horizontalScrollTimeline.addCallback((TimelineCallback)new UIThreadTimelineCallbackAdapter(){

                                public void onTimelinePulse(float f, float f2) {
                                    if ((double)f2 >= 0.5) {
                                        int n2 = (int)((double)n * ((double)f2 - 0.5));
                                        jScrollPane.getViewport().setViewPosition(new Point(rectangle.x + n2, rectangle.y));
                                    }
                                }
                            });
                            SubstanceScrollPaneUI.this.horizontalScrollTimeline.setEase(new TimelineEase(){

                                public float map(float f) {
                                    if ((double)f < 0.5) {
                                        return 0.5f * f;
                                    }
                                    return 0.25f + (f - 0.5f) * 0.75f / 0.5f;
                                }
                            });
                            AnimationConfigurationManager.getInstance().configureTimeline(SubstanceScrollPaneUI.this.horizontalScrollTimeline);
                            SubstanceScrollPaneUI.this.horizontalScrollTimeline.setDuration(2L * SubstanceScrollPaneUI.this.horizontalScrollTimeline.getDuration());
                            SubstanceScrollPaneUI.this.horizontalScrollTimeline.play();
                        }
                    }
                }
            }
        };
        jScrollPane.getVerticalScrollBar().getModel().addChangeListener(this.substanceVerticalScrollbarChangeListener);
    }

    private void uninstallListenersInternal(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        jScrollPane.getVerticalScrollBar().getModel().removeChangeListener(this.substanceVerticalScrollbarChangeListener);
        this.substanceVerticalScrollbarChangeListener = null;
        super.uninstallListeners(jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints((Graphics2D)graphics2D, (Component)jComponent);
        this.updateInternal(graphics2D, jComponent);
        graphics2D.dispose();
    }

    private void updateInternal(Graphics graphics, JComponent jComponent) {
        BackgroundPaintingUtils.updateIfOpaque(graphics, jComponent);
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        LayoutManager layoutManager = jScrollPane.getLayout();
        ScrollPaneLayout scrollPaneLayout = null;
        if (layoutManager instanceof ScrollPaneLayout) {
            scrollPaneLayout = (ScrollPaneLayout)layoutManager;
        }
        if (scrollPaneLayout != null) {
            HashSet<Component> hashSet = new HashSet<Component>();
            if (scrollPaneLayout.getCorner("LOWER_LEFT_CORNER") != null) {
                hashSet.add(scrollPaneLayout.getCorner("LOWER_LEFT_CORNER"));
            }
            if (scrollPaneLayout.getCorner("LOWER_RIGHT_CORNER") != null) {
                hashSet.add(scrollPaneLayout.getCorner("LOWER_RIGHT_CORNER"));
            }
            if (scrollPaneLayout.getCorner("UPPER_LEFT_CORNER") != null) {
                hashSet.add(scrollPaneLayout.getCorner("UPPER_LEFT_CORNER"));
            }
            if (scrollPaneLayout.getCorner("UPPER_RIGHT_CORNER") != null) {
                hashSet.add(scrollPaneLayout.getCorner("UPPER_RIGHT_CORNER"));
            }
            if (SubstanceCoreUtilities.isOpaque(jComponent)) {
                for (Component component : hashSet) {
                    BackgroundPaintingUtils.fillAndWatermark(graphics, jComponent, jComponent.getBackground(), component.getBounds());
                }
            }
        }
        super.paint(graphics, jComponent);
    }

    protected static void installTableHeaderCornerFiller(JScrollPane jScrollPane) {
        boolean bl;
        JViewport jViewport = jScrollPane.getColumnHeader();
        if (jViewport == null) {
            return;
        }
        Component component = jViewport.getView();
        if (!(component instanceof JTableHeader)) {
            return;
        }
        JTableHeader jTableHeader = (JTableHeader)component;
        TableHeaderUI tableHeaderUI = jTableHeader.getUI();
        if (!(tableHeaderUI instanceof SubstanceTableHeaderUI)) {
            return;
        }
        SubstanceTableHeaderUI substanceTableHeaderUI = (SubstanceTableHeaderUI)tableHeaderUI;
        JComponent jComponent = substanceTableHeaderUI.getScrollPaneCornerFiller();
        String string = jScrollPane.getComponentOrientation().isLeftToRight() ? "UPPER_RIGHT_CORNER" : "UPPER_LEFT_CORNER";
        Component component2 = jScrollPane.getCorner(string);
        boolean bl2 = bl = component2 == null || component2 instanceof UIResource;
        if (bl) {
            jScrollPane.setCorner(string, jComponent);
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        super.installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults(JScrollPane jScrollPane) {
        this.installDefaultsInternal(jScrollPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners(JScrollPane jScrollPane) {
        this.installListenersInternal(jScrollPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults(JScrollPane jScrollPane) {
        this.uninstallDefaultsInternal(jScrollPane);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        this.uninstallListenersInternal(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        return new WheelHandler();
    }

    private static void scrollByUnits(JScrollBar jScrollBar, int n, int n2, boolean bl) {
        int n3 = -1;
        if (bl) {
            n3 = n < 0 ? jScrollBar.getValue() - jScrollBar.getBlockIncrement(n) : jScrollBar.getValue() + jScrollBar.getBlockIncrement(n);
        }
        for (int i = 0; i < n2; ++i) {
            int n4 = n > 0 ? jScrollBar.getUnitIncrement(n) : -jScrollBar.getUnitIncrement(n);
            int n5 = jScrollBar.getValue();
            int n6 = n5 + n4;
            if (n4 > 0 && n6 < n5) {
                n6 = jScrollBar.getMaximum();
            } else if (n4 < 0 && n6 > n5) {
                n6 = jScrollBar.getMinimum();
            }
            if (n5 == n6) break;
            if (bl && i > 0) {
                assert (n3 != -1);
                if (n < 0 && n6 < n3 || n > 0 && n6 > n3) break;
            }
            jScrollBar.setValue(n6);
        }
    }

    private static void scrollByBlock(JScrollBar jScrollBar, int n) {
        int n2 = jScrollBar.getValue();
        int n3 = jScrollBar.getBlockIncrement(n);
        int n4 = n3 * (n > 0 ? 1 : -1);
        int n5 = n2 + n4;
        if (n4 > 0 && n5 < n2) {
            n5 = jScrollBar.getMaximum();
        } else if (n4 < 0 && n5 > n2) {
            n5 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n5);
    }

    protected static class AdjustedLayout
    extends ScrollPaneLayout
    implements UIResource {
        protected ScrollPaneLayout delegate;

        public AdjustedLayout(ScrollPaneLayout scrollPaneLayout) {
            this.delegate = scrollPaneLayout;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.delegate.addLayoutComponent(string, component);
        }

        public boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        @Override
        public JViewport getColumnHeader() {
            return this.delegate.getColumnHeader();
        }

        @Override
        public Component getCorner(String string) {
            return this.delegate.getCorner(string);
        }

        @Override
        public JScrollBar getHorizontalScrollBar() {
            return this.delegate.getHorizontalScrollBar();
        }

        @Override
        public int getHorizontalScrollBarPolicy() {
            return this.delegate.getHorizontalScrollBarPolicy();
        }

        @Override
        public JViewport getRowHeader() {
            return this.delegate.getRowHeader();
        }

        @Override
        public JScrollBar getVerticalScrollBar() {
            return this.delegate.getVerticalScrollBar();
        }

        @Override
        public int getVerticalScrollBarPolicy() {
            return this.delegate.getVerticalScrollBarPolicy();
        }

        @Override
        public JViewport getViewport() {
            return this.delegate.getViewport();
        }

        @Override
        public Rectangle getViewportBorderBounds(JScrollPane jScrollPane) {
            return this.delegate.getViewportBorderBounds(jScrollPane);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.delegate.minimumLayoutSize(container);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.delegate.preferredLayoutSize(container);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.delegate.removeLayoutComponent(component);
        }

        @Override
        public void setHorizontalScrollBarPolicy(int n) {
            this.delegate.setHorizontalScrollBarPolicy(n);
        }

        @Override
        public void setVerticalScrollBarPolicy(int n) {
            this.delegate.setVerticalScrollBarPolicy(n);
        }

        @Override
        public void syncWithScrollPane(JScrollPane jScrollPane) {
            this.delegate.syncWithScrollPane(jScrollPane);
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void layoutContainer(Container container) {
            this.delegate.layoutContainer(container);
            JScrollPane jScrollPane = (JScrollPane)container;
            Border border = jScrollPane.getBorder();
            boolean bl = border instanceof SubstanceScrollPaneBorder;
            if (bl) {
                Rectangle rectangle;
                JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
                int n = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jScrollPane)) / 2.0);
                int n2 = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(jScrollPane));
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                if (jScrollPane.getComponentOrientation().isLeftToRight()) {
                    if (jScrollBar != null && jScrollBar.isVisible()) {
                        rectangle = jScrollBar.getBounds();
                        n5 += 1 + n;
                        jScrollBar.setBounds(rectangle.x + 1 + n, rectangle.y + 1 - 2 * n2, rectangle.width, rectangle.height + 2 * n2);
                    }
                    if (jScrollBar2 != null && jScrollBar2.isVisible()) {
                        n6 += 1 + n;
                        rectangle = jScrollBar2.getBounds();
                        jScrollBar2.setBounds(rectangle.x + (jScrollPane.getRowHeader() == null ? 1 : 2) - 2 * n2, rectangle.y + 1, rectangle.width + 2 * n2, rectangle.height);
                    }
                    if (this.delegate.getCorner("LOWER_RIGHT_CORNER") != null) {
                        rectangle = this.delegate.getCorner("LOWER_RIGHT_CORNER").getBounds();
                        this.delegate.getCorner("LOWER_RIGHT_CORNER").setBounds(rectangle.x + 1 + n, rectangle.y + 1 + n, rectangle.width, rectangle.height);
                    }
                    if (this.delegate.getCorner("UPPER_RIGHT_CORNER") != null) {
                        rectangle = this.delegate.getCorner("UPPER_RIGHT_CORNER").getBounds();
                        this.delegate.getCorner("UPPER_RIGHT_CORNER").setBounds(rectangle.x + 1 + n, rectangle.y + n, rectangle.width - 1, rectangle.height);
                    }
                } else {
                    if (jScrollBar != null && jScrollBar.isVisible()) {
                        n3 -= 1 + n;
                        n5 += 1 + n;
                        rectangle = jScrollBar.getBounds();
                        jScrollBar.setBounds(rectangle.x - 1 - n, rectangle.y - 1 - n, rectangle.width, rectangle.height + 2 * n2);
                    }
                    if (jScrollBar2 != null && jScrollBar2.isVisible()) {
                        n6 += 1 + n;
                        rectangle = jScrollBar2.getBounds();
                        jScrollBar2.setBounds(rectangle.x - (jScrollPane.getRowHeader() == null ? 1 : 2) - n, rectangle.y + 1 + n, rectangle.width + 2 * n2, rectangle.height);
                    }
                    if (this.delegate.getCorner("LOWER_LEFT_CORNER") != null) {
                        rectangle = this.delegate.getCorner("LOWER_LEFT_CORNER").getBounds();
                        this.delegate.getCorner("LOWER_LEFT_CORNER").setBounds(rectangle.x - 1 - n, rectangle.y - 1 - n, rectangle.width, rectangle.height);
                    }
                    if (this.delegate.getCorner("UPPER_LEFT_CORNER") != null) {
                        rectangle = this.delegate.getCorner("UPPER_LEFT_CORNER").getBounds();
                        this.delegate.getCorner("UPPER_LEFT_CORNER").setBounds(rectangle.x - n, rectangle.y - n, rectangle.width - 1, rectangle.height);
                    }
                }
                if (this.delegate.getViewport() != null) {
                    rectangle = this.delegate.getViewport().getBounds();
                    this.delegate.getViewport().setBounds(new Rectangle(rectangle.x + n3, rectangle.y + n4, rectangle.width + n5, rectangle.height + n6));
                }
                if (this.delegate.getColumnHeader() != null) {
                    rectangle = this.delegate.getColumnHeader().getBounds();
                    this.delegate.getColumnHeader().setBounds(new Rectangle(rectangle.x + n3, rectangle.y + n4, rectangle.width + n5, rectangle.height));
                }
            }
        }
    }

    private class WheelHandler
    implements MouseWheelListener {
        private WheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (SubstanceScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getWheelRotation() != 0) {
                int n;
                boolean bl = mouseWheelEvent.isShiftDown();
                JScrollBar jScrollBar = bl ? SubstanceScrollPaneUI.this.scrollpane.getHorizontalScrollBar() : SubstanceScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                int n2 = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
                int n3 = n = bl ? 0 : 1;
                if (jScrollBar == null || !jScrollBar.isVisible()) {
                    JScrollBar jScrollBar2 = jScrollBar = bl ? SubstanceScrollPaneUI.this.scrollpane.getVerticalScrollBar() : SubstanceScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (jScrollBar == null || !jScrollBar.isVisible()) {
                        return;
                    }
                    n = bl ? 1 : 0;
                }
                mouseWheelEvent.consume();
                if (mouseWheelEvent.getScrollType() == 0) {
                    JViewport jViewport = SubstanceScrollPaneUI.this.scrollpane.getViewport();
                    if (jViewport == null) {
                        return;
                    }
                    Component component = jViewport.getView();
                    int n4 = Math.abs(mouseWheelEvent.getUnitsToScroll());
                    boolean bl2 = Math.abs(mouseWheelEvent.getWheelRotation()) == 1;
                    Object object = jScrollBar.getClientProperty("JScrollBar.fastWheelScrolling");
                    if (Boolean.TRUE == object && component instanceof Scrollable) {
                        int n5;
                        Scrollable scrollable = (Scrollable)((Object)component);
                        Rectangle rectangle = jViewport.getViewRect();
                        int n6 = rectangle.x;
                        boolean bl3 = component.getComponentOrientation().isLeftToRight();
                        int n7 = jScrollBar.getMinimum();
                        int n8 = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent();
                        if (bl2) {
                            n5 = scrollable.getScrollableBlockIncrement(rectangle, n, n2);
                            if (n2 < 0) {
                                n7 = Math.max(n7, jScrollBar.getValue() - n5);
                            } else {
                                n8 = Math.min(n8, jScrollBar.getValue() + n5);
                            }
                        }
                        for (n5 = 0; n5 < n4; ++n5) {
                            int n9 = scrollable.getScrollableUnitIncrement(rectangle, n, n2);
                            if (n == 1) {
                                if (n2 < 0) {
                                    rectangle.y -= n9;
                                    if (rectangle.y > n7) continue;
                                    rectangle.y = n7;
                                    break;
                                }
                                rectangle.y += n9;
                                if (rectangle.y < n8) continue;
                                rectangle.y = n8;
                                break;
                            }
                            if (bl3 && n2 < 0 || !bl3 && n2 > 0) {
                                rectangle.x -= n9;
                                if (!bl3 || rectangle.x >= n7) continue;
                                rectangle.x = n7;
                                break;
                            }
                            if ((!bl3 || n2 <= 0) && (bl3 || n2 >= 0)) continue;
                            rectangle.x += n9;
                            if (!bl3 || rectangle.x <= n8) continue;
                            rectangle.x = n8;
                            break;
                        }
                        if (n == 1) {
                            jScrollBar.setValue(rectangle.y);
                        } else if (bl3) {
                            jScrollBar.setValue(rectangle.x);
                        } else {
                            n5 = jScrollBar.getValue() - (rectangle.x - n6);
                            if (n5 < n7) {
                                n5 = n7;
                            } else if (n5 > n8) {
                                n5 = n8;
                            }
                            jScrollBar.setValue(n5);
                        }
                    } else {
                        SubstanceScrollPaneUI.scrollByUnits(jScrollBar, n2, n4, bl2);
                    }
                } else if (mouseWheelEvent.getScrollType() == 1) {
                    SubstanceScrollPaneUI.scrollByBlock(jScrollBar, n2);
                }
            }
        }
    }
}

